/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import org.eclipse.core.resources.IResource;
import org.eclipse.wst.validation.internal.ValidatorActionFilter;
import org.eclipse.wst.validation.internal.ValidatorNameFilter;
import org.eclipse.wst.validation.internal.ValidatorTypeFilter;

public class ValidatorFilter {
    private ValidatorNameFilter _nameFilter = new ValidatorNameFilter();
    private ValidatorTypeFilter _typeFilter = new ValidatorTypeFilter();
    private ValidatorActionFilter _actionFilter = new ValidatorActionFilter();

    ValidatorFilter() {
    }

    ValidatorFilter(String mustImplementClass) {
        this();
        this._nameFilter = new ValidatorNameFilter();
        this._typeFilter.setMustImplementClass(mustImplementClass);
        this._actionFilter = new ValidatorActionFilter();
    }

    public boolean isApplicableAction(int resourceDelta) {
        return (resourceDelta & this._actionFilter.getActionType()) != 0;
    }

    boolean isApplicableName(IResource resource) {
        return this._nameFilter.isApplicableName(resource);
    }

    boolean isApplicableType(IResource resource) {
        return this._typeFilter.isApplicableType(resource);
    }

    public void setActionFilter(String actions) {
        this._actionFilter.setActionTypes(actions);
    }

    void setNameFilter(String filter, String isCaseSensitiveString) {
        this._nameFilter.setNameFilter(filter);
        if (filter != null) {
            this._nameFilter.setNameFilterExtension(this.getFilterExt(filter));
        }
        this._nameFilter.setCaseSensitive(isCaseSensitiveString);
    }

    private String getFilterExt(String filter) {
        return filter.substring(filter.indexOf(".") + 1);
    }

    void setTypeFilter(String filter) {
        this._typeFilter.setTypeFilter(filter);
    }

    public String toString() {
        String lineSep = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        buffer.append("ValidatorFilter:");
        buffer.append(lineSep);
        buffer.append("     nameFilter = " + this._nameFilter);
        buffer.append(lineSep);
        buffer.append("     typeFilter = " + this._typeFilter);
        buffer.append(lineSep);
        buffer.append("     actionFilter = " + this._actionFilter);
        buffer.append(lineSep);
        return buffer.toString();
    }

    public ValidatorNameFilter get_nameFilter() {
        return this._nameFilter;
    }
}

