/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.export.impl;

import java.util.List;
import org.fao.fi.fishstat.export.ExportData;
import org.fao.fi.fishstat.export.ExportDataItem;
import org.fao.fi.fishstat.export.ExportDecorators;
import org.fao.fi.fishstat.export.ExportEnvelope;
import org.fao.fi.fishstat.export.ExportMetadata;
import org.fao.fi.fishstat.export.StructuredDataProvider;
import org.fao.fi.fishstat.export.impl.ExportDataImpl;

public class ExportEnvelopeImpl<T>
implements ExportEnvelope<T> {
    private StructuredDataProvider<T> provider;
    private ExportMetadata metadata;
    private List<String> keyLabels;
    private List<String> keyAttributeLabels;
    private List<String> mesLabels;
    private List<String> mesAttributeLabels;
    private List<String> clcLabels;
    private List<String> clcAttributeLabels;

    public ExportEnvelopeImpl(StructuredDataProvider<T> provider, ExportMetadata metadata) {
        this.provider = provider;
        this.metadata = metadata;
        this.keyLabels = provider.getLabels(1);
        this.keyAttributeLabels = provider.getAttributes(1);
        this.mesLabels = provider.getLabels(2);
        this.mesAttributeLabels = provider.getAttributes(2);
        this.clcLabels = provider.getLabels(3);
        this.clcAttributeLabels = provider.getAttributes(3);
    }

    @Override
    public List<String> getKeyLabels() {
        return this.keyLabels;
    }

    @Override
    public List<String> getKeyAttributeLabels() {
        return this.keyAttributeLabels;
    }

    @Override
    public List<String> getMesLabels() {
        return this.mesLabels;
    }

    @Override
    public List<String> getMesAttributeLabels() {
        return this.mesAttributeLabels;
    }

    @Override
    public List<String> getClcLabels() {
        return this.clcLabels;
    }

    @Override
    public List<String> getClcAttributeLabels() {
        return this.clcAttributeLabels;
    }

    @Override
    public int itemCount() {
        return this.provider.itemCount();
    }

    @Override
    public void setKeyLabels(List<String> labels) {
        this.keyLabels = labels;
    }

    @Override
    public void setKeyAttributeLabels(List<String> keyAttributeLabels) {
        this.keyAttributeLabels = keyAttributeLabels;
    }

    @Override
    public void setMesLabels(List<String> mesLabels) {
        this.mesLabels = mesLabels;
    }

    @Override
    public void setMesAttributeLabels(List<String> mesAttributeLabels) {
        this.mesAttributeLabels = mesAttributeLabels;
    }

    @Override
    public void setClcLabels(List<String> clcLabels) {
        this.clcLabels = clcLabels;
    }

    @Override
    public void setClcAttributeLabels(List<String> clcAttributeLabels) {
        this.clcAttributeLabels = clcAttributeLabels;
    }

    @Override
    public int columnCount() {
        return this.provider.columnCount();
    }

    @Override
    public int keyColumnCount() {
        return this.provider.keysColumnsCount();
    }

    @Override
    public int mesColumnCount() {
        return this.provider.measColumnsCount();
    }

    @Override
    public int clcColumnCount() {
        return this.provider.calcColumnsCount();
    }

    @Override
    public ExportDataItem<T> getItem(int idx) {
        return this.provider.getItem(idx);
    }

    @Override
    public ExportDecorators getDecorators(int idx) {
        return this.provider.getDecorators(idx);
    }

    public StructuredDataProvider<?> getProvider() {
        return this.provider;
    }

    @Override
    public ExportData<T> getData() {
        ExportDataImpl<T> res = new ExportDataImpl<T>(this.itemCount());
        int i = 0;
        while (i < this.itemCount()) {
            res.add(this.getItem(i));
            ++i;
        }
        return res;
    }

    @Override
    public ExportMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(ExportMetadata metadata) {
        this.metadata = metadata;
    }
}

