/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.forms.widgets.Form;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;

public class GuiCommons {
    public static ControlDecoration createDecorator(Control control, String message) {
        ControlDecoration controlDecoration = new ControlDecoration(control, 16512);
        control.setData("decoration", (Object)controlDecoration);
        controlDecoration.setDescriptionText(message);
        controlDecoration.hide();
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        controlDecoration.setImage(fieldDecoration.getImage());
        return controlDecoration;
    }

    public static void hiligthError(Control control, IStatus status, Image errorIcon, Color errorColor) {
        if (control.getData("decoration") != null) {
            ((ControlDecoration)control.getData("decoration")).show();
        }
        control.setBackground(errorColor);
        Composite ancestor = control.getParent();
        while (ancestor != null) {
            if (ancestor instanceof CTabFolder) {
                CTabItem[] cTabItemArray = ((CTabFolder)ancestor.getParent()).getItems();
                int n = cTabItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CTabItem cTabItem = cTabItemArray[n2];
                    if (cTabItem.getControl().equals(ancestor)) {
                        cTabItem.setImage(errorIcon);
                    }
                    ++n2;
                }
            }
            if (ancestor instanceof Form) {
                ((Form)ancestor).setText(status.getMessage());
            }
            ancestor = ancestor.getParent();
        }
    }

    public static int getLastColumnSize(TreeViewer viewer) {
        int width = viewer.getTree().getShell().getMonitor().getClientArea().width;
        Point pt1 = viewer.getTree().toDisplay(0, 0);
        int restsize = 0;
        TreeColumn[] treeColumnArray = viewer.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            restsize += column.getWidth();
            ++n2;
        }
        return width - pt1.x - restsize;
    }

    public static int getLastColumnSize(TableViewer viewer) {
        int width = viewer.getTable().getShell().getMonitor().getClientArea().width;
        Point pt1 = viewer.getTable().toDisplay(0, 0);
        int restsize = 0;
        TableColumn[] tableColumnArray = viewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            restsize += column.getWidth();
            ++n2;
        }
        return width - pt1.x - restsize;
    }

    public static String getReferenceObjectTitle(ReferenceObject ref, String lang) {
        Object nameAtt = ref.getAttribute("NAME");
        if (nameAtt != null) {
            if (nameAtt instanceof MultilingualString) {
                return ((MultilingualString)nameAtt).getValue(lang);
            }
            return nameAtt.toString();
        }
        return String.valueOf(ref.getConcept().getName().getValue(lang)) + " - " + ref.getId().toString();
    }
}

