/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.dialogs;

import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.gui.components.ComponentsActivator;

public class FishstatWorkspaceCandidateFileSelector
extends TitleAreaDialog {
    private Tree treeDriveFolders;
    private TreeViewer trwvDriveFolders;
    private File workspaceFolderSelected;
    private String workspaceFileName;
    private Button buttonOk;
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private Text txtFileName;
    final LabelProvider labelProvider = new LabelProvider(){
        private Image iconFolder = ComponentsActivator.getImage("icons/folder.png");

        public Image getImage(Object element) {
            return this.getIcon((File)element);
        }

        public String getText(Object element) {
            return ((File)element).getName();
        }

        private Image getIcon(File file) {
            return this.iconFolder;
        }
    };
    final ViewerComparator viewerSorter = new ViewerComparator(){

        public int category(Object element) {
            File file = (File)element;
            if (file.isDirectory()) {
                return 0;
            }
            return 1;
        }
    };
    final ViewerFilter directoryFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return ((File)element).isDirectory() && !((File)element).getName().startsWith("$");
        }
    };
    private Label lblMessageLabel;

    public FishstatWorkspaceCandidateFileSelector(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        File[] roots;
        this.setTitleImage(ResourceManager.getPluginImage("org.fao.fi.fishstat.gui.components", "icons/database.png"));
        this.setTitle("FishstatJ workspace selection");
        this.setMessage("Choose a valid FishStatJ workspace folder");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 455;
        container.setLayoutData((Object)gridData);
        container.setLayout((Layout)new GridLayout(2, false));
        Label lblDiskSelection = new Label(container, 0);
        lblDiskSelection.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblDiskSelection.setText(String.valueOf(ComponentsActivator.getDefault().getLocalString("label.select.drive.colon")) + " ");
        final ComboViewer cmbvDrives = new ComboViewer(container, 8);
        Combo cmbvDriveSelector = cmbvDrives.getCombo();
        cmbvDriveSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FishstatWorkspaceCandidateFileSelector.this.trwvDriveFolders.setInput(((IStructuredSelection)cmbvDrives.getSelection()).getFirstElement());
                FishstatWorkspaceCandidateFileSelector.this.treeDriveFolders.setFocus();
            }
        });
        File[] fileArray = roots = File.listRoots();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            cmbvDrives.add((Object)file);
            ++n2;
        }
        cmbvDriveSelector.select(0);
        cmbvDriveSelector.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.trwvDriveFolders = new TreeViewer(container, 2048);
        this.trwvDriveFolders.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FishstatWorkspaceCandidateFileSelector.this.workspaceFolderSelected = (File)((StructuredSelection)event.getSelection()).getFirstElement();
            }
        });
        this.treeDriveFolders = this.trwvDriveFolders.getTree();
        this.treeDriveFolders.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.trwvDriveFolders.setContentProvider((IContentProvider)new ContentProvider());
        this.trwvDriveFolders.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.trwvDriveFolders.setFilters(new ViewerFilter[]{this.directoryFilter});
        Label lblFileLabel = this.formToolkit.createLabel(container, "File", 0);
        lblFileLabel.setBackground(SWTResourceManager.getColor(22));
        this.txtFileName = this.formToolkit.createText(container, "New Text", 0);
        this.txtFileName.setText("");
        this.txtFileName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FishstatWorkspaceCandidateFileSelector.this.workspaceFileName = FishstatWorkspaceCandidateFileSelector.this.txtFileName.getText();
                FishstatWorkspaceCandidateFileSelector.this.checkCandidate();
            }
        });
        this.txtFileName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lblMessageLabel = new Label(container, 0);
        this.lblMessageLabel.setForeground(SWTResourceManager.getColor(3));
        this.lblMessageLabel.setBackground(SWTResourceManager.getColor(22));
        this.lblMessageLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.trwvDriveFolders.setComparator(this.viewerSorter);
        this.trwvDriveFolders.setInput(((IStructuredSelection)cmbvDrives.getSelection()).getFirstElement());
        this.treeDriveFolders.setFocus();
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.buttonOk = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.buttonOk.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public File getSelectedWorkspaceFolder() {
        return this.workspaceFolderSelected;
    }

    public String getSelectedWorkspaceFileName() {
        return this.workspaceFileName;
    }

    public String getSelectedWorkspaceCanonicalFileName() {
        if (this.workspaceFileName == null || this.workspaceFileName.equals("")) {
            return "";
        }
        if (this.workspaceFileName.endsWith(".fws")) {
            return this.workspaceFileName;
        }
        return String.valueOf(this.workspaceFileName) + ".fws";
    }

    public File getSelectedWorkspaceCanonicalFile() throws Exception {
        String filename = this.getSelectedWorkspaceCanonicalFileName();
        File res = new File(this.workspaceFolderSelected, filename);
        return res;
    }

    protected Point getInitialSize() {
        return new Point(500, 450);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.workspaceFolderSelected = (File)((StructuredSelection)this.trwvDriveFolders.getSelection()).getFirstElement();
        }
        super.buttonPressed(buttonId);
    }

    protected void checkCandidate() {
        if (this.workspaceFolderSelected == null) {
            this.buttonOk.setEnabled(false);
            this.lblMessageLabel.setText("Empty folder: Please specify a valid one");
        } else if (this.workspaceFileName == null || this.workspaceFileName.equals("")) {
            this.buttonOk.setEnabled(false);
            this.lblMessageLabel.setText("Empty file name: please specify a valid one");
        } else if (!this.isFilenameValid(this.workspaceFileName)) {
            this.buttonOk.setEnabled(false);
            this.lblMessageLabel.setText("Invalid file name: please specify a valid one");
        } else {
            this.buttonOk.setEnabled(true);
            this.lblMessageLabel.setText("");
        }
    }

    public boolean isFilenameValid(String file) {
        String invalidChars = Platform.getOS().equals("win32") ? "\\/:*?\"<>|" : (Platform.getOS().equals("macosx") ? "/:" : "/");
        char[] chars = file.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (invalidChars.indexOf(chars[i]) >= 0 || chars[i] < ' ' || chars[i] > '~' && chars[i] < '\u00a0') {
                return false;
            }
            ++i;
        }
        return true;
    }

    class ContentProvider
    implements ITreeContentProvider {
        ContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            Object[] files = ((File)parentElement).listFiles();
            if (files == null) {
                return new Object[0];
            }
            return files;
        }

        public Object getParent(Object element) {
            return ((File)element).getParentFile();
        }

        public boolean hasChildren(Object element) {
            File file = (File)element;
            File[] files = file.listFiles();
            return files != null && files.length != 0;
        }

        public Object[] getElements(Object inputElement) {
            Object[] files = ((File)inputElement).listFiles();
            if (files == null) {
                return new Object[0];
            }
            return files;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            FishstatWorkspaceCandidateFileSelector.this.getShell().setText(String.valueOf(ComponentsActivator.getDefault().getLocalString("label.now.browsing.colon")) + " " + newInput);
        }
    }
}

