/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AttachmentType
implements Serializable {
    private static final long serialVersionUID = 672401874483636015L;
    private static final String TYPE_BITMAP = "bmp";
    private static final String TYPE_JPG = "jpg";
    private static final String TYPE_TEXT = "txt";
    private static final String TYPE_HTML = "html";
    public static final AttachmentType BITMAP = new AttachmentType("bmp");
    public static final AttachmentType JPG = new AttachmentType("jpg");
    public static final AttachmentType TEXT = new AttachmentType("txt");
    public static final AttachmentType HTML = new AttachmentType("html");
    private static final List<String> TYPE_KEYS = Collections.unmodifiableList(Arrays.asList("bmp", "jpg", "txt", "html"));
    public static final Set<AttachmentType> TYPES = Collections.unmodifiableSet(new HashSet<AttachmentType>(Arrays.asList(BITMAP, JPG, TEXT, HTML)));
    public static final Map<String, String> TYPES_EXTENSION = new HashMap<String, String>(){
        private static final long serialVersionUID = 1704510818591265054L;
        {
            this.put(AttachmentType.TYPE_BITMAP, ".bmp");
            this.put(AttachmentType.TYPE_JPG, ".jpg");
            this.put(AttachmentType.TYPE_TEXT, ".txt");
            this.put(AttachmentType.TYPE_HTML, ".html");
        }
    };
    public static final Map<String, String> TYPES_DESCRIPTION = new HashMap<String, String>(){
        private static final long serialVersionUID = -3876916559079763922L;
        {
            this.put(AttachmentType.TYPE_BITMAP, "bmp file");
            this.put(AttachmentType.TYPE_JPG, "jpg file");
            this.put(AttachmentType.TYPE_TEXT, "txt file");
            this.put(AttachmentType.TYPE_HTML, "html file");
        }
    };
    private String type;

    private AttachmentType(String type) {
        this.type = type;
    }

    private String getType() {
        return this.type;
    }

    public static AttachmentType valueOf(String type) {
        if (TYPE_KEYS.contains(type)) {
            return new AttachmentType(type);
        }
        throw new IllegalArgumentException("Invalid attachment type: " + type);
    }

    public String toString() {
        return this.getType();
    }

    public String getTypeExtension() {
        return TYPES_EXTENSION.get(this.type);
    }

    public String getTypeDescription() {
        return TYPES_DESCRIPTION.get(this.type);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttachmentType)) {
            return false;
        }
        AttachmentType other = (AttachmentType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

