/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api.calculated.functions.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.math.stat.StatUtils;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.calculated.functions.Descriptive;
import org.fao.fi.fishstat.data.timeseries.api.calculated.functions.impl.FunctionBase;
import org.fao.fi.fishstat.data.timeseries.api.calculated.parameters.Parameter;
import org.fao.fi.fishstat.data.timeseries.api.impl.TimeseriesServiceHelper;

public class RootMeanSquare
extends FunctionBase
implements Descriptive {
    public RootMeanSquare() {
    }

    public RootMeanSquare(ReferenceObject function) {
        super(function);
    }

    @Override
    public double evaluate(List<Double> values, Map<Parameter, String> parameters) {
        int n = values.size();
        if (n == 0) {
            return 0.0;
        }
        ArrayList<Double> squares = new ArrayList<Double>(n);
        for (double value : values) {
            squares.add(Math.pow(value, 2.0));
        }
        double squares_sum = StatUtils.sum((double[])TimeseriesServiceHelper.toArray(squares));
        return Math.sqrt(squares_sum / (double)n);
    }
}

