/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.model.aggregation;

import java.util.HashMap;
import java.util.List;
import org.fao.fi.fishstat.core.ActionDescriptor;
import org.fao.fi.fishstat.core.IActionRequestWrapper;
import org.fao.fi.fishstat.core.IFSActions;
import org.fao.fi.fishstat.core.model.aggregation.DimensionAggregation;
import org.fao.fi.fishstat.core.session.Session;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.Selection;

public class AggregationWrapper
implements IActionRequestWrapper,
IFSActions {
    private Session session;
    private ActionDescriptor descriptor;
    private DimensionAggregation[] dimensionAggregations;
    private HashMap<String, DimensionAggregation> keyRegistry;

    public AggregationWrapper(Session session) {
        this.session = session;
        this.descriptor = new ActionDescriptor(this);
        try {
            List dimensions = session.getDataset().getDimensions();
            this.dimensionAggregations = new DimensionAggregation[dimensions.size()];
            this.keyRegistry = new HashMap(dimensions.size());
            int i = 0;
            while (i < dimensions.size()) {
                this.dimensionAggregations[i] = new DimensionAggregation((Dimension)dimensions.get(i));
                this.keyRegistry.put(((Dimension)dimensions.get(i)).getConcept().getAcronym(), this.dimensionAggregations[i]);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int size() {
        return this.dimensionAggregations.length;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    public DimensionAggregation getDimensionAggregation(int i) {
        return this.dimensionAggregations[i];
    }

    public DimensionAggregation getDimensionAggregation(String acronym) {
        return this.keyRegistry.get(acronym);
    }

    public boolean hasDimensionAggregation(String acronym) {
        return this.keyRegistry.containsKey(acronym);
    }

    public ActionDescriptor getDescriptor() {
        return this.descriptor;
    }

    public boolean isDisaggregated() {
        boolean result = true;
        DimensionAggregation[] dimensionAggregationArray = this.dimensionAggregations;
        int n = this.dimensionAggregations.length;
        int n2 = 0;
        while (n2 < n) {
            DimensionAggregation dimagg = dimensionAggregationArray[n2];
            result = result && dimagg.nothingToAggregate();
            ++n2;
        }
        return result;
    }

    @Override
    public int getAction() {
        return 3;
    }

    public Selection getActionRequest() {
        Selection result = Selection.instance();
        DimensionAggregation[] dimensionAggregationArray = this.dimensionAggregations;
        int n = this.dimensionAggregations.length;
        int n2 = 0;
        while (n2 < n) {
            DimensionAggregation dimagg = dimensionAggregationArray[n2];
            if (!dimagg.nothingToAggregate()) {
                result.set(dimagg.getDimension().getConcept(), dimagg.getAllIncludes());
            }
            ++n2;
        }
        return result;
    }
}

