/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.reference.api.impl;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.fao.fi.fishstat.data.common.Commons;
import org.fao.fi.fishstat.data.common.api.Identifier;
import org.fao.fi.fishstat.data.common.api.IdentifierFactory;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.common.api.Version;
import org.fao.fi.fishstat.data.common.api.daosupport.GenericDAO;
import org.fao.fi.fishstat.data.common.api.impl.IdentifierHelper;
import org.fao.fi.fishstat.data.common.api.impl.VersionHelper;
import org.fao.fi.fishstat.data.common.register.RegistryFactory;
import org.fao.fi.fishstat.data.common.register.StructuralChangeEvent;
import org.fao.fi.fishstat.data.common.register.StructuralChangeEventListener;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.AttributeType;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.fao.fi.fishstat.data.reference.api.cache.ReferenceObjectCache;
import org.fao.fi.fishstat.data.reference.api.exceptions.ReferenceServiceException;
import org.fao.fi.fishstat.data.reference.api.impl.AttributeImpl;
import org.fao.fi.fishstat.data.reference.api.impl.GenericReferenceObject;
import org.fao.fi.fishstat.data.reference.api.impl.IDAttribute;
import org.fao.fi.fishstat.data.reference.api.impl.ReferenceObjectImpl;
import org.fao.fi.fishstat.data.reference.api.impl.ReferenceServiceHelper;
import org.fao.fi.fishstat.data.reference.api.impl.RelationshipImpl;

public class ConceptImpl
implements Concept,
StructuralChangeEventListener {
    private Object conceptDto;
    private Map<String, Attribute> attributes;
    private Object _attributesLock = new Object();
    private Map<String, Relationship> parentRelationships;
    private final Object _parentRelationshipsLock = new Object();
    private Map<String, Relationship> childrenRelationships;
    private final Object _childrenRelationshipsLock = new Object();
    private Identifier identifier;
    private String acronym;

    public ConceptImpl(Object concept_dto) throws ReferenceServiceException {
        try {
            if (concept_dto == null) {
                throw new IllegalArgumentException("Expecting not null concept DTO");
            }
            this.conceptDto = concept_dto;
            this.identifier = IdentifierHelper.instance((String)Commons.getDTOIdentifier((Object)this.conceptDto));
            this.acronym = (String)Commons.getDTOAttributeByAcronym((Object)this.conceptDto, (String)"ACRONYM");
            this.register();
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to instantiate concept", e);
        }
    }

    private void register() {
        RegistryFactory.getRegistry((Object)this).registerListener(StructuralChangeEvent.CONCEPT_CHANGE, (StructuralChangeEventListener)this);
        RegistryFactory.getRegistry((Object)this).registerListener(StructuralChangeEvent.RELATIONSHIP_CHANGE, (StructuralChangeEventListener)this);
        RegistryFactory.getRegistry((Object)this).registerListener(StructuralChangeEvent.WORKSPACE_CHANGE, (StructuralChangeEventListener)this);
    }

    private Map<String, Object> getRmdAttributes() throws Exception {
        LinkedHashMap<String, Object> rmd_attributes = new LinkedHashMap<String, Object>();
        List list = ReferenceServiceHelper.getRmdAttributeDao().findByAttribute("CONCEPT_ID", String.class, (Object)this.getId().stringValue());
        for (Object attribute_dto : list) {
            rmd_attributes.put((String)Commons.getDTOAttributeByAcronym(attribute_dto, (String)"ACRONYM"), attribute_dto);
        }
        return rmd_attributes;
    }

    private Map<String, Object> getRmdParentRelationships() throws Exception {
        HashMap<String, Object> rmd_parent_relationships = new HashMap<String, Object>();
        List relationships_where_child = ReferenceServiceHelper.getRmdRelationshipDao().findByAttribute("CHILD_ID", String.class, (Object)this.getId().stringValue());
        if (relationships_where_child != null) {
            for (Object relationship_dto : relationships_where_child) {
                rmd_parent_relationships.put((String)Commons.getDTOAttributeByAcronym(relationship_dto, (String)"ACRONYM"), relationship_dto);
            }
        }
        return rmd_parent_relationships;
    }

    private Map<String, Object> getRmdChildrenRelationships() throws Exception {
        HashMap<String, Object> rmd_children_relationships = new HashMap<String, Object>();
        List relationships_where_parent = ReferenceServiceHelper.getRmdRelationshipDao().findByAttribute("PARENT_ID", String.class, (Object)this.getId().stringValue());
        if (relationships_where_parent != null) {
            for (Object relationship_dto : relationships_where_parent) {
                rmd_children_relationships.put((String)Commons.getDTOAttributeByAcronym(relationship_dto, (String)"ACRONYM"), relationship_dto);
            }
        }
        return rmd_children_relationships;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetAttributesMap() {
        Object object = this._attributesLock;
        synchronized (object) {
            if (this.attributes != null) {
                this.attributes.clear();
            }
            this.attributes = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetParentRelationships() {
        Object object = this._parentRelationshipsLock;
        synchronized (object) {
            if (this.parentRelationships != null) {
                this.parentRelationships.clear();
            }
            this.parentRelationships = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetChildrenRelationships() {
        Object object = this._childrenRelationshipsLock;
        synchronized (object) {
            if (this.childrenRelationships != null) {
                this.childrenRelationships.clear();
            }
            this.childrenRelationships = null;
        }
    }

    @Override
    public Identifier getId() {
        return this.identifier;
    }

    @Override
    public String getAcronym() {
        return this.acronym;
    }

    @Override
    public MultilingualString getName() throws ReferenceServiceException {
        try {
            return Commons.getMultilingualDTOAttribute((Object)this.conceptDto, (String)"NAME");
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to get name", e);
        }
    }

    @Override
    public void setName(MultilingualString name) throws ReferenceServiceException {
        try {
            Commons.setMultilingualDTOAttribute((Object)this.conceptDto, (String)"NAME", (MultilingualString)name);
            this.update();
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to set name", e);
        }
    }

    @Override
    public MultilingualString getDescription() throws ReferenceServiceException {
        try {
            return Commons.getMultilingualDTOAttribute((Object)this.conceptDto, (String)"DESCRIPTION");
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to get description", e);
        }
    }

    @Override
    public void setDescription(MultilingualString description) throws ReferenceServiceException {
        try {
            Commons.setMultilingualDTOAttribute((Object)this.conceptDto, (String)"DESCRIPTION", (MultilingualString)description);
            this.update();
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to set description", e);
        }
    }

    @Override
    public Attribute getAttribute(String acronym) throws ReferenceServiceException {
        try {
            if (acronym == null) {
                throw new IllegalArgumentException("Acronym can not be null");
            }
            return this.getAttributesMap().get(acronym);
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to get meta attribute: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Attribute> getAttributesMap() throws Exception {
        Object object = this._attributesLock;
        synchronized (object) {
            if (this.attributes == null) {
                this.attributes = new LinkedHashMap<String, Attribute>();
                this.attributes.put("ID", new IDAttribute(this));
                for (Map.Entry<String, Object> entry : this.getRmdAttributes().entrySet()) {
                    this.attributes.put(entry.getKey(), new AttributeImpl(entry.getValue()));
                }
            }
            return this.attributes;
        }
    }

    @Override
    public Collection<Attribute> getAttributes() throws ReferenceServiceException {
        try {
            return this.getAttributesMap().values();
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to get meta attributes: " + e.getMessage(), e);
        }
    }

    @Override
    public Collection<Attribute> getCodeAttributes() throws ReferenceServiceException {
        Collection<Attribute> attributes = this.getAttributes();
        ArrayList<Attribute> code_attributes = new ArrayList<Attribute>();
        for (Attribute attribute : attributes) {
            if (!attribute.isCodeAttribute()) continue;
            code_attributes.add(attribute);
        }
        return code_attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Relationship> getChildrenRelationships() throws ReferenceServiceException {
        try {
            Object object = this._childrenRelationshipsLock;
            synchronized (object) {
                if (this.childrenRelationships == null) {
                    this.childrenRelationships = new HashMap<String, Relationship>();
                    for (Map.Entry<String, Object> entry : this.getRmdChildrenRelationships().entrySet()) {
                        this.childrenRelationships.put(entry.getKey(), new RelationshipImpl(entry.getValue()));
                    }
                }
                return this.childrenRelationships.values();
            }
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to get relationships: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Relationship> getParentRelationships() throws ReferenceServiceException {
        try {
            Object object = this._parentRelationshipsLock;
            synchronized (object) {
                if (this.parentRelationships == null) {
                    this.parentRelationships = new HashMap<String, Relationship>();
                    for (Map.Entry<String, Object> entry : this.getRmdParentRelationships().entrySet()) {
                        this.parentRelationships.put(entry.getKey(), new RelationshipImpl(entry.getValue()));
                    }
                }
                return this.parentRelationships.values();
            }
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to get relationships: " + e.getMessage(), e);
        }
    }

    @Override
    public Collection<Relationship> getRelationships() throws ReferenceServiceException {
        HashSet<Relationship> result = new HashSet<Relationship>(this.getParentRelationships());
        result.addAll(this.getChildrenRelationships());
        return result;
    }

    @Override
    public Collection<ReferenceObject> getObjects(Attribute attribute, Object value) throws ReferenceServiceException {
        if (attribute == null) {
            throw new IllegalArgumentException("Expecting not null attribute");
        }
        try {
            List list = ReferenceServiceHelper.getReferenceDAO(this.getAcronym()).findByAttribute(attribute.getAcronym(), attribute.getType().getRuntimeType(), value);
            ArrayList<ReferenceObject> results = new ArrayList<ReferenceObject>();
            if (list != null) {
                for (Object dto : list) {
                    Identifier object_id = IdentifierFactory.instance((String)Commons.getDTOIdentifier(dto));
                    ReferenceObject object = ReferenceObjectCache.getCache(this).get(object_id);
                    if (object == null) {
                        object = new ReferenceObjectImpl(dto, this);
                        ReferenceObjectCache.getCache(this).put(object_id, object);
                    }
                    results.add(object);
                }
            }
            return results;
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to get reference objects: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<ReferenceObject> getObjects() throws ReferenceServiceException {
        try {
            List list = ReferenceServiceHelper.getReferenceDAO(this.getAcronym()).findAll();
            ArrayList<ReferenceObject> results = new ArrayList<ReferenceObject>();
            Iterator iterator = list.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return results;
                }
                Object dto = iterator.next();
                Identifier id = IdentifierFactory.instance((String)Commons.getDTOIdentifier(dto));
                if (id == null) {
                    return null;
                }
                ReferenceObject object = ReferenceObjectCache.getCache(this).get(id);
                if (object == null) {
                    object = new ReferenceObjectImpl(dto, this);
                    ReferenceObjectCache.getCache(this).put(id, object);
                }
                results.add(object);
            }
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to get reference objects: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ReferenceObject getObject(Identifier id) throws ReferenceServiceException {
        Object dto;
        ReferenceObject result;
        block5: {
            block4: {
                try {
                    if (id != null) break block4;
                    return null;
                }
                catch (Exception e) {
                    throw new ReferenceServiceException("Unable to get reference object: " + e.getMessage(), e);
                }
            }
            result = ReferenceObjectCache.getCache(this).get(id);
            if (result != null) return result;
            dto = ReferenceServiceHelper.getReferenceDAO(this.getAcronym()).findById(id.toString());
            if (dto != null) break block5;
            return null;
        }
        result = new ReferenceObjectImpl(dto, this);
        ReferenceObjectCache.getCache(this).put(id, result);
        return result;
    }

    private void update() throws ReferenceServiceException {
        try {
            ReferenceServiceHelper.getRmdConceptDao().update(Commons.getDTOPk((Object)this.conceptDto), this.conceptDto);
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to update concept: " + e.getMessage(), e);
        }
    }

    @Override
    public Collection<ReferenceObject> getObjects(String acronym, Object value) throws ReferenceServiceException {
        return this.getObjects(this.getAttribute(acronym), value);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[").append(this.getId()).append("]").append("[").append(this.getAcronym()).append("]").append("[").append(this.getName()).append("]").append("[").append(this.getDescription()).append("]").append("[").append(this.getVersion()).append("]");
        return buffer.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Concept)) {
            return false;
        }
        return this.getId().equals(((Concept)obj).getId());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    @Override
    public ReferenceObject createObject() throws ReferenceServiceException {
        return new GenericReferenceObject(this);
    }

    @Override
    public ReferenceObject createObject(Map<Attribute, Object> attributes) throws ReferenceServiceException {
        return new GenericReferenceObject(this, attributes);
    }

    @Override
    public void removeObject(ReferenceObject object) throws ReferenceServiceException {
        try {
            if (object != null) {
                if (!object.getConcept().equals(this)) {
                    throw new IllegalArgumentException("Objec to be removed is not an instance of the concept");
                }
                RegistryFactory.getRegistry((Object)this).removeListener((StructuralChangeEventListener)object);
                ReferenceObjectCache.getCache(this).remove(object.getId());
                GenericDAO object_dao = ReferenceServiceHelper.getReferenceDAO(this.getAcronym());
                Object dto = object_dao.findById(object.getId().stringValue());
                object_dao.delete(Commons.getDTOPk((Object)dto));
            }
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to delete reference object", e);
        }
    }

    @Override
    public Collection<Concept> getParentConcepts() throws ReferenceServiceException {
        ArrayList<Concept> concepts = new ArrayList<Concept>();
        for (Relationship relationship : this.getParentRelationships()) {
            concepts.add(relationship.getParentConcept());
        }
        return concepts;
    }

    @Override
    public Collection<Concept> getChildrenConcepts() throws ReferenceServiceException {
        ArrayList<Concept> concepts = new ArrayList<Concept>();
        for (Relationship relationship : this.getChildrenRelationships()) {
            concepts.add(relationship.getChildConcept());
        }
        return concepts;
    }

    @Override
    public Collection<Concept> getRelatedConcepts() throws ReferenceServiceException {
        HashSet<Concept> concepts = new HashSet<Concept>(this.getParentConcepts());
        concepts.addAll(this.getChildrenConcepts());
        return concepts;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ReferenceObject getObject(Attribute codeAttribute, Object value) throws ReferenceServiceException {
        List list;
        ReferenceObject object;
        block7: {
            if (codeAttribute == null) {
                throw new IllegalArgumentException("Expecting not null attribute");
            }
            if (!this.equals(codeAttribute.getConcept())) {
                throw new IllegalArgumentException("Unexpected attribute: " + codeAttribute.getAcronym());
            }
            if (!codeAttribute.isCodeAttribute()) {
                throw new IllegalArgumentException("Expecting code attribute");
            }
            try {
                object = ReferenceObjectCache.getCache(this).get(codeAttribute, value);
                if (object != null) return object;
                list = ReferenceServiceHelper.getReferenceDAO(this.getAcronym()).findByAttribute(codeAttribute.getAcronym(), codeAttribute.getType().getRuntimeType(), value);
                if (list != null && list.size() != 0) break block7;
                return null;
            }
            catch (Exception e) {
                throw new ReferenceServiceException("Unable to get reference object", e);
            }
        }
        if (list.size() > 1) {
            throw new ReferenceServiceException("More than one object found matching the code attribute");
        }
        Object dto = list.get(0);
        object = new ReferenceObjectImpl(dto, this);
        ReferenceObjectCache.getCache(this).put(codeAttribute, value, object);
        return object;
    }

    @Override
    public ReferenceObject getObject(String codeAttributeAcronym, Object value) throws ReferenceServiceException {
        Attribute attribute = this.getAttribute(codeAttributeAcronym);
        return this.getObject(attribute, value);
    }

    public void onStructuralChangeEvent(StructuralChangeEvent change) throws IllegalStateException {
        if (change.equals((Object)StructuralChangeEvent.RELATIONSHIP_CHANGE)) {
            this.resetParentRelationships();
            this.resetChildrenRelationships();
        } else if (change.equals((Object)StructuralChangeEvent.CONCEPT_CHANGE)) {
            this.resetAttributesMap();
        }
    }

    @Override
    public Attribute getNameAttribute() throws ReferenceServiceException {
        Collection<Attribute> attributes = this.getAttributes();
        for (Attribute attribute : attributes) {
            if (!attribute.isNameAttribute()) continue;
            return attribute;
        }
        return null;
    }

    @Override
    public void removeAll() throws ReferenceServiceException {
        try {
            RegistryFactory.getRegistry((Object)this).removeAllListeners();
            ReferenceObjectCache.getCache(this).removeAll();
            GenericDAO object_dao = ReferenceServiceHelper.getReferenceDAO(this.getAcronym());
            object_dao.deleteAll();
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to delete reference objects", e);
        }
    }

    @Override
    public Collection<ReferenceObject> addAll(Collection<ReferenceObject> objects) throws ReferenceServiceException {
        try {
            ArrayList<ReferenceObject> result = new ArrayList<ReferenceObject>();
            if (objects != null && objects.size() > 0) {
                Class<?> c = ReferenceServiceHelper.getReferenceDTOClass(this.getAcronym());
                Constructor<?> constructor = c.getConstructor(new Class[0]);
                GenericDAO object_dao = ReferenceServiceHelper.getReferenceDAO(this.getAcronym());
                Identifier id = IdentifierHelper.instance((String)object_dao.generateId());
                for (ReferenceObject object : objects) {
                    System.out.println("persisting object: " + id);
                    if (!this.equals(object.getConcept())) {
                        throw new IllegalArgumentException("Incompatible concept found: " + object);
                    }
                    Object dto = constructor.newInstance(new Object[0]);
                    Map<Attribute, Object> attributes = object.getAttributes();
                    if (attributes != null) {
                        for (Map.Entry<Attribute, Object> entry : object.getAttributes().entrySet()) {
                            if (entry.getKey().getType().equals(AttributeType.MULTILINGUAL_STRING)) {
                                Commons.setMultilingualDTOAttribute(dto, (String)entry.getKey().getAcronym(), (MultilingualString)((MultilingualString)entry.getValue()));
                                continue;
                            }
                            Commons.setDTOAttribute(dto, (String)entry.getKey().getAcronym(), (Object)entry.getValue(), entry.getKey().getType().getRuntimeType());
                        }
                    }
                    Commons.setDTOIdentifier(dto, (String)id.stringValue());
                    object_dao.insert(dto);
                    ReferenceObjectImpl ref_object = new ReferenceObjectImpl(dto, this);
                    ReferenceObjectCache.getCache(this).put(id, ref_object);
                    result.add(ref_object);
                    id = IdentifierHelper.next((Identifier)id);
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to add reference object", e);
        }
    }

    @Override
    public ReferenceObject addObject(ReferenceObject object) throws ReferenceServiceException {
        if (object != null) {
            if (!this.equals(object.getConcept())) {
                throw new IllegalArgumentException("Incompatible concept found: " + object);
            }
            try {
                Class<?> c = ReferenceServiceHelper.getReferenceDTOClass(this.getAcronym());
                Constructor<?> constructor = c.getConstructor(new Class[0]);
                Object dto = constructor.newInstance(new Object[0]);
                Map<Attribute, Object> attributes = object.getAttributes();
                if (attributes != null) {
                    for (Map.Entry<Attribute, Object> entry : attributes.entrySet()) {
                        if (entry.getKey().getType().equals(AttributeType.MULTILINGUAL_STRING)) {
                            Commons.setMultilingualDTOAttribute(dto, (String)entry.getKey().getAcronym(), (MultilingualString)((MultilingualString)entry.getValue()));
                            continue;
                        }
                        Commons.setDTOAttribute(dto, (String)entry.getKey().getAcronym(), (Object)entry.getValue(), entry.getKey().getType().getRuntimeType());
                    }
                }
                GenericDAO object_dao = ReferenceServiceHelper.getReferenceDAO(this.getAcronym());
                String new_id = object_dao.generateId();
                Commons.setDTOIdentifier(dto, (String)new_id);
                object_dao.insert(dto);
                ReferenceObjectImpl ref_object = new ReferenceObjectImpl(dto, this);
                ReferenceObjectCache.getCache(this).put(IdentifierFactory.instance((String)new_id), ref_object);
                return ref_object;
            }
            catch (Exception e) {
                throw new ReferenceServiceException("Unable to add reference object", e);
            }
        }
        return null;
    }

    @Override
    public ReferenceObject addObject(ReferenceObject object, Identifier id) throws ReferenceServiceException {
        if (object != null) {
            if (!this.equals(object.getConcept())) {
                throw new IllegalArgumentException("Incompatible concept found: " + object);
            }
            try {
                Class<?> c = ReferenceServiceHelper.getReferenceDTOClass(this.getAcronym());
                Constructor<?> constructor = c.getConstructor(new Class[0]);
                Object dto = constructor.newInstance(new Object[0]);
                Map<Attribute, Object> attributes = object.getAttributes();
                if (attributes != null) {
                    for (Map.Entry<Attribute, Object> entry : attributes.entrySet()) {
                        if (entry.getKey().getType().equals(AttributeType.MULTILINGUAL_STRING)) {
                            Commons.setMultilingualDTOAttribute(dto, (String)entry.getKey().getAcronym(), (MultilingualString)((MultilingualString)entry.getValue()));
                            continue;
                        }
                        Commons.setDTOAttribute(dto, (String)entry.getKey().getAcronym(), (Object)entry.getValue(), entry.getKey().getType().getRuntimeType());
                    }
                }
                GenericDAO object_dao = ReferenceServiceHelper.getReferenceDAO(this.getAcronym());
                Commons.setDTOIdentifier(dto, (String)id.stringValue());
                object_dao.insert(dto);
                ReferenceObjectImpl ref_object = new ReferenceObjectImpl(dto, this);
                ReferenceObjectCache.getCache(this).put(IdentifierFactory.instance((String)id.stringValue()), ref_object);
                return ref_object;
            }
            catch (Exception e) {
                throw new ReferenceServiceException("Unable to add reference object", e);
            }
        }
        return null;
    }

    public Version getVersion() throws ReferenceServiceException {
        try {
            return VersionHelper.getVersion((Object)this.conceptDto);
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to get version", e);
        }
    }

    public void setVersion(Version version) throws ReferenceServiceException {
        try {
            VersionHelper.setVersion((Object)this.conceptDto, (Version)version);
            this.update();
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to set version", e);
        }
    }

    @Override
    public Integer getSortorder() {
        try {
            return (Integer)Commons.getDTOAttributeByAcronym((Object)this.conceptDto, (String)"SORT_ORDER");
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void setSortorder(Integer sortOrder) throws ReferenceServiceException {
        try {
            Commons.setDTOAttribute((Object)this.conceptDto, (String)"SORT_ORDER", (Object)sortOrder, Integer.class);
            this.update();
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to set the sort_order", e);
        }
    }
}

