/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.reference.api.impl;

import java.util.ArrayList;
import java.util.List;
import org.fao.fi.fishstat.data.common.Commons;
import org.fao.fi.fishstat.data.common.api.Identifier;
import org.fao.fi.fishstat.data.common.api.IdentifierFactory;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceService;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.fao.fi.fishstat.data.reference.api.exceptions.ReferenceServiceException;
import org.fao.fi.fishstat.data.reference.api.impl.ConceptImpl;
import org.fao.fi.fishstat.data.reference.api.impl.ReferenceServiceHelper;
import org.fao.fi.fishstat.data.reference.api.impl.RelationshipImpl;

public class ReferenceServiceImpl
implements ReferenceService {
    @Override
    public Concept getConcept(String acronym) throws ReferenceServiceException {
        List concept_dtos = null;
        try {
            concept_dtos = ReferenceServiceHelper.getRmdConceptDao().findByAttribute("ACRONYM", String.class, (Object)acronym);
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Finder method call failed: " + e.getMessage(), e);
        }
        if (concept_dtos == null || concept_dtos.size() == 0) {
            return null;
        }
        return new ConceptImpl(concept_dtos.get(0));
    }

    @Override
    public List<Concept> getConcepts() throws ReferenceServiceException {
        List concept_dtos = null;
        try {
            concept_dtos = ReferenceServiceHelper.getRmdConceptDao().findAll();
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Finder method call failed: " + e.getMessage(), e);
        }
        if (concept_dtos == null) {
            return null;
        }
        ArrayList<Concept> result = new ArrayList<Concept>(concept_dtos.size());
        for (Object concept_dto : concept_dtos) {
            result.add(new ConceptImpl(concept_dto));
        }
        return result;
    }

    @Override
    public Concept getConcept(Identifier id) throws ReferenceServiceException {
        Object concept_dto;
        block3: {
            try {
                concept_dto = ReferenceServiceHelper.getRmdConceptDao().findById(id.toString());
                if (concept_dto != null) break block3;
                return null;
            }
            catch (Exception e) {
                throw new ReferenceServiceException("Finder method call failed: " + e.getMessage(), e);
            }
        }
        return new ConceptImpl(concept_dto);
    }

    @Override
    public Relationship getRelationship(String acronym) throws ReferenceServiceException {
        try {
            List relationship_dtos = ReferenceServiceHelper.getRmdRelationshipDao().findByAttribute("ACRONYM", String.class, (Object)acronym);
            if (relationship_dtos != null && relationship_dtos.size() > 0) {
                return new RelationshipImpl(relationship_dtos.get(0));
            }
            return null;
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Finder method call failed: " + e.getMessage(), e);
        }
    }

    @Override
    public Relationship getRelationship(Identifier id) throws ReferenceServiceException {
        Object relationship_dto;
        block3: {
            try {
                relationship_dto = ReferenceServiceHelper.getRmdRelationshipDao().findById(id.toString());
                if (relationship_dto != null) break block3;
                return null;
            }
            catch (Exception e) {
                throw new ReferenceServiceException("Finder method call failed: " + e.getMessage(), e);
            }
        }
        return new RelationshipImpl(relationship_dto);
    }

    @Override
    public List<Relationship> getRelationships() throws ReferenceServiceException {
        try {
            List relationship_dtos = ReferenceServiceHelper.getRmdRelationshipDao().findAll();
            ArrayList<Relationship> result = new ArrayList<Relationship>();
            if (relationship_dtos != null) {
                for (Object relationship_dto : relationship_dtos) {
                    result.add(new RelationshipImpl(relationship_dto));
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Finder method call failed: " + e.getMessage(), e);
        }
    }

    @Override
    public List<ReferenceObject> getObjects(Concept concept, String sql, Object[] sqlParams) throws ReferenceServiceException {
        try {
            List list = ReferenceServiceHelper.getReferenceDAO(concept.getAcronym()).findByDynamicSelect(sql, sqlParams);
            ArrayList<ReferenceObject> results = new ArrayList<ReferenceObject>();
            for (Object dto : list) {
                String object_id = Commons.getDTOIdentifier(dto);
                results.add(concept.getObject(IdentifierFactory.instance((String)object_id)));
            }
            return results;
        }
        catch (Exception e) {
            throw new ReferenceServiceException(e);
        }
    }

    @Override
    public Relationship getRelationship(Concept parent, Concept child) throws ReferenceServiceException {
        try {
            List relationship_dtos = ReferenceServiceHelper.getRmdRelationshipDao().findByDynamicWhere("PARENT_ID = ? AND CHILD_ID = ?", (Object[])new String[]{parent.getId().stringValue(), child.getId().stringValue()});
            if (relationship_dtos != null && relationship_dtos.size() > 0) {
                return new RelationshipImpl(relationship_dtos.get(0));
            }
            return null;
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Finder method call failed: " + e.getMessage(), e);
        }
    }
}

