/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.autoupdate.test;

import java.io.File;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.fao.fi.fishstat.autoupdate.gen.AutoUpdate;
import org.fao.fi.fishstat.autoupdate.gen.AutoUpdateWks;
import org.junit.Test;

public class MarshallUnmarshall {
    @Test
    public void createXML() {
        try {
            System.out.println("createXML()");
            new File("test").mkdirs();
            AutoUpdateWks globalWS = new AutoUpdateWks();
            globalWS.setAcronym("FAO_FI_GLOBALS");
            globalWS.setVersion("2016.1.2");
            globalWS.setDate("2016-03-07");
            globalWS.setDescription("FAO Global Fishery and Aquaculture Statistics");
            globalWS.setUrl("http://www.fao.org/fishery/static/FishStatJ/FAO_FI_Global_2016.1.2.fws");
            AutoUpdateWks regionalWS = new AutoUpdateWks();
            regionalWS.setAcronym("FAO_FI_REGIONAL");
            regionalWS.setVersion("2016.1.0");
            regionalWS.setDate("2016-06-13");
            regionalWS.setDescription("FAO Regional capture fisheries statistics");
            regionalWS.setUrl("http://www.fao.org/fishery/static/FishStatJ/FAO_FI_Regionals_2016.1.0.fws");
            AutoUpdate update = new AutoUpdate();
            update.setVersion("3.0.2");
            update.setDate("2014-01-01");
            update.setUrl("http://www.fao.org/fishery/statistics/software/fishstatj/en");
            update.setUrlmac("http://www.fao.org/fishery/statistics/software/fishstatj/en#downlApp");
            update.setUrlwin("http://www.fao.org/fishery/statistics/software/fishstatj/en#downlApp");
            update.setUrllnx("http://www.fao.org/fishery/statistics/software/fishstatj/en#downlApp");
            update.setDownloadmac("http://www.fao.org/fishery/static/FishStatJ/FishStatJ_3.00.1_win32.zip");
            update.setDownloadwin("http://www.fao.org/fishery/static/FishStatJ/FishStatJ_3.00.1_app.zip");
            update.setDownloadlnx("http://www.fao.org/fishery/static/FishStatJ/fishstatj_2.12.4_lnx32.tar.gz");
            update.getAutoUpdateWks().add(regionalWS);
            update.getAutoUpdateWks().add(globalWS);
            File xmlFile = new File("test/current_version.xml");
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{AutoUpdate.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal((Object)update, xmlFile);
            jaxbMarshaller.marshal((Object)update, (OutputStream)System.out);
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            AutoUpdate update2 = (AutoUpdate)jaxbUnmarshaller.unmarshal(xmlFile);
            System.out.println(String.valueOf(update2.getDate()) + "," + update2.getUrl() + "," + update2.getVersion() + "," + update2.getDownloadwin());
            System.out.println("   " + update2.getAutoUpdateWks().get(0).getAcronym() + "," + update2.getAutoUpdateWks().get(0).getDescription() + "," + update2.getAutoUpdateWks().get(0).getVersion() + "," + update2.getAutoUpdateWks().get(0).getUrl());
            System.out.println("   " + update2.getAutoUpdateWks().get(1).getAcronym() + "," + update2.getAutoUpdateWks().get(1).getDescription() + "," + update2.getAutoUpdateWks().get(1).getVersion() + "," + update2.getAutoUpdateWks().get(1).getUrl());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

