/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.api.io.csv.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.fao.fi.fishstat.data.api.io.csv.ReferenceConceptCSVMetadata;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.AttributeType;
import org.fao.fi.fishstat.data.reference.api.Concept;

public class ReferenceConceptCSVMetadataImpl
implements ReferenceConceptCSVMetadata {
    private static final char NO_TEXT_QUALIFIER = '\u0000';
    private static final char DEFAULT_TEXT_QUALIFIER = '\"';
    private boolean hasHeaders = true;
    private char textQualifier = (char)34;
    private Map<String, Integer> attributeColumns = new LinkedHashMap<String, Integer>();
    private Map<String, String> attributeHeaders = new LinkedHashMap<String, String>();

    public ReferenceConceptCSVMetadataImpl(Concept concept) {
        int columnCounter = 0;
        for (Attribute attribute : concept.getAttributes()) {
            if (!attribute.getType().equals((Object)AttributeType.MULTILINGUAL_STRING)) {
                this.attributeHeaders.put(attribute.getAcronym(), attribute.getAcronym());
                this.attributeColumns.put(attribute.getAcronym(), columnCounter++);
                continue;
            }
            for (String lang : MultilingualString.LANGUAGES) {
                this.attributeHeaders.put(String.valueOf(attribute.getAcronym()) + "_" + lang.toUpperCase(Locale.ENGLISH), String.valueOf(attribute.getAcronym()) + "_" + lang.toUpperCase(Locale.ENGLISH));
                this.attributeColumns.put(String.valueOf(attribute.getAcronym()) + "_" + lang.toUpperCase(Locale.ENGLISH), columnCounter++);
            }
        }
    }

    @Override
    public List<String> getAttributeHeaders() {
        return new ArrayList<String>(this.attributeHeaders.values());
    }

    @Override
    public int getAttributeColumn(String attributeAcronym) {
        Integer column = this.attributeColumns.get(attributeAcronym);
        return column == null ? -1 : column;
    }

    @Override
    public int getAttributeColumn(String attributeAcronym, String lang) {
        Integer column = this.attributeColumns.get(String.valueOf(attributeAcronym) + "_" + lang.toUpperCase(Locale.ENGLISH));
        return column == null ? -1 : column;
    }

    @Override
    public String getAttributeHeader(String attributeAcronym) {
        return this.attributeHeaders.get(attributeAcronym);
    }

    @Override
    public String getAttributeHeader(String attributeAcronym, String lang) {
        return this.attributeHeaders.get(String.valueOf(attributeAcronym) + "_" + lang.toUpperCase(Locale.ENGLISH));
    }

    @Override
    public char getTextQualifier() {
        return this.textQualifier;
    }

    @Override
    public boolean useHeaders() {
        return this.hasHeaders;
    }

    @Override
    public void setAttributeColumn(String attributeAcronym, int index) {
        if (index <= 0) {
            throw new IndexOutOfBoundsException("index must be > 0");
        }
        this.attributeColumns.put(attributeAcronym, index);
    }

    @Override
    public void setAttributeColumn(String attributeAcronym, String lang, int index) {
        this.attributeColumns.put(String.valueOf(attributeAcronym) + "_" + lang.toUpperCase(Locale.ENGLISH), index);
    }

    @Override
    public void setAttributeHeader(String attributeAcronym, String header) {
        this.attributeHeaders.put(attributeAcronym, header);
    }

    @Override
    public void setAttributeHeader(String attributeAcronym, String lang, String header) {
        this.attributeHeaders.put(String.valueOf(attributeAcronym) + "_" + lang.toUpperCase(Locale.ENGLISH), header);
    }

    @Override
    public void setUseHeaders(boolean headers) {
        this.hasHeaders = headers;
    }

    @Override
    public void setTextQualifier(char qualifier) {
        this.textQualifier = qualifier;
    }

    @Override
    public boolean useTextQualifier() {
        return this.textQualifier != '\u0000';
    }
}

