/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.api.io.csv.impl;

import java.util.HashMap;
import java.util.Map;
import org.fao.fi.fishstat.data.api.io.csv.TimeseriesCSVMetadata;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;

public class TimeseriesCSVMetadataImpl
implements TimeseriesCSVMetadata {
    private static final char NO_TEXT_QUALIFIER = '\u0000';
    private boolean hasHeaders = true;
    private char textQualifier = '\u0000';
    private Map<String, Integer> dimensionColumns;
    private Map<String, String> dimensionHeaders;
    private Map<String, String> dimensionAttributes;
    protected int columnCounter;

    protected TimeseriesCSVMetadataImpl() {
        this.columnCounter = 0;
        this.dimensionColumns = new HashMap<String, Integer>();
        this.dimensionHeaders = new HashMap<String, String>();
    }

    public TimeseriesCSVMetadataImpl(Timeseries timeseries) {
        this.dimensionColumns = new HashMap<String, Integer>();
        this.dimensionHeaders = new HashMap<String, String>();
        this.dimensionAttributes = new HashMap<String, String>();
        for (Concept concept : timeseries.getDataset().getConcepts()) {
            this.dimensionHeaders.put(concept.getAcronym(), concept.getAcronym());
            this.dimensionColumns.put(concept.getAcronym(), this.columnCounter++);
            this.dimensionAttributes.put(concept.getAcronym(), "ID");
        }
    }

    @Override
    public String getDimensionAttribute(String dimensionAcronym) {
        return this.dimensionAttributes.get(dimensionAcronym);
    }

    @Override
    public int getDimensionColumn(String dimensionAcronym) {
        Integer column = this.dimensionColumns.get(dimensionAcronym);
        return column == null ? -1 : column;
    }

    @Override
    public String getDimensionHeader(String dimensionAcronym) {
        return this.dimensionHeaders.get(dimensionAcronym);
    }

    @Override
    public boolean useHeaders() {
        return this.hasHeaders;
    }

    @Override
    public void setDimensionAttribute(String dimensionAcronym, String attributeAcronym) {
        this.dimensionAttributes.put(dimensionAcronym, attributeAcronym);
    }

    @Override
    public void setDimensionColumn(String dimensionAcronym, int index) {
        this.dimensionColumns.put(dimensionAcronym, index);
    }

    @Override
    public void setDimensionHeader(String dimensionAcronym, String header) {
        this.dimensionHeaders.put(dimensionAcronym, header);
    }

    @Override
    public void setUseHeaders(boolean headers) {
        this.hasHeaders = headers;
    }

    @Override
    public char getTextQualifier() {
        return this.textQualifier;
    }

    @Override
    public void setTextQualifier(char qualifier) {
        this.textQualifier = qualifier;
    }

    @Override
    public boolean useTextQualifier() {
        return this.textQualifier != '\u0000';
    }
}

