/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.reference.api.csv.test;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import org.fao.fi.fishstat.data.api.io.csv.ReferenceCSVService;
import org.fao.fi.fishstat.data.api.io.csv.ReferenceRelationshipCSVMetadata;
import org.fao.fi.fishstat.data.common.utils.JUnitTestHelper;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.junit.BeforeClass;
import org.junit.Test;

public class AreaRelationshipCSVTestCase {
    @BeforeClass
    public static void setUp() throws Exception {
        JUnitTestHelper.setTestActiveWorkspace();
    }

    @Test
    public void testLoadSubareaRelationshipCSV() throws Exception {
        Relationship relationship = ReferenceServiceFactory.getService().getRelationship("AREA_SUB_AREA");
        ReferenceRelationshipCSVMetadata metadata = ReferenceCSVService.instance().createRelationshipMetadata();
        metadata.setChildAttribute("FID");
        metadata.setParentAttribute("FID");
        ReferenceCSVService.instance().upload(relationship, new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/area/rel_area_sub_area.csv"))), metadata, true, null);
    }

    @Test
    public void testLoadDivisionRelationshipCSV() throws Exception {
        Relationship relationship = ReferenceServiceFactory.getService().getRelationship("SUB_AREA_DIVISION");
        ReferenceRelationshipCSVMetadata metadata = ReferenceCSVService.instance().createRelationshipMetadata();
        metadata.setChildAttribute("FID");
        metadata.setParentAttribute("FID");
        ReferenceCSVService.instance().upload(relationship, new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/area/rel_sub_area_division.csv"))), metadata, true, null);
    }

    @Test
    public void testLoadSubdivisionRelationshipCSV() throws Exception {
        Relationship relationship = ReferenceServiceFactory.getService().getRelationship("DIVISION_SUB_DIVISION");
        ReferenceRelationshipCSVMetadata metadata = ReferenceCSVService.instance().createRelationshipMetadata();
        metadata.setChildAttribute("FID");
        metadata.setParentAttribute("FID");
        ReferenceCSVService.instance().upload(relationship, new InputStreamReader(new BufferedInputStream(new FileInputStream("src/test/resources/area/rel_division_sub_division.csv"))), metadata, true, null);
    }
}

