/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.dataset.aggregation;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.core.model.aggregation.DimensionAggregation;
import org.fao.fi.fishstat.core.model.customgroups.CustomGroupsDaoFactory;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.components.widgets.combos.ConceptParentsComboViewer;
import org.fao.fi.fishstat.gui.dataset.aggregation.HandpickedAggregationDialog;

public class DimensionAggregationComposite
extends Composite {
    private Composite cmpSeparator;
    private Button chkHandpicked;
    private Combo cmbAggregations;
    private DimensionAggregation aggregation;
    private Button but_handpicked;
    private ConceptParentsComboViewer lst_aggregations;
    private Label lbl_by;
    private List cmb_aggregation_types;
    private FormText lbl_dimesion;
    private boolean groupable = true;
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());

    public DimensionAggregationComposite(Composite parent, int style, DimensionAggregation a) {
        super(parent, style);
        this.aggregation = a;
        this.toolkit.adapt((Composite)this);
        this.toolkit.paintBordersFor((Composite)this);
        this.initComponents();
    }

    private void initComponents() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginBottom = 5;
        gridLayout.marginTop = 5;
        gridLayout.marginRight = 5;
        gridLayout.marginLeft = 5;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 5;
        this.setLayout((Layout)gridLayout);
        this.setForeground(SWTResourceManager.getColor(255, 255, 255));
        this.setBackground(SWTResourceManager.getColor(255, 255, 255));
        RowData rd_aggregations_list = new RowData();
        rd_aggregations_list.width = 145;
        this.lbl_dimesion = new FormText((Composite)this, 0);
        this.lbl_dimesion.setBackground(SWTResourceManager.getColor(255, 255, 255));
        GridData gd_lbl_dimesion = new GridData(4, 0x1000000, false, false, 1, 2);
        gd_lbl_dimesion.widthHint = 171;
        gd_lbl_dimesion.minimumWidth = 20;
        this.lbl_dimesion.setLayoutData((Object)gd_lbl_dimesion);
        this.lbl_dimesion.setForeground(ComponentsCommons.getColor((int)128, (int)0, (int)0));
        this.lbl_dimesion.setFont(ComponentsCommons.getFont((String)"", (int)10, (int)1));
        this.lbl_dimesion.setText(CoreUtils.getCurrentLangName((Object)this.aggregation.getDimension(), (String)Activator.getLanguage()), false, false);
        this.cmb_aggregation_types = new List((Composite)this, 0);
        this.cmb_aggregation_types.setBackground(Display.getCurrent().getSystemColor(25));
        this.cmb_aggregation_types.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DimensionAggregationComposite.this.applyData();
                DimensionAggregationComposite.this.redesignPanel();
            }
        });
        GridData gd_cmb_aggregation_types = new GridData(4, 0x1000000, false, false, 1, 2);
        gd_cmb_aggregation_types.heightHint = 71;
        this.cmb_aggregation_types.setLayoutData((Object)gd_cmb_aggregation_types);
        this.lbl_by = new Label((Composite)this, 0x1000000);
        this.lbl_by.setBackground(SWTResourceManager.getColor(255, 255, 255));
        this.lbl_by.setBackground(this.getBackground());
        this.lbl_by.setForeground(ComponentsCommons.getColor((int)0, (int)0, (int)128));
        this.lbl_by.setFont(ComponentsCommons.getFont((String)"", (int)10, (int)1));
        GridData gd_lbl_by = new GridData(4, 0x1000000, false, false, 1, 2);
        gd_lbl_by.widthHint = 41;
        this.lbl_by.setLayoutData((Object)gd_lbl_by);
        this.lbl_by.setText(Activator.getLocalString("label.by.first.lower"));
        this.lbl_by.setVisible(false);
        this.chkHandpicked = new Button((Composite)this, 32);
        this.chkHandpicked.setBackground(SWTResourceManager.getColor(255, 255, 255));
        this.chkHandpicked.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DimensionAggregationComposite.this.applyData();
                DimensionAggregationComposite.this.redesignPanel();
            }
        });
        GridData gd_chkHandpicked = new GridData(101, 35);
        this.chkHandpicked.setLayoutData((Object)gd_chkHandpicked);
        this.chkHandpicked.setText(Activator.getLocalString("label.handpicked.first.upper"));
        this.but_handpicked = new Button((Composite)this, 0);
        this.but_handpicked.setAlignment(16384);
        this.but_handpicked.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HandpickedAggregationDialog dlg = new HandpickedAggregationDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), DimensionAggregationComposite.this.aggregation);
                dlg.open();
            }
        });
        GridData gd_but_handpicked = new GridData(131072, 0x1000000, false, false);
        gd_but_handpicked.heightHint = 25;
        gd_but_handpicked.widthHint = 25;
        this.but_handpicked.setLayoutData((Object)gd_but_handpicked);
        this.but_handpicked.setImage(Activator.getImage("icons/actions/hand.png"));
        this.but_handpicked.setVisible(false);
        this.lst_aggregations = new ConceptParentsComboViewer((Composite)this, 0, Activator.getLanguage(), false);
        this.lst_aggregations.setCustomGroupsIncluded(CustomGroupsDaoFactory.create().size(this.aggregation.getDimension().getAcronym()) > 0);
        this.lst_aggregations.setInput((Object)this.aggregation.getDimension().getConcept());
        this.cmbAggregations = this.lst_aggregations.getCombo();
        if (this.cmbAggregations.getItemCount() > 0) {
            this.lst_aggregations.setSelection((ISelection)new StructuredSelection(this.lst_aggregations.getElementAt(0)));
            this.lst_aggregations.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    DimensionAggregationComposite.this.applyData();
                    DimensionAggregationComposite.this.redesignPanel();
                }
            });
        }
        this.groupable = this.cmbAggregations.getItemCount() > 0;
        this.cmbAggregations.setVisible(false);
        this.cmb_aggregation_types.add(Activator.getLocalString("label.detailed.first.upper"));
        if (this.groupable) {
            this.cmb_aggregation_types.add(Activator.getLocalString("label.grouped.first.upper"));
        }
        this.cmb_aggregation_types.add(Activator.getLocalString("label.aggregated.first.upper"));
        this.cmb_aggregation_types.select(0);
        GridData gd_combo = new GridData(16384, 4, false, false, 2, 1);
        gd_combo.widthHint = 150;
        this.cmbAggregations.setLayoutData((Object)gd_combo);
        this.syncroCombos();
        this.redesignPanel();
        this.cmpSeparator = this.toolkit.createCompositeSeparator((Composite)this);
        GridData gd_composite = new GridData(4, 128, false, false, 5, 1);
        gd_composite.widthHint = 422;
        gd_composite.heightHint = 4;
        this.cmpSeparator.setLayoutData((Object)gd_composite);
    }

    private void syncroCombos() {
        switch (this.aggregation.getType()) {
            case 0: {
                this.cmb_aggregation_types.select(0);
                break;
            }
            case 1: {
                this.cmb_aggregation_types.select(1);
                this.lst_aggregations.setSelection((ISelection)new StructuredSelection((Object)this.aggregation.getBasicAggregator()), true);
                break;
            }
            case 2: {
                this.cmb_aggregation_types.select(1);
                break;
            }
            case 3: {
                this.cmb_aggregation_types.select(this.cmb_aggregation_types.getItemCount() - 1);
            }
        }
    }

    private void redesignPanel() {
        switch (this.aggregation.getType()) {
            case 0: {
                this.lst_aggregations.getCombo().setVisible(false);
                this.chkHandpicked.setVisible(false);
                this.lbl_by.setVisible(false);
                this.but_handpicked.setVisible(false);
                break;
            }
            case 1: {
                this.chkHandpicked.setVisible(true);
                this.chkHandpicked.setSelection(false);
                this.lst_aggregations.getCombo().setVisible(true);
                this.lst_aggregations.getCombo().setEnabled(true);
                this.but_handpicked.setVisible(false);
                this.lbl_by.setVisible(true);
                break;
            }
            case 2: {
                this.chkHandpicked.setVisible(true);
                this.chkHandpicked.setSelection(true);
                this.lst_aggregations.getCombo().setVisible(true);
                this.lst_aggregations.getCombo().setEnabled(false);
                this.but_handpicked.setVisible(true);
                this.lbl_by.setVisible(true);
                break;
            }
            case 3: {
                this.chkHandpicked.setVisible(false);
                this.lst_aggregations.getCombo().setVisible(false);
                this.lbl_by.setVisible(false);
                this.but_handpicked.setVisible(false);
            }
        }
    }

    protected void applyData() {
        int sel = this.cmb_aggregation_types.getSelectionIndex();
        switch (sel) {
            case 0: {
                this.aggregation.setDetailedDimension();
                break;
            }
            case 1: {
                if (this.groupable) {
                    this.adjournHandPicked();
                    break;
                }
                this.aggregation.setAggregatedDimension();
                break;
            }
            case 2: {
                this.aggregation.setAggregatedDimension();
            }
        }
    }

    private void adjournHandPicked() {
        if (this.chkHandpicked.getSelection()) {
            this.aggregation.setHandPickedAggregation();
        } else {
            Concept concept = (Concept)((IStructuredSelection)this.lst_aggregations.getSelection()).getFirstElement();
            if (concept != null) {
                this.aggregation.setBasicConceptAggregation(concept);
            }
        }
    }
}

