/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.dataset.aggregation;

import java.util.Iterator;
import java.util.Observer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.core.model.aggregation.DimensionAggregation;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.components.widgets.DimensionParentsTreeViewer;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;
import org.fao.fi.fishstat.gui.core.properties.DimensionProperties;
import org.fao.fi.fishstat.gui.core.session.GuiSession;
import org.fao.fi.fishstat.gui.dataset.aggregation.AggregationTreeContentProvider;

public class HandpickedAggregationComposite
extends Composite {
    private DimensionAggregation aggregation;
    private DimensionProperties dimensionProperties;
    private Button butRigthAll;
    private Button butLeftAll;
    private Tree excludesTree;
    private DimensionParentsTreeViewer excludesTreeViewer;
    private Tree includesTree;
    private DimensionParentsTreeViewer includesTreeViewer;
    private Button butRigth;
    private Button butLeft;
    private Button butSave;
    private Button butLoad;
    private Button butGroups;
    private Composite cmpSeparator;
    private Composite compositeUp;
    private Composite cmp_right;
    private Composite cmp_center;
    private Composite cmp_left;
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private Composite compositeDown;

    public HandpickedAggregationComposite(Composite parent, int style, DimensionAggregation a) {
        super(parent, style);
        this.setBackgroundMode(2);
        this.setBackground(SWTResourceManager.getColor(1));
        this.aggregation = a;
        this.dimensionProperties = ((GuiSession)GuiCoreActivator.getDefault().getRegistry().getSessionOnFocus()).getDatasetProperties().getDimensionsProperties(this.aggregation.getDimension());
        this.initComponents();
    }

    private void initComponents() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 3;
        gridLayout.marginHeight = 3;
        gridLayout.horizontalSpacing = 3;
        gridLayout.verticalSpacing = 3;
        gridLayout.numColumns = 3;
        this.setLayout((Layout)gridLayout);
        this.cmp_left = new Composite((Composite)this, 0);
        this.cmp_left.setBackgroundMode(2);
        this.cmp_left.setBackground(Display.getCurrent().getSystemColor(22));
        GridData gd_cmp_left = new GridData(4, 4, false, true);
        gd_cmp_left.widthHint = 250;
        this.cmp_left.setLayoutData((Object)gd_cmp_left);
        GridLayout gridLayout_3 = new GridLayout();
        gridLayout_3.horizontalSpacing = 0;
        gridLayout_3.marginHeight = 0;
        gridLayout_3.marginWidth = 0;
        this.cmp_left.setLayout((Layout)gridLayout_3);
        this.toolkit.adapt(this.cmp_left);
        AggregationTreeContentProvider contentProviderIncludes = new AggregationTreeContentProvider(this.aggregation, 'I');
        this.includesTreeViewer = new DimensionParentsTreeViewer(this.cmp_left, 2050, this.dimensionProperties, (ITreeContentProvider)contentProviderIncludes, Activator.getLanguage());
        this.includesTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object o = ((TreeSelection)event.getSelection()).getFirstElement();
                if (o instanceof Concept) {
                    HandpickedAggregationComposite.this.aggregation.remIncludes((Concept)o);
                } else if (o instanceof ReferenceObject) {
                    HandpickedAggregationComposite.this.aggregation.remIncluded((ReferenceObject)o, true);
                }
            }
        });
        this.aggregation.addObserver((Observer)this.includesTreeViewer);
        this.includesTree = this.includesTreeViewer.getTree();
        this.toolkit.adapt((Control)this.includesTree, true, true);
        this.includesTree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.includesTreeViewer.setInput((Object)this.aggregation);
        this.cmp_center = new Composite((Composite)this, 0);
        this.cmp_center.setBackground(Display.getCurrent().getSystemColor(1));
        this.cmp_center.setBackgroundMode(2);
        GridLayout gl_cmp_center = new GridLayout(1, false);
        gl_cmp_center.verticalSpacing = 0;
        gl_cmp_center.horizontalSpacing = 0;
        this.cmp_center.setLayout((Layout)gl_cmp_center);
        this.cmp_center.setLayoutData((Object)new GridData(0x1000000, 4, true, true));
        this.compositeUp = new Composite(this.cmp_center, 0);
        this.compositeUp.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        GridLayout gl_compositeUp = new GridLayout();
        gl_compositeUp.marginBottom = 2;
        gl_compositeUp.marginRight = 2;
        gl_compositeUp.marginLeft = 2;
        gl_compositeUp.verticalSpacing = 2;
        gl_compositeUp.marginWidth = 2;
        gl_compositeUp.horizontalSpacing = 2;
        gl_compositeUp.marginHeight = 2;
        gl_compositeUp.numColumns = 2;
        this.compositeUp.setLayout((Layout)gl_compositeUp);
        this.compositeUp.setBackground(SWTResourceManager.getColor(1));
        this.butLeft = new Button(this.compositeUp, 0x800000);
        this.butLeft.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final Iterator iterator = ((TreeSelection)HandpickedAggregationComposite.this.excludesTreeViewer.getSelection()).iterator();
                BusyIndicator.showWhile((Display)HandpickedAggregationComposite.this.getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        while (iterator.hasNext()) {
                            Object object = iterator.next();
                            if (object instanceof Concept) {
                                HandpickedAggregationComposite.this.aggregation.addIncludes((Concept)object);
                                continue;
                            }
                            if (!(object instanceof ReferenceObject)) continue;
                            HandpickedAggregationComposite.this.aggregation.addIncluded((ReferenceObject)object, false);
                        }
                        HandpickedAggregationComposite.this.aggregation.notifyObservers();
                    }
                });
            }
        });
        this.butLeft.setLayoutData((Object)new GridData(40, 40));
        this.butLeft.setBackgroundImage(Activator.getImage("icons/base/24-arrow-previous-blue.png"));
        this.butLeft.setImage(Activator.getImage("icons/base/24-arrow-previous-blue.png"));
        this.butLeft.setForeground(ComponentsCommons.getColor((int)0, (int)0, (int)128));
        this.butRigth = new Button(this.compositeUp, 0x800000);
        this.butRigth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                final Iterator iterator = ((TreeSelection)HandpickedAggregationComposite.this.includesTreeViewer.getSelection()).iterator();
                BusyIndicator.showWhile((Display)HandpickedAggregationComposite.this.getDisplay(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        while (iterator.hasNext()) {
                            Object object = iterator.next();
                            if (object instanceof Concept) {
                                HandpickedAggregationComposite.this.aggregation.remIncludes((Concept)object);
                                continue;
                            }
                            if (!(object instanceof ReferenceObject)) continue;
                            HandpickedAggregationComposite.this.aggregation.remIncluded((ReferenceObject)object, false);
                        }
                        HandpickedAggregationComposite.this.aggregation.notifyObservers();
                    }
                });
            }
        });
        this.butRigth.setLayoutData((Object)new GridData(40, 40));
        this.butRigth.setImage(Activator.getImage("icons/base/24-arrow-next-blue.png"));
        this.butLeftAll = new Button(this.compositeUp, 0x800000);
        this.butLeftAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HandpickedAggregationComposite.this.aggregation.includeAll();
            }
        });
        this.butLeftAll.setImage(Activator.getImage("icons/base/24-arrow-back-blue.png"));
        this.butLeftAll.setLayoutData((Object)new GridData(40, 40));
        this.butLeftAll.setForeground(ComponentsCommons.getColor((int)0, (int)0, (int)128));
        this.toolkit.adapt((Control)this.butLeftAll, true, true);
        this.butRigthAll = new Button(this.compositeUp, 0x800000);
        this.butRigthAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HandpickedAggregationComposite.this.aggregation.excludeAll();
            }
        });
        this.butRigthAll.setImage(Activator.getImage("icons/base/24-arrow-forward-blue.png"));
        this.butRigthAll.setLayoutData((Object)new GridData(40, 40));
        this.butRigthAll.setForeground(ComponentsCommons.getColor((int)0, (int)0, (int)128));
        this.toolkit.adapt((Control)this.butRigthAll, true, true);
        this.cmpSeparator = new Composite(this.cmp_center, 0);
        this.cmpSeparator.setLayoutData((Object)new GridData(4, 4, false, true, 1, 1));
        this.cmpSeparator.setForeground(Display.getCurrent().getSystemColor(22));
        this.cmpSeparator.setBackground(SWTResourceManager.getColor(1));
        RowLayout rowLayout_1 = new RowLayout();
        rowLayout_1.fill = true;
        this.cmpSeparator.setLayout((Layout)rowLayout_1);
        this.compositeDown = this.toolkit.createComposite(this.cmp_center, 0);
        GridData gd_compositeDown = new GridData(16384, 4, false, false, 1, 2);
        gd_compositeDown.heightHint = 96;
        gd_compositeDown.widthHint = 87;
        this.compositeDown.setLayoutData((Object)gd_compositeDown);
        this.toolkit.paintBordersFor(this.compositeDown);
        FillLayout fl_compositeDown = new FillLayout(512);
        fl_compositeDown.spacing = 1;
        this.compositeDown.setLayout((Layout)fl_compositeDown);
        this.butGroups = new Button(this.compositeDown, 0x800000);
        this.butGroups.setVisible(false);
        this.butGroups.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Activator.notYetImplementedMessage();
            }
        });
        this.butGroups.setImage(ResourceManager.getPluginImage("org.fao.fi.fishstat.gui", "icons/actions/groups.png"));
        this.butGroups.setText(Activator.getLocalString("label.groups.first.upper"));
        this.butLoad = new Button(this.compositeDown, 0x800000);
        this.butLoad.setGrayed(true);
        this.butLoad.setEnabled(false);
        this.butLoad.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Activator.notYetImplementedMessage();
            }
        });
        this.butLoad.setText(Activator.getLocalString("label.load.first.upper"));
        this.butLoad.setImage(ResourceManager.getPluginImage("org.fao.fi.fishstat.gui", "icons/actions/diskload.ico"));
        this.butSave = new Button(this.compositeDown, 0x800000);
        this.butSave.setEnabled(false);
        this.butSave.setGrayed(true);
        this.butSave.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Activator.notYetImplementedMessage();
            }
        });
        this.butSave.setText(Activator.getLocalString("label.save.first.upper"));
        this.butSave.setImage(ResourceManager.getPluginImage("org.fao.fi.fishstat.gui", "icons/actions/disksave.ico"));
        this.cmp_right = new Composite((Composite)this, 0);
        this.cmp_right.setBackgroundMode(2);
        this.cmp_right.setBackground(SWTResourceManager.getColor(1));
        GridData gd_cmp_right = new GridData(4, 4, false, false);
        gd_cmp_right.widthHint = 250;
        this.cmp_right.setLayoutData((Object)gd_cmp_right);
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.horizontalSpacing = 0;
        gridLayout_2.marginHeight = 0;
        gridLayout_2.marginWidth = 0;
        this.cmp_right.setLayout((Layout)gridLayout_2);
        AggregationTreeContentProvider contentProviderExcludes = new AggregationTreeContentProvider(this.aggregation, 'E');
        this.excludesTreeViewer = new DimensionParentsTreeViewer(this.cmp_right, 2050, this.dimensionProperties, (ITreeContentProvider)contentProviderExcludes, Activator.getLanguage());
        this.excludesTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Object o = ((TreeSelection)event.getSelection()).getFirstElement();
                if (o instanceof Concept) {
                    HandpickedAggregationComposite.this.aggregation.addIncludes((Concept)o);
                } else if (o instanceof ReferenceObject) {
                    HandpickedAggregationComposite.this.aggregation.addIncluded((ReferenceObject)o, true);
                }
            }
        });
        this.aggregation.addObserver((Observer)this.excludesTreeViewer);
        this.excludesTree = this.excludesTreeViewer.getTree();
        this.excludesTree.setBackgroundMode(1);
        this.excludesTree.setForeground(Display.getCurrent().getSystemColor(22));
        this.excludesTree.setBackground(Display.getCurrent().getSystemColor(22));
        this.toolkit.adapt((Control)this.excludesTree, true, true);
        this.excludesTree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.excludesTreeViewer.setInput((Object)this.aggregation);
    }
}

