/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.dataset.export;

import com.csvreader.CsvWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Table;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.Measure;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.core.properties.TimeSeriesProperties;
import org.fao.fi.fishstat.gui.core.session.GuiSession;
import org.fao.fi.fishstat.gui.dataset.display.MeasureDisplayer;
import org.fao.fi.fishstat.gui.dataset.export.ExportSettings;
import org.fao.fi.fishstat.gui.views.multitable.MultiTableView;

public class CsvViewExporter
implements IRunnableWithProgress {
    private GuiSession session;
    private ExportSettings exportSettings;
    private Writer writer;
    private MultiTableView view;
    private Character separator;
    private Character textQualifier;
    private IProgressMonitor progressMonitor = null;
    private Table dimTable;
    private Table obsTable;
    private Table clcTable;
    private int exportSize;
    private boolean addMeasure = false;

    public CsvViewExporter(MultiTableView view, ExportSettings exportSettings) {
        this.view = view;
        this.exportSettings = exportSettings;
        this.session = view.getSession();
        this.dimTable = this.view.getKeyTableViewer().getTable();
        this.obsTable = this.view.getObsTableViewer().getTable();
        this.clcTable = this.view.getClcTableViewer().getTable();
        if (this.session.getDataset().getObservedMeasureDimension() == null) {
            boolean foundAmeasure = false;
            for (Dimension dimension : this.session.getDataset().getDimensions()) {
                if (!dimension.isObservedMeasure()) continue;
                foundAmeasure = true;
            }
            if (!foundAmeasure && this.session.getUnitValue().length == 2 && this.session.getUnitValue()[0] != null) {
                this.addMeasure = true;
            }
        }
    }

    public int getExportSize() {
        return this.exportSize;
    }

    public Character getTextQualifier() {
        return this.textQualifier;
    }

    public void setTextQualifier(Character textQualifier) {
        this.textQualifier = textQualifier;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public MultiTableView getView() {
        return this.view;
    }

    public Character getSeparator() {
        return this.separator;
    }

    public void setSeparator(Character separator) {
        this.separator = separator;
    }

    private void produceHeaders(CsvWriter csw, int exportType) throws IOException {
        int i = 1;
        while (i < this.dimTable.getColumnCount()) {
            csw.write(this.dimTable.getColumn(i).getText());
            ++i;
        }
        if (this.addMeasure) {
            csw.write("Unit");
        }
        if (exportType == 2) {
            i = 1;
            while (i < this.obsTable.getColumnCount()) {
                csw.write(this.obsTable.getColumn(i).getText());
                if (this.exportSettings.splitSymbols) {
                    csw.write(this.exportSettings.symbolHeader);
                }
                ++i;
            }
        } else if (exportType == 1) {
            csw.write("YEAR");
            csw.write("QUANTITY");
            if (this.exportSettings.splitSymbols) {
                csw.write(this.exportSettings.symbolHeader);
            }
        }
        if (exportType == 2) {
            i = 1;
            while (i < this.clcTable.getColumnCount()) {
                csw.write(this.clcTable.getColumn(i).getText());
                if (this.exportSettings.splitSymbols) {
                    csw.write(this.exportSettings.symbolHeader);
                }
                ++i;
            }
        }
        csw.endRecord();
    }

    private void exportSelected(CsvWriter csw, int exportType) throws IOException {
        block30: {
            int[] selItems;
            MeasureDisplayer displayer;
            TimeSeriesProperties tsp;
            block29: {
                tsp = this.session.getTimeseriesProperties();
                displayer = new MeasureDisplayer();
                selItems = this.dimTable.getSelectionIndices();
                this.exportSettings.exportTotals = this.exportSettings.exportTotals && selItems.length == this.dimTable.getItemCount();
                this.exportSize = selItems.length;
                if (this.progressMonitor != null) {
                    this.progressMonitor.beginTask("Exporting records", selItems.length);
                }
                if (exportType != 2) break block29;
                int r = 0;
                while (r < selItems.length) {
                    ObservationSeries s;
                    int row = selItems[r];
                    int i = 1;
                    while (i < this.dimTable.getColumnCount()) {
                        csw.write(this.dimTable.getItem(row).getText(i));
                        ++i;
                    }
                    if (this.addMeasure) {
                        if (this.session.getUnitValue()[1] != null && !this.session.getUnitValue()[1].equals("0")) {
                            if (this.session.getUnitValue()[1].equals("3")) {
                                csw.write(String.valueOf(this.session.getUnitValue()[0]) + " 1000");
                            } else {
                                csw.write(String.valueOf(this.session.getUnitValue()[0]) + " " + this.session.getUnitValue()[1]);
                            }
                        } else {
                            csw.write(this.session.getUnitValue()[0]);
                        }
                    }
                    if ((s = (ObservationSeries)this.view.getObsTableViewer().getElementAt(row)) == null) {
                        System.out.println("ObservationSeries from session row=" + row);
                        s = (ObservationSeries)this.session.getLastResult().getObservations().get(row);
                    }
                    int p = 0;
                    while (p < tsp.getPeriodsSize()) {
                        Measure obs = s.getMeasure(tsp.getPeriod(p));
                        if (this.exportSettings.splitSymbols) {
                            if (obs == null) {
                                csw.write("");
                                csw.write("");
                            } else {
                                csw.write(displayer.getOnlyValue(obs, true));
                                csw.write(obs.getStatus().toString());
                            }
                        } else {
                            csw.write(obs == null ? "" : (this.exportSettings.isNoSymbols() ? displayer.getOnlyValue(obs, true) : displayer.getMeasureLabel(obs, true)));
                        }
                        ++p;
                    }
                    int i2 = 1;
                    while (i2 < this.clcTable.getColumnCount()) {
                        Measure cms = s.getCalculatedMeasure(i2 - 1);
                        if (this.exportSettings.splitSymbols) {
                            if (cms == null) {
                                csw.write("");
                                csw.write("");
                            } else {
                                csw.write(displayer.getOnlyValue(cms, false));
                                csw.write(cms.getStatus().toString());
                            }
                        } else {
                            csw.write(cms == null ? "" : (this.exportSettings.isNoSymbols() ? displayer.getOnlyValue(cms, true) : displayer.getMeasureLabel(cms, true)));
                        }
                        ++i2;
                    }
                    csw.endRecord();
                    if (this.progressMonitor != null) {
                        this.progressMonitor.worked(1);
                    }
                    ++r;
                }
                break block30;
            }
            if (exportType != 1) break block30;
            int r = 0;
            while (r < selItems.length) {
                int row = selItems[r];
                ObservationSeries s = (ObservationSeries)this.view.getObsTableViewer().getElementAt(row);
                int p = 0;
                while (p < tsp.getPeriodsSize()) {
                    Measure obs = s.getMeasure(tsp.getPeriod(p));
                    if (obs == null || !obs.getStatus().toString().equals(".")) {
                        int d = 1;
                        while (d < this.dimTable.getColumnCount()) {
                            csw.write(this.dimTable.getItem(row).getText(d));
                            ++d;
                        }
                        csw.write(tsp.getPeriod(p).getYear());
                        if (this.exportSettings.splitSymbols) {
                            if (obs == null) {
                                csw.write("");
                                csw.write("");
                            } else {
                                csw.write(displayer.getOnlyValue(obs, true));
                                csw.write(obs.getStatus().toString());
                            }
                        } else {
                            csw.write(obs == null ? "" : (this.exportSettings.isNoSymbols() ? displayer.getOnlyValue(obs, true) : displayer.getMeasureLabel(obs, true)));
                        }
                        csw.endRecord();
                    }
                    ++p;
                }
                if (this.progressMonitor != null) {
                    this.progressMonitor.worked(1);
                }
                ++r;
            }
        }
    }

    private void exportTotals(CsvWriter csw) throws IOException {
        GuiSession session = this.view.getSession();
        List usedMeasures = session.getObsMeasures();
        TimeSeriesProperties tsp = session.getTimeseriesProperties();
        MeasureDisplayer displayer = new MeasureDisplayer();
        int[] selItems = this.dimTable.getSelectionIndices();
        this.exportSize = selItems.length;
        if (this.progressMonitor != null) {
            this.progressMonitor.beginTask("Exporting records", selItems.length);
        }
        int m = 0;
        while (m < (usedMeasures.size() > 0 ? usedMeasures.size() : 1)) {
            ReferenceObject measure = usedMeasures.size() > 0 ? (ReferenceObject)usedMeasures.get(m) : null;
            ObservationSeries totals = session.getGrandTotals(measure);
            String nameAtt = "";
            if (measure != null) {
                Object attVal = measure.getAttribute(measure.getConcept().getNameAttribute());
                nameAtt = attVal instanceof MultilingualString ? "- " + ((MultilingualString)attVal).getValue(Activator.getLanguage()) : "- " + attVal.toString();
            }
            int i = 1;
            while (i < this.dimTable.getColumnCount()) {
                csw.write(i == 1 ? "Totals " + nameAtt : "");
                ++i;
            }
            if (this.addMeasure) {
                csw.write("");
            }
            i = 0;
            while (i < tsp.getPeriodsSize()) {
                Measure obs = totals.getMeasure(tsp.getPeriod(i));
                if (this.exportSettings.splitSymbols) {
                    if (obs == null) {
                        csw.write("");
                        csw.write("");
                    } else {
                        csw.write(displayer.getOnlyValue(obs, true));
                        csw.write(obs.getStatus().toString());
                    }
                } else if (obs == null) {
                    csw.write("");
                } else {
                    csw.write(this.exportSettings.isNoSymbols() ? displayer.getOnlyValue(obs, true) : displayer.getMeasureLabel(obs, true));
                }
                ++i;
            }
            i = 1;
            while (i < this.clcTable.getColumnCount()) {
                Measure cms = totals.getCalculatedMeasure(i - 1);
                if (this.exportSettings.splitSymbols) {
                    if (cms == null) {
                        csw.write("");
                        csw.write("");
                    } else {
                        csw.write(displayer.getOnlyValue(cms, false));
                        csw.write(cms.getStatus().toString());
                    }
                } else if (cms == null) {
                    csw.write("");
                } else {
                    csw.write(this.exportSettings.isNoSymbols() ? displayer.getOnlyValue(cms, false) : displayer.getMeasureLabel(cms, false));
                }
                ++i;
            }
            csw.endRecord();
            if (this.progressMonitor != null) {
                this.progressMonitor.worked(1);
            }
            ++m;
        }
    }

    private void exportCitation(CsvWriter csw) throws IOException {
        if (this.exportSettings.exportCitation && this.session.getDataset().getCitation() != null) {
            csw.write(this.session.getDataset().getCitation());
        }
        csw.endRecord();
    }

    public void close() {
        if (this.writer instanceof StringWriter) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (this.writer instanceof FileWriter) {
            try {
                ((FileWriter)this.writer).flush();
                ((FileWriter)this.writer).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.done();
        }
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.progressMonitor = monitor;
        try {
            this.export();
        }
        catch (IOException e) {
            this.progressMonitor.done();
            e.printStackTrace();
        }
    }

    public void export() throws IOException {
        CsvWriter csw = new CsvWriter(this.writer, this.separator.charValue());
        if (this.textQualifier != null) {
            csw.setTextQualifier(this.textQualifier.charValue());
        }
        if (this.exportSettings.exportHeaders) {
            this.produceHeaders(csw, this.exportSettings.getExportMode());
        }
        this.exportSelected(csw, this.exportSettings.getExportMode());
        if (this.exportSettings.exportTotals && this.exportSettings.getExportMode() == 2) {
            this.exportTotals(csw);
        }
        if (this.exportSettings.exportCitation) {
            this.exportCitation(csw);
        }
    }
}

