/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.dataset.management;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.core.session.Session;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;

public class DatasetCitationDialog
extends TitleAreaDialog {
    private Dataset dataset;

    public DatasetCitationDialog(Shell parentShell) {
        super(parentShell);
        Session session = GuiCoreActivator.getDefault().getRegistry().getSessionOnFocus();
        this.dataset = session.getDataset();
    }

    protected Control createDialogArea(Composite parent) {
        parent.setBackground(SWTResourceManager.getColor(19));
        this.setTitleImage(ResourceManager.getPluginImage("org.fao.fi.fishstat.gui", "icons/actions/citationBig.png"));
        this.setTitle(String.valueOf(this.dataset.getName().getValue(Activator.getLanguage())) + " - " + Activator.getLocalString("label.citation.title"));
        this.setMessage(this.dataset.getDescription().getValue(Activator.getLanguage()));
        Composite area = (Composite)super.createDialogArea(parent);
        area.setLayout(null);
        Label lblAcronym = new Label(area, 0);
        lblAcronym.setBounds(13, 10, 500, 15);
        lblAcronym.setText(Activator.getLocalString("label.citation.text"));
        Text textCitation = new Text(area, 64);
        textCitation.setBounds(10, 50, 600, 120);
        textCitation.setText(this.dataset.getCitation());
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Point getInitialSize() {
        return new Point(700, 500);
    }
}

