/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.dataset.topothers;

import java.beans.Beans;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.core.model.aggregation.TopCriteriaWrapper;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.TopCriteria;
import org.fao.fi.fishstat.data.timeseries.api.calculated.CalculatedMeasureDefinition;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.components.widgets.combos.MeasureDimensionComboViewer;
import org.fao.fi.fishstat.gui.core.session.GuiSession;
import org.fao.fi.fishstat.gui.dataset.topothers.MeasuresComboViewer;

public class TopOtherComposite
extends Composite {
    private TopCriteriaWrapper request = null;
    private final FormToolkit toolkit = new FormToolkit(Display.getCurrent());
    private Section section;
    private Composite composite;
    private Label lblByField;
    private MeasuresComboViewer cmbPeriods;
    private Button rbtAllRecords;
    private Button rbtTop;
    private Button rbtComprising;
    private Button rbtValues;
    private Label lblRecords;
    private Label lblPercentOfTotal;
    private Label lblAndGreater;
    private Text txtNumberOfTopRecords;
    private Text txtPercentOfTotal;
    private Text txtValuesAndGreater;
    private Composite composite_1;
    private Label lblByMeasure;
    private MeasureDimensionComboViewer cmbMeasure;
    private Dimension observedMeasureDimension;

    public TopOtherComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout(256));
        this.toolkit.adapt((Composite)this);
        this.toolkit.paintBordersFor((Composite)this);
        this.init();
    }

    public TopOtherComposite(Composite parent, int style, TopCriteriaWrapper r) {
        super(parent, style);
        this.request = r;
        this.setLayout((Layout)new FillLayout(256));
        this.toolkit.adapt((Composite)this);
        this.toolkit.paintBordersFor((Composite)this);
        this.init();
        this.valorize();
        this.syncroPanel(r);
    }

    private void init() {
        this.observedMeasureDimension = this.request.getSession().getTimeseries().getDataset().getObservedMeasureDimension();
        this.section = this.toolkit.createSection((Composite)this, 256);
        this.composite = this.toolkit.createComposite((Composite)this.section, 0);
        this.composite.setLayout((Layout)new GridLayout(3, false));
        this.section.setClient((Control)this.composite);
        this.lblByField = this.toolkit.createLabel(this.composite, Activator.getLocalString("label.column.first.upper"), 0);
        GridData gridData = new GridData(4, 1024, false, false, 1, 1);
        gridData.heightHint = 20;
        gridData.widthHint = 92;
        this.lblByField.setLayoutData((Object)gridData);
        this.cmbPeriods = !Beans.isDesignTime() ? new MeasuresComboViewer(this.composite, 8, (GuiSession)this.request.getSession()) : new MeasuresComboViewer(this.composite, 8, null);
        this.cmbPeriods.setLayoutData(new GridData(4, 1024, true, false, 2, 1));
        if (this.hasObservedMeasureDimension()) {
            this.lblByMeasure = new Label(this.composite, 0);
            this.lblByMeasure.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            this.toolkit.adapt((Control)this.lblByMeasure, true, true);
            this.lblByMeasure.setText(Activator.getLocalString("label.measure.first.upper"));
            if (!Beans.isDesignTime()) {
                if (this.hasObservedMeasureDimension()) {
                    this.cmbMeasure = new MeasureDimensionComboViewer(this.composite, 0, this.request.getSession().getTimeseries(), Activator.getLanguage());
                    this.cmbMeasure.setVisible(true);
                    this.lblByMeasure.setVisible(true);
                } else {
                    this.lblByMeasure.setVisible(false);
                }
            }
            GridData gd_cmbMeasure = new GridData(4, 0x1000000, true, false, 2, 1);
            gd_cmbMeasure.widthHint = 288;
            this.cmbMeasure.setLayoutData((Object)gd_cmbMeasure);
            this.toolkit.adapt((Composite)this.cmbMeasure);
            this.toolkit.paintBordersFor((Composite)this.cmbMeasure);
        }
        this.composite_1 = this.toolkit.createCompositeSeparator(this.composite);
        GridData gridData_3 = new GridData(4, 4, false, false, 3, 1);
        gridData_3.heightHint = 5;
        this.composite_1.setLayoutData((Object)gridData_3);
        this.rbtAllRecords = new Button(this.composite, 16);
        this.rbtAllRecords.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TopOtherComposite.this.selectOption(TopOtherComposite.this.rbtAllRecords);
                TopOtherComposite.this.cmbPeriods.getComboViewer().getCombo().setEnabled(false);
                if (TopOtherComposite.this.hasObservedMeasureDimension()) {
                    TopOtherComposite.this.cmbMeasure.getComboViewer().getCombo().setEnabled(false);
                }
            }
        });
        this.rbtAllRecords.setBackground(ComponentsCommons.getColor((int)25));
        GridData gridData_2 = new GridData(16384, 4, false, true, 1, 1);
        gridData_2.heightHint = 20;
        gridData_2.widthHint = 92;
        this.rbtAllRecords.setLayoutData((Object)gridData_2);
        new Label(this.composite, 0);
        new Label(this.composite, 0);
        this.rbtTop = new Button(this.composite, 16);
        this.rbtTop.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.rbtTop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TopOtherComposite.this.selectOption(TopOtherComposite.this.rbtTop);
                TopOtherComposite.this.cmbPeriods.getComboViewer().getCombo().setEnabled(true);
                if (TopOtherComposite.this.hasObservedMeasureDimension()) {
                    TopOtherComposite.this.cmbMeasure.getComboViewer().getCombo().setEnabled(true);
                }
            }
        });
        this.rbtTop.setBackground(ComponentsCommons.getColor((int)25));
        this.txtNumberOfTopRecords = new Text(this.composite, 2048);
        this.txtNumberOfTopRecords.setTextLimit(6);
        this.txtNumberOfTopRecords.setBackground(ComponentsCommons.getColor((int)255, (int)250, (int)250));
        GridData gd_txtNumberOfTopRecords = new GridData(4, 4, false, false, 1, 1);
        gd_txtNumberOfTopRecords.widthHint = 86;
        this.txtNumberOfTopRecords.setLayoutData((Object)gd_txtNumberOfTopRecords);
        this.lblRecords = new Label(this.composite, 0);
        this.lblRecords.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        this.rbtComprising = new Button(this.composite, 16);
        this.rbtComprising.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.rbtComprising.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TopOtherComposite.this.selectOption(TopOtherComposite.this.rbtComprising);
                TopOtherComposite.this.cmbPeriods.getComboViewer().getCombo().setEnabled(true);
                if (TopOtherComposite.this.hasObservedMeasureDimension()) {
                    TopOtherComposite.this.cmbMeasure.getComboViewer().getCombo().setEnabled(true);
                }
            }
        });
        this.rbtComprising.setBackground(ComponentsCommons.getColor((int)25));
        this.txtPercentOfTotal = new Text(this.composite, 2048);
        this.txtPercentOfTotal.setTextLimit(2);
        this.txtPercentOfTotal.setBackground(ComponentsCommons.getColor((int)255, (int)250, (int)250));
        this.txtPercentOfTotal.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.lblPercentOfTotal = new Label(this.composite, 0);
        this.lblPercentOfTotal.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        this.rbtValues = new Button(this.composite, 16);
        this.rbtValues.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.rbtValues.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TopOtherComposite.this.selectOption(TopOtherComposite.this.rbtValues);
                TopOtherComposite.this.cmbPeriods.getComboViewer().getCombo().setEnabled(true);
                if (TopOtherComposite.this.hasObservedMeasureDimension()) {
                    TopOtherComposite.this.cmbMeasure.getComboViewer().getCombo().setEnabled(true);
                }
            }
        });
        this.rbtValues.setBackground(ComponentsCommons.getColor((int)25));
        this.txtValuesAndGreater = new Text(this.composite, 2048);
        this.txtValuesAndGreater.setTextLimit(8);
        this.txtValuesAndGreater.setBackground(ComponentsCommons.getColor((int)255, (int)250, (int)250));
        this.txtValuesAndGreater.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.lblAndGreater = this.toolkit.createLabel(this.composite, "", 0);
        this.lblAndGreater.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
    }

    private void selectOption(Button button) {
        if (button.equals(this.rbtAllRecords)) {
            this.txtNumberOfTopRecords.setVisible(false);
            this.txtNumberOfTopRecords.setBackground(ComponentsCommons.getColor((int)255, (int)255, (int)255));
            this.txtNumberOfTopRecords.setText("");
            this.txtPercentOfTotal.setVisible(false);
            this.txtPercentOfTotal.setBackground(ComponentsCommons.getColor((int)255, (int)255, (int)255));
            this.txtPercentOfTotal.setText("");
            this.txtValuesAndGreater.setVisible(false);
            this.txtValuesAndGreater.setBackground(ComponentsCommons.getColor((int)255, (int)255, (int)255));
            this.txtValuesAndGreater.setText("");
        } else if (button.equals(this.rbtTop)) {
            this.txtNumberOfTopRecords.setVisible(true);
            this.txtNumberOfTopRecords.setBackground(ComponentsCommons.getColor((int)245, (int)245, (int)245));
            this.txtPercentOfTotal.setVisible(false);
            this.txtPercentOfTotal.setBackground(ComponentsCommons.getColor((int)255, (int)255, (int)255));
            this.txtPercentOfTotal.setText("");
            this.txtValuesAndGreater.setVisible(false);
            this.txtValuesAndGreater.setBackground(ComponentsCommons.getColor((int)255, (int)255, (int)255));
            this.txtValuesAndGreater.setText("");
        } else if (button.equals(this.rbtComprising)) {
            this.txtNumberOfTopRecords.setVisible(false);
            this.txtNumberOfTopRecords.setBackground(ComponentsCommons.getColor((int)255, (int)255, (int)255));
            this.txtNumberOfTopRecords.setText("");
            this.txtPercentOfTotal.setVisible(true);
            this.txtPercentOfTotal.setBackground(ComponentsCommons.getColor((int)245, (int)245, (int)245));
            this.txtValuesAndGreater.setVisible(false);
            this.txtValuesAndGreater.setBackground(ComponentsCommons.getColor((int)255, (int)255, (int)255));
            this.txtValuesAndGreater.setText("");
        } else if (button.equals(this.rbtValues)) {
            this.txtNumberOfTopRecords.setVisible(false);
            this.txtNumberOfTopRecords.setBackground(ComponentsCommons.getColor((int)255, (int)255, (int)255));
            this.txtNumberOfTopRecords.setText("");
            this.txtPercentOfTotal.setVisible(false);
            this.txtPercentOfTotal.setBackground(ComponentsCommons.getColor((int)255, (int)255, (int)255));
            this.txtPercentOfTotal.setText("");
            this.txtValuesAndGreater.setVisible(true);
            this.txtValuesAndGreater.setBackground(ComponentsCommons.getColor((int)245, (int)245, (int)245));
        }
    }

    private void valorize() {
        if (!Beans.isDesignTime()) {
            this.section.setText(String.valueOf(Activator.getLocalString("label.dataset.first.upper.colon")) + " " + CoreUtils.getCurrentLang((MultilingualString)this.request.getSession().getTimeseries().getDataset().getName(), (String)Activator.getLanguage()));
        } else {
            this.section.setText("");
        }
        if (this.hasObservedMeasureDimension()) {
            this.lblByField.setText(Activator.getLocalString("label.by.field"));
            this.lblByMeasure.setText(Activator.getLocalString("label.by.measure"));
        }
        this.rbtAllRecords.setText(Activator.getLocalString("label.all.records"));
        this.rbtTop.setText(Activator.getLocalString("label.top.first.upper"));
        this.lblRecords.setText(Activator.getLocalString("label.records.first.lower"));
        this.rbtComprising.setText(Activator.getLocalString("label.records.comprising"));
        this.lblPercentOfTotal.setText(Activator.getLocalString("label.percent.of.total"));
        this.rbtValues.setText(Activator.getLocalString("label.values.first.upper"));
        this.lblAndGreater.setText(Activator.getLocalString("label.and.greater"));
    }

    public boolean hasObservedMeasureDimension() {
        return this.observedMeasureDimension != null;
    }

    protected void applyData(TopCriteriaWrapper wrapper) {
        Object selection = ((StructuredSelection)this.cmbPeriods.getSelection()).getFirstElement();
        if (selection instanceof CalculatedMeasureDefinition) {
            wrapper.setCalcmd_name(((CalculatedMeasureDefinition)selection).getName());
        } else {
            wrapper.setPeriod_id(((ObservationPeriod)selection).toString());
        }
        if (this.hasObservedMeasureDimension()) {
            wrapper.setMeasure((ReferenceObject)((StructuredSelection)this.cmbMeasure.getSelection()).getFirstElement());
        }
        if (this.rbtTop.getSelection()) {
            wrapper.setCriteriaType(TopCriteria.CriteriaType.TOP_RECORDS_NUMBER);
            wrapper.setValue(new Integer(this.txtNumberOfTopRecords.getText()).intValue());
        } else if (this.rbtComprising.getSelection()) {
            wrapper.setCriteriaType(TopCriteria.CriteriaType.TOP_RECORDS_PERCENT);
            wrapper.setValue(new Integer(this.txtPercentOfTotal.getText()).intValue());
        } else if (this.rbtValues.getSelection()) {
            wrapper.setCriteriaType(TopCriteria.CriteriaType.TOP_RECORDS_VALUE);
            wrapper.setValue(new Integer(this.txtValuesAndGreater.getText()).intValue());
        } else {
            wrapper.setCriteriaType(null);
            wrapper.setValue(0);
        }
    }

    protected void syncroPanel(TopCriteriaWrapper tw) {
        if (tw.getType() == 1) {
            if (tw.hasPeriod_id()) {
                this.cmbPeriods.setSelection((ISelection)new StructuredSelection((Object)ObservationPeriod.valueOf((String)tw.getPeriod_id())));
            }
        } else if (tw.hasCalcmd_name()) {
            this.cmbPeriods.setSelection((ISelection)new StructuredSelection((Object)tw.getSession().getLastResult().getCalculatedMeasureDefinition(tw.getCalcColName())));
        }
        if (tw.hasMeasure()) {
            this.cmbMeasure.setSelection((ISelection)new StructuredSelection((Object)tw.getMeasure()));
        }
        if (tw.hasCriteriaType()) {
            if (tw.getCriteriaType().equals((Object)TopCriteria.CriteriaType.TOP_RECORDS_NUMBER)) {
                this.rbtTop.setSelection(true);
                this.selectOption(this.rbtTop);
                this.txtNumberOfTopRecords.setText(Integer.toString(tw.getValue()));
                this.cmbPeriods.getComboViewer().getCombo().setEnabled(true);
                if (this.hasObservedMeasureDimension()) {
                    this.cmbMeasure.getComboViewer().getCombo().setEnabled(true);
                }
            } else if (tw.getCriteriaType().equals((Object)TopCriteria.CriteriaType.TOP_RECORDS_PERCENT)) {
                this.rbtComprising.setSelection(true);
                this.selectOption(this.rbtComprising);
                this.txtPercentOfTotal.setText(Integer.toString(tw.getValue()));
                this.cmbPeriods.getComboViewer().getCombo().setEnabled(true);
                if (this.hasObservedMeasureDimension()) {
                    this.cmbMeasure.getComboViewer().getCombo().setEnabled(true);
                }
            } else if (tw.getCriteriaType().equals((Object)TopCriteria.CriteriaType.TOP_RECORDS_VALUE)) {
                this.rbtValues.setSelection(true);
                this.selectOption(this.rbtValues);
                this.txtValuesAndGreater.setText(Integer.toString(tw.getValue()));
                this.cmbPeriods.getComboViewer().getCombo().setEnabled(true);
                if (this.hasObservedMeasureDimension()) {
                    this.cmbMeasure.getComboViewer().getCombo().setEnabled(true);
                }
            }
        } else {
            this.rbtAllRecords.setSelection(true);
            this.selectOption(this.rbtAllRecords);
            this.cmbPeriods.getComboViewer().getCombo().setEnabled(false);
            if (this.hasObservedMeasureDimension()) {
                this.cmbMeasure.getComboViewer().getCombo().setEnabled(false);
            }
        }
    }
}

