/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.handler.view;

import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.State;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.fao.fi.fishstat.core.session.Session;
import org.fao.fi.fishstat.core.workspaces.WorkspacesManager;
import org.fao.fi.fishstat.gui.ApplicationWorkbenchAdvisor;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;
import org.fao.fi.fishstat.gui.core.session.GuiSession;
import org.fao.fi.fishstat.gui.handler.base.AbstractHandlerWorkspaces;

public class GrandTotalHandler
extends AbstractHandlerWorkspaces
implements IElementUpdater {
    public static final String ID = "org.fao.fi.fishstat.gui.command.view.show.grandtotals";
    public static final String STATE_ID = "org.fao.fi.fishstat.gui.command.view.show.grandtotals.togglestate";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        GuiSession session = (GuiSession)GuiCoreActivator.getDefault().getRegistry().getSessionOnFocus();
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        System.out.println("GrandTotalHandler().execute() " + session.getUUID() + " state=" + session.getCalcGrandTotals());
        session.setCalcGrandTotals(!session.getCalcGrandTotals());
        commandService.refreshElements(ID, null);
        if (session.getCalcGrandTotals()) {
            ApplicationWorkbenchAdvisor.getApplicationAdvisor().activateAllGrandTotalViews((Session)session);
        } else {
            ApplicationWorkbenchAdvisor.getApplicationAdvisor().hideAllGrandTotalViews((Session)session);
        }
        return null;
    }

    @Override
    public void updateEnablement(WorkspacesManager wsm) {
        System.out.println("GrandTotalHandler().updateEnablement hasWsm=" + wsm.hasCurrentWorkspace() + " sessions=" + GuiCoreActivator.getDefault().getRegistry().getOpenSessions().size());
        this.setBaseEnabled(wsm.hasCurrentWorkspace() && GuiCoreActivator.getDefault().getRegistry().getOpenSessions().size() >= 1);
    }

    public void updateElement(UIElement element, Map parameters) {
        if (GuiCoreActivator.getDefault().getRegistry().hasSessionOnFocus()) {
            Session session = GuiCoreActivator.getDefault().getRegistry().getSessionOnFocus();
            this.setBaseEnabled(true);
            element.setChecked(session.getCalcGrandTotals());
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            Command command = commandService.getCommand(ID);
            State state = command.getState(STATE_ID);
            if (session.getCalcGrandTotals()) {
                state.setValue((Object)Boolean.TRUE);
            } else {
                state.setValue((Object)Boolean.FALSE);
            }
        }
    }
}

