/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.preferences.datadisplay;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.preferences.IGuiPreferencesConstants;

public class DataDisplayPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IGuiPreferencesConstants {
    private IPreferenceStore prefstore = Activator.getDefault().getPreferenceStore();
    private Spinner spnWidth;
    private Button btnFixedWidth;
    private Button btnDynamicWidth;
    private Button btnDiplaySeriesOnRight;

    public DataDisplayPreferencePage() {
        this.setTitle("Data display preferences");
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.btnDiplaySeriesOnRight = new Button(container, 32);
        this.btnDiplaySeriesOnRight.setText(Activator.getLocalString("display.last.timeseries.message"));
        Group grpStatisticalMeasuresColumns = new Group(container, 0);
        grpStatisticalMeasuresColumns.setLayout((Layout)new FormLayout());
        GridData gd_grpStatisticalMeasuresColumns = new GridData(4, 4, true, false, 1, 1);
        gd_grpStatisticalMeasuresColumns.heightHint = 67;
        grpStatisticalMeasuresColumns.setLayoutData((Object)gd_grpStatisticalMeasuresColumns);
        grpStatisticalMeasuresColumns.setText(Activator.getLocalString("label.statistical.measures.columns.width"));
        this.btnDynamicWidth = new Button((Composite)grpStatisticalMeasuresColumns, 16);
        this.btnDynamicWidth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDisplayPreferencePage.this.spnWidth.setVisible(false);
            }
        });
        this.btnDynamicWidth.setSelection(true);
        FormData fd_btnDynamicWidth = new FormData();
        fd_btnDynamicWidth.right = new FormAttachment(0, 114);
        fd_btnDynamicWidth.top = new FormAttachment(0, 10);
        fd_btnDynamicWidth.left = new FormAttachment(0, 10);
        this.btnDynamicWidth.setLayoutData((Object)fd_btnDynamicWidth);
        this.btnDynamicWidth.setText(Activator.getLocalString("label.dynamic.width"));
        this.btnFixedWidth = new Button((Composite)grpStatisticalMeasuresColumns, 16);
        this.btnFixedWidth.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DataDisplayPreferencePage.this.spnWidth.setVisible(true);
            }
        });
        FormData fd_btnFixedWidth = new FormData();
        fd_btnFixedWidth.top = new FormAttachment((Control)this.btnDynamicWidth, 8);
        fd_btnFixedWidth.left = new FormAttachment(0, 10);
        this.btnFixedWidth.setLayoutData((Object)fd_btnFixedWidth);
        this.btnFixedWidth.setText(Activator.getLocalString("label.fixed.width"));
        this.spnWidth = new Spinner((Composite)grpStatisticalMeasuresColumns, 2048);
        this.spnWidth.setTextLimit(3);
        fd_btnFixedWidth.right = new FormAttachment(100, -250);
        FormData fd_spnWidth = new FormData();
        fd_spnWidth.bottom = new FormAttachment((Control)this.btnFixedWidth, 0, 1024);
        fd_spnWidth.left = new FormAttachment((Control)this.btnFixedWidth, 11);
        this.spnWidth.setLayoutData((Object)fd_spnWidth);
        this.spnWidth.setMaximum(500);
        this.spnWidth.setMinimum(20);
        this.syncroPanel();
        return container;
    }

    public void init(IWorkbench workbench) {
    }

    protected void syncroPanel() {
        this.btnDiplaySeriesOnRight.setSelection(this.prefstore.getBoolean("display.series.on.right"));
        this.btnDynamicWidth.setSelection(this.prefstore.getBoolean("display.auto.justify.onscroll"));
        this.btnFixedWidth.setSelection(this.prefstore.getInt("display.fixed.columns.width") > 0);
        this.spnWidth.setSelection(this.prefstore.getInt("display.fixed.columns.width"));
        this.spnWidth.setVisible(this.prefstore.getInt("display.fixed.columns.width") > 0);
    }

    public boolean performOk() {
        this.prefstore.setValue("display.series.on.right", this.btnDiplaySeriesOnRight.getSelection());
        this.prefstore.setValue("display.auto.justify.onscroll", this.btnDynamicWidth.getSelection());
        this.prefstore.setValue("display.fixed.columns.width", this.btnDynamicWidth.getSelection() ? 0 : this.spnWidth.getSelection());
        return super.performOk();
    }

    protected void performDefaults() {
        this.btnDiplaySeriesOnRight.setSelection(this.prefstore.getDefaultBoolean("display.series.on.right"));
        this.btnDynamicWidth.setSelection(this.prefstore.getDefaultBoolean("display.auto.justify.onscroll"));
        this.btnFixedWidth.setSelection(!this.prefstore.getDefaultBoolean("display.auto.justify.onscroll"));
        this.spnWidth.setSelection(this.prefstore.getDefaultInt("display.fixed.columns.width"));
        this.spnWidth.setVisible(this.prefstore.getInt("display.fixed.columns.width") > 0);
        super.performDefaults();
    }
}

