/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.preferences.datadisplay;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.ApplicationPreferences;
import org.fao.fi.fishstat.gui.preferences.IGuiPreferencesConstants;

public class FormatHilitePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IGuiPreferencesConstants {
    private IPreferenceStore prefstore = Activator.getDefault().getPreferenceStore();
    private Combo[] combos;
    private Label[] labels;
    private Display display = PlatformUI.createDisplay();

    protected Control createContents(Composite parent) {
        this.labels = new Label[ApplicationPreferences.dataDisplayHilited.length];
        this.combos = new Combo[ApplicationPreferences.dataDisplayHilited.length];
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 4;
        gridLayout.marginBottom = 5;
        gridLayout.marginTop = 5;
        gridLayout.marginRight = 5;
        gridLayout.marginLeft = 5;
        gridLayout.numColumns = 4;
        gridLayout.horizontalSpacing = 10;
        composite.setLayout((Layout)gridLayout);
        Label showUnavailableLabel = new Label(composite, 0);
        showUnavailableLabel.setText(Activator.getLocalString("preferences.data.display.format.hilite.unavailable.label"));
        GridData gd_showUnavailableLabel = new GridData(4, 0x1000000, true, false);
        gd_showUnavailableLabel.widthHint = 189;
        showUnavailableLabel.setLayoutData((Object)gd_showUnavailableLabel);
        Combo combo = new Combo(composite, 0);
        combo.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.combos[0] = combo;
        GridData gd_cmbUnavailable = new GridData(4, 0x1000000, false, false);
        gd_cmbUnavailable.widthHint = 22;
        this.combos[0].setLayoutData((Object)gd_cmbUnavailable);
        this.combos[0].setItems(UNAVAILABLE_LABELS);
        this.labels[0] = new Label(composite, 0);
        this.labels[0].setText(Activator.getLocalString("label.color.first.lower"));
        Button btnPickUnavailable = new Button(composite, 0);
        btnPickUnavailable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatHilitePage.this.assignColor(0);
            }
        });
        btnPickUnavailable.setImage(Activator.getImage("icons/base/choose-color.png"));
        GridData gd_btnPickUnavailable = new GridData(4, 4, false, false, 1, 1);
        gd_btnPickUnavailable.widthHint = 30;
        btnPickUnavailable.setLayoutData((Object)gd_btnPickUnavailable);
        Label showNegligibleValuesLabel = new Label(composite, 0);
        GridData gd_showNegligibleValuesLabel = new GridData(4, 0x1000000, true, false);
        gd_showNegligibleValuesLabel.widthHint = 191;
        showNegligibleValuesLabel.setLayoutData((Object)gd_showNegligibleValuesLabel);
        showNegligibleValuesLabel.setText(Activator.getLocalString("preferences.data.display.format.hilite.negligible.label"));
        Combo combo_1 = new Combo(composite, 0);
        combo_1.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.combos[2] = combo_1;
        this.combos[2].setItems(NEGLIGIBLE_LABELS);
        GridData gd_cmb_negligible = new GridData(4, 0x1000000, false, false);
        gd_cmb_negligible.widthHint = 45;
        this.combos[2].setLayoutData((Object)gd_cmb_negligible);
        this.labels[2] = new Label(composite, 0);
        this.labels[2].setText(Activator.getLocalString("label.color.first.lower"));
        Button btnPickNegligible = new Button(composite, 0);
        btnPickNegligible.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatHilitePage.this.assignColor(2);
            }
        });
        btnPickNegligible.setImage(Activator.getImage("icons/base/choose-color.png"));
        GridData gd_btnPickNegligible = new GridData(4, 4, false, false, 1, 1);
        gd_btnPickNegligible.widthHint = 31;
        btnPickNegligible.setLayoutData((Object)gd_btnPickNegligible);
        Label showRepetitionAsLabel = new Label(composite, 0);
        GridData gd_showRepetitionAsLabel = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_showRepetitionAsLabel.widthHint = 185;
        showRepetitionAsLabel.setLayoutData((Object)gd_showRepetitionAsLabel);
        showRepetitionAsLabel.setText(Activator.getLocalString("preferences.data.display.format.hilite.repetition.label"));
        Combo combo_2 = new Combo(composite, 0);
        combo_2.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.combos[4] = combo_2;
        this.combos[4].setItems(REPETITIONS_LABELS);
        GridData gd_cmb_repetition = new GridData(4, 0x1000000, false, false);
        gd_cmb_repetition.widthHint = 16;
        this.combos[4].setLayoutData((Object)gd_cmb_repetition);
        this.labels[4] = new Label(composite, 0);
        this.labels[4].setText(Activator.getLocalString("label.color.first.lower"));
        Button btnPickRepetition = new Button(composite, 0);
        btnPickRepetition.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatHilitePage.this.assignColor(4);
            }
        });
        btnPickRepetition.setImage(Activator.getImage("icons/base/choose-color.png"));
        GridData gd_btnPickRepetition = new GridData(4, 4, false, false, 1, 1);
        gd_btnPickRepetition.widthHint = 25;
        btnPickRepetition.setLayoutData((Object)gd_btnPickRepetition);
        Label showZeroesAsLabel = new Label(composite, 0);
        GridData gd_showZeroesAsLabel = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_showZeroesAsLabel.widthHint = 159;
        showZeroesAsLabel.setLayoutData((Object)gd_showZeroesAsLabel);
        showZeroesAsLabel.setText(Activator.getLocalString("preferences.data.display.format.hilite.zeroes.label"));
        Combo combo_3 = new Combo(composite, 0);
        combo_3.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.combos[1] = combo_3;
        this.combos[1].setItems(ZEROES_LABELS);
        GridData gd_cmb_zeroes = new GridData(4, 0x1000000, false, false);
        gd_cmb_zeroes.widthHint = 45;
        this.combos[1].setLayoutData((Object)gd_cmb_zeroes);
        this.labels[1] = new Label(composite, 0);
        this.labels[1].setText(Activator.getLocalString("label.color.first.lower"));
        Button btnPickZeroes = new Button(composite, 0);
        btnPickZeroes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatHilitePage.this.assignColor(1);
            }
        });
        btnPickZeroes.setImage(Activator.getImage("icons/base/choose-color.png"));
        GridData gd_btnPickZeroes = new GridData(4, 4, false, false, 1, 1);
        gd_btnPickZeroes.widthHint = 24;
        btnPickZeroes.setLayoutData((Object)gd_btnPickZeroes);
        Label showEstimateAsLabel = new Label(composite, 0);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = 162;
        showEstimateAsLabel.setLayoutData((Object)gridData);
        showEstimateAsLabel.setText(Activator.getLocalString("preferences.data.display.format.hilite.estimates.label"));
        Combo combo_4 = new Combo(composite, 0);
        combo_4.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.combos[3] = combo_4;
        GridData gd_cmb_estimate = new GridData(4, 0x1000000, false, false);
        gd_cmb_estimate.widthHint = 45;
        this.combos[3].setLayoutData((Object)gd_cmb_estimate);
        this.combos[3].setItems(ESTIMATES_LABELS);
        this.labels[3] = new Label(composite, 0);
        this.labels[3].setText(Activator.getLocalString("label.color.first.lower"));
        Button btnPickEstimate = new Button(composite, 0);
        btnPickEstimate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormatHilitePage.this.assignColor(3);
            }
        });
        btnPickEstimate.setImage(Activator.getImage("icons/base/choose-color.png"));
        GridData gd_btnPickEstimate = new GridData(4, 4, false, false, 1, 1);
        gd_btnPickEstimate.widthHint = 23;
        btnPickEstimate.setLayoutData((Object)gd_btnPickEstimate);
        this.syncroPanel();
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performApply() {
        super.performApply();
    }

    public boolean performOk() {
        this.prefstore.setValue("display.hilite.unavailable", this.combos[0].getSelectionIndex());
        this.prefstore.setValue("display.hilite.negligible", this.combos[2].getSelectionIndex());
        this.prefstore.setValue("display.hilite.zeroes", this.combos[1].getSelectionIndex());
        this.prefstore.setValue("display.hilite.estimate", this.combos[3].getSelectionIndex());
        this.prefstore.setValue("display.hilite.repetition", this.combos[4].getSelectionIndex());
        this.prefstore.setValue("display.hilite.unavailable.color", StringConverter.asString((RGB)ApplicationPreferences.dataDisplayColors[0].getRGB()));
        this.prefstore.setValue("display.hilite.negligible.color", StringConverter.asString((RGB)ApplicationPreferences.dataDisplayColors[2].getRGB()));
        this.prefstore.setValue("display.hilite.zeroes.color", StringConverter.asString((RGB)ApplicationPreferences.dataDisplayColors[1].getRGB()));
        this.prefstore.setValue("display.hilite.estimate.color", StringConverter.asString((RGB)ApplicationPreferences.dataDisplayColors[3].getRGB()));
        this.prefstore.setValue("display.hilite.repetition.color", StringConverter.asString((RGB)ApplicationPreferences.dataDisplayColors[4].getRGB()));
        return super.performOk();
    }

    protected void syncroPanel() {
        this.combos[0].select(this.prefstore.getInt("display.hilite.unavailable"));
        this.labels[0].setForeground(ApplicationPreferences.dataDisplayColors[0]);
        this.combos[2].select(this.prefstore.getInt("display.hilite.negligible"));
        this.labels[2].setForeground(ApplicationPreferences.dataDisplayColors[2]);
        this.combos[4].select(this.prefstore.getInt("display.hilite.repetition"));
        this.labels[4].setForeground(ApplicationPreferences.dataDisplayColors[4]);
        this.combos[1].select(this.prefstore.getInt("display.hilite.zeroes"));
        this.labels[1].setForeground(ApplicationPreferences.dataDisplayColors[1]);
        this.combos[3].select(this.prefstore.getInt("display.hilite.estimate"));
        this.labels[3].setForeground(ApplicationPreferences.dataDisplayColors[3]);
    }

    protected void performDefaults() {
        this.combos[0].select(this.prefstore.getDefaultInt("display.hilite.unavailable"));
        ApplicationPreferences.dataDisplayColors[0] = new Color((Device)this.display, StringConverter.asRGB((String)this.prefstore.getDefaultString("display.hilite.unavailable.color")));
        this.labels[0].setForeground(ApplicationPreferences.dataDisplayColors[0]);
        this.combos[2].select(this.prefstore.getDefaultInt("display.hilite.negligible"));
        ApplicationPreferences.dataDisplayColors[2] = new Color((Device)this.display, StringConverter.asRGB((String)this.prefstore.getDefaultString("display.hilite.negligible.color")));
        this.labels[2].setForeground(ApplicationPreferences.dataDisplayColors[2]);
        this.combos[1].select(this.prefstore.getDefaultInt("display.hilite.zeroes"));
        ApplicationPreferences.dataDisplayColors[1] = new Color((Device)this.display, StringConverter.asRGB((String)this.prefstore.getDefaultString("display.hilite.zeroes.color")));
        this.labels[1].setForeground(ApplicationPreferences.dataDisplayColors[1]);
        this.combos[3].select(this.prefstore.getDefaultInt("display.hilite.estimate"));
        ApplicationPreferences.dataDisplayColors[3] = new Color((Device)this.display, StringConverter.asRGB((String)this.prefstore.getDefaultString("display.hilite.estimate.color")));
        this.labels[3].setForeground(ApplicationPreferences.dataDisplayColors[3]);
        this.combos[4].select(this.prefstore.getDefaultInt("display.hilite.repetition"));
        ApplicationPreferences.dataDisplayColors[4] = new Color((Device)this.display, StringConverter.asRGB((String)this.prefstore.getDefaultString("display.hilite.repetition.color")));
        this.labels[4].setForeground(ApplicationPreferences.dataDisplayColors[4]);
        super.performDefaults();
    }

    protected void assignColor(int hilite) {
        ColorDialog cd = new ColorDialog(this.getShell());
        cd.setText(Activator.getLocalString("label.color.assignment"));
        cd.setRGB(ApplicationPreferences.dataDisplayColors[hilite].getRGB());
        RGB newColor = cd.open();
        if (newColor == null) {
            return;
        }
        ApplicationPreferences.dataDisplayColors[hilite] = new Color((Device)this.display, newColor);
        this.labels[hilite].setForeground(ApplicationPreferences.dataDisplayColors[hilite]);
    }
}

