/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.properties.dataset;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.fao.fi.fishstat.data.reference.api.Attribute;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.widgets.combos.ConceptAttributesComboViewer;
import org.fao.fi.fishstat.gui.components.widgets.combos.ConceptParentsComboViewer;
import org.fao.fi.fishstat.gui.core.properties.ConceptProperties;
import org.fao.fi.fishstat.gui.core.properties.DimensionProperties;

public class DimensionEditorDialog
extends TitleAreaDialog {
    private DimensionProperties dimensionProperties;
    private ConceptProperties conceptProperties;
    private boolean showConcept;
    private ConceptParentsComboViewer cmbParentsViewer;
    private Label conceptLabel;
    private ConceptAttributesComboViewer cmbViewerAttribute;
    private ConceptAttributesComboViewer cmbViewerAlternate;
    private Label alternateAttributeLabel;
    private Button chkHasAlternate;
    private Group alternateAttributeGroup;
    private Label AttributeLabel;
    private boolean useAlternate = false;
    private Text txtAttributeDescription;
    private Text txtAlternateDescription;

    public DimensionEditorDialog(Shell parentShell, DimensionProperties dp, ConceptProperties cp, boolean show_concept) {
        super(parentShell);
        this.dimensionProperties = dp;
        this.conceptProperties = cp;
        this.showConcept = show_concept;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Dimension column settings");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        container.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = false;
        gridData.widthHint = 455;
        container.setLayoutData((Object)gridData);
        this.conceptLabel = new Label(container, 0);
        GridData gridData_1 = new GridData(4, 0x1000000, false, false, 1, 1);
        gridData_1.widthHint = 155;
        this.conceptLabel.setLayoutData((Object)gridData_1);
        this.conceptLabel.setText(Activator.getLocalString("label.concept.first.upper"));
        this.cmbParentsViewer = new ConceptParentsComboViewer(container, 0, Activator.getLanguage(), true);
        this.cmbParentsViewer.setInput((Object)this.dimensionProperties.getDimensionConcept());
        Combo cmbConcept = this.cmbParentsViewer.getCombo();
        cmbConcept.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        if (this.showConcept) {
            this.cmbParentsViewer.getCombo().setEnabled(true);
            this.cmbParentsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    Concept concept = (Concept)((IStructuredSelection)DimensionEditorDialog.this.cmbParentsViewer.getSelection()).getFirstElement();
                    DimensionEditorDialog.this.cmbViewerAttribute.setInput((Object)concept);
                    DimensionEditorDialog.this.cmbViewerAttribute.setSelection((ISelection)new StructuredSelection((Object)concept.getNameAttribute()));
                    DimensionEditorDialog.this.cmbViewerAlternate.setInput((Object)concept);
                    DimensionEditorDialog.this.cmbViewerAlternate.getCombo().select(0);
                }
            });
            this.cmbParentsViewer.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        } else {
            this.cmbParentsViewer.getCombo().setEnabled(false);
        }
        this.AttributeLabel = new Label(container, 0);
        GridData gd_attributeLabel = new GridData(4, 0x1000000, false, false);
        gd_attributeLabel.widthHint = 144;
        this.AttributeLabel.setLayoutData((Object)gd_attributeLabel);
        this.AttributeLabel.setText(Activator.getLocalString("label.attribute.first.upper"));
        this.cmbViewerAttribute = new ConceptAttributesComboViewer(container, 0, Activator.getLanguage());
        Concept dim_concept = this.dimensionProperties.getDimension().getConcept();
        this.cmbViewerAttribute.setInput((Object)dim_concept);
        Combo cmbAttribute = this.cmbViewerAttribute.getCombo();
        cmbAttribute.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Attribute att_selection = (Attribute)((IStructuredSelection)DimensionEditorDialog.this.cmbViewerAttribute.getSelection()).getFirstElement();
                if (att_selection != null) {
                    DimensionEditorDialog.this.txtAttributeDescription.setText(att_selection.getDescription().getValue(Activator.getLanguage()));
                }
            }
        });
        cmbAttribute.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        cmbAttribute.select(0);
        GridData gd_combo = new GridData(4, 0x1000000, true, false);
        gd_combo.widthHint = 219;
        this.cmbViewerAttribute.getCombo().setLayoutData((Object)gd_combo);
        this.cmbViewerAttribute.setSelection((ISelection)new StructuredSelection(this.cmbViewerAttribute.getElementAt(0)));
        new Label(container, 0);
        this.txtAttributeDescription = new Text(container, 2626);
        GridData gd_txtAttributeDescription = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtAttributeDescription.heightHint = 33;
        this.txtAttributeDescription.setLayoutData((Object)gd_txtAttributeDescription);
        this.alternateAttributeGroup = new Group(container, 0);
        this.alternateAttributeGroup.setText(Activator.getLocalString("label.alternate.attribute"));
        GridData gd_alternateAttributeGroup = new GridData(4, 0x1000000, false, false, 2, 1);
        gd_alternateAttributeGroup.heightHint = 94;
        gd_alternateAttributeGroup.widthHint = 415;
        this.alternateAttributeGroup.setLayoutData((Object)gd_alternateAttributeGroup);
        GridLayout gridLayout_1 = new GridLayout();
        gridLayout_1.numColumns = 2;
        this.alternateAttributeGroup.setLayout((Layout)gridLayout_1);
        this.chkHasAlternate = new Button((Composite)this.alternateAttributeGroup, 32);
        this.chkHasAlternate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DimensionEditorDialog.this.useAlternate = !DimensionEditorDialog.this.useAlternate;
                DimensionEditorDialog.this.alternateAttributeLabel.setEnabled(DimensionEditorDialog.this.useAlternate);
                DimensionEditorDialog.this.cmbViewerAlternate.getCombo().setEnabled(DimensionEditorDialog.this.useAlternate);
                DimensionEditorDialog.this.cmbViewerAlternate.getCombo().select(0);
                DimensionEditorDialog.this.txtAlternateDescription.setEnabled(DimensionEditorDialog.this.useAlternate);
                DimensionEditorDialog.this.txtAlternateDescription.setText(((Attribute)((IStructuredSelection)DimensionEditorDialog.this.cmbViewerAlternate.getSelection()).getFirstElement()).getDescription().getValue(Activator.getLanguage()));
            }
        });
        this.chkHasAlternate.setLayoutData((Object)new GridData(145, -1));
        this.chkHasAlternate.setText(Activator.getLocalString("label.use.an.alternate.attribute"));
        new Label((Composite)this.alternateAttributeGroup, 0);
        this.alternateAttributeLabel = new Label((Composite)this.alternateAttributeGroup, 0);
        this.alternateAttributeLabel.setEnabled(this.useAlternate);
        this.alternateAttributeLabel.setLayoutData((Object)new GridData(117, -1));
        this.alternateAttributeLabel.setText(Activator.getLocalString("label.alternate.attribute"));
        this.cmbViewerAlternate = new ConceptAttributesComboViewer((Composite)this.alternateAttributeGroup, 0, Activator.getLanguage());
        Combo combo = this.cmbViewerAlternate.getCombo();
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DimensionEditorDialog.this.txtAlternateDescription.setText(((Attribute)((IStructuredSelection)DimensionEditorDialog.this.cmbViewerAlternate.getSelection()).getFirstElement()).getDescription().getValue(Activator.getLanguage()));
            }
        });
        this.cmbViewerAlternate.setInput((Object)this.dimensionProperties.getDimension().getConcept());
        this.cmbViewerAlternate.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.cmbViewerAlternate.getCombo().setEnabled(this.useAlternate);
        GridData gd_combo_1 = new GridData(4, 0x1000000, true, false);
        gd_combo_1.widthHint = 211;
        this.cmbViewerAlternate.getCombo().setLayoutData((Object)gd_combo_1);
        new Label((Composite)this.alternateAttributeGroup, 0);
        this.txtAlternateDescription = new Text((Composite)this.alternateAttributeGroup, 2626);
        this.txtAlternateDescription.setEnabled(false);
        GridData gd_txtAlternateDescription = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtAlternateDescription.heightHint = 33;
        this.txtAlternateDescription.setLayoutData((Object)gd_txtAlternateDescription);
        this.cmbParentsViewer.setSelection((ISelection)new StructuredSelection(this.cmbParentsViewer.getElementAt(0)));
        if (this.conceptProperties != null) {
            this.syncroPanel();
        }
        this.txtAttributeDescription.setText(((Attribute)((IStructuredSelection)this.cmbViewerAttribute.getSelection()).getFirstElement()).getDescription().getValue(Activator.getLanguage()));
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(481, 375);
    }

    protected void syncroPanel() {
        this.cmbParentsViewer.setSelection((ISelection)new StructuredSelection((Object)this.conceptProperties.getConcept()));
        this.cmbViewerAttribute.setInput((Object)((Concept)((IStructuredSelection)this.cmbParentsViewer.getSelection()).getFirstElement()));
        this.cmbViewerAlternate.setInput((Object)((Concept)((IStructuredSelection)this.cmbParentsViewer.getSelection()).getFirstElement()));
        this.cmbViewerAttribute.setSelection((ISelection)new StructuredSelection((Object)this.conceptProperties.getAttribute()));
        this.useAlternate = this.conceptProperties.hasAlternate();
        this.alternateAttributeLabel.setEnabled(this.useAlternate);
        this.chkHasAlternate.setSelection(this.useAlternate);
        this.cmbViewerAlternate.getCombo().setEnabled(this.useAlternate);
        this.txtAlternateDescription.setEnabled(this.useAlternate);
        if (this.useAlternate) {
            this.cmbViewerAlternate.setSelection((ISelection)new StructuredSelection((Object)this.conceptProperties.getAlternate()));
            this.txtAlternateDescription.setText(this.conceptProperties.getAlternate().getDescription().getValue(Activator.getLanguage()));
        }
    }

    protected void applyData() {
        if (this.conceptProperties == null) {
            this.conceptProperties = this.dimensionProperties.newDescriptor();
        }
        Concept selection = null;
        selection = (Concept)((IStructuredSelection)this.cmbParentsViewer.getSelection()).getFirstElement();
        this.conceptProperties.setConcept(selection);
        selection = (Attribute)((IStructuredSelection)this.cmbViewerAttribute.getSelection()).getFirstElement();
        this.conceptProperties.setAttribute((Attribute)selection);
        if (this.useAlternate) {
            selection = (Attribute)((IStructuredSelection)this.cmbViewerAlternate.getSelection()).getFirstElement();
            this.conceptProperties.setAlternate((Attribute)selection);
        } else {
            this.conceptProperties.setAlternate(null);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.applyData();
            if (this.conceptProperties.getType() == 1) {
                this.dimensionProperties.addDescriptor(this.conceptProperties);
            }
            this.conceptProperties.getDimensionProperties().notifyObservers();
        }
        super.buttonPressed(buttonId);
    }
}

