/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.properties.dataset.calcmesaures;

import java.beans.Beans;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.timeseries.api.FIESMeasureSymbol;
import org.fao.fi.fishstat.data.timeseries.api.calculated.CalculatedMeasureDefinition;
import org.fao.fi.fishstat.data.timeseries.api.calculated.CalculatedMeasureDefinitionFactory;
import org.fao.fi.fishstat.data.timeseries.api.calculated.functions.Function;
import org.fao.fi.fishstat.data.timeseries.api.calculated.parameters.Parameter;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.components.composites.FunctionSkipParameters;
import org.fao.fi.fishstat.gui.components.widgets.FunctionsViewerFactory;
import org.fao.fi.fishstat.gui.core.model.functions.CalculatedMeasureDefinitionWrapper;
import org.fao.fi.fishstat.gui.core.model.functions.ParameterWrapper;
import org.fao.fi.fishstat.gui.core.properties.CalculatedMeasuresProperties;
import org.fao.fi.fishstat.gui.properties.dataset.calcmesaures.FunctionParametersPanel;

public class CalculatedMeasureEditorDialog
extends TitleAreaDialog {
    private static final int INSERT_MODE = 1;
    private static final int UPDATE_MODE = 2;
    CalculatedMeasuresProperties calculatedMeasureProperties;
    CalculatedMeasureDefinitionWrapper calculatedMeasureWrapper;
    private int mode;
    private Label lblFunction;
    private Combo combo;
    private ComboViewer comboViewer;
    private Group grpParameters;
    private Label lblColumnName;
    private Text txtColumnName;
    private FunctionSkipParameters skipParameters;
    private Group parametersGroup;
    private FunctionParametersPanel functionParametersPanel;
    private Text txtFunctionDescription;

    public CalculatedMeasureEditorDialog(Shell parentShell, CalculatedMeasuresProperties calculatedMeasureProperties, CalculatedMeasureDefinitionWrapper calculatedMeasureWrapper) {
        super(parentShell);
        this.mode = calculatedMeasureWrapper == null ? 1 : 2;
        this.calculatedMeasureProperties = calculatedMeasureProperties;
        this.calculatedMeasureWrapper = calculatedMeasureWrapper;
    }

    protected Control createDialogArea(Composite parent) {
        parent.setBackgroundMode(2);
        parent.setBackground(SWTResourceManager.getColor(1));
        this.setTitle(Activator.getLocalString("label.calculated.columns.definition.title"));
        this.setMessage(Activator.getLocalString("label.calculated.columns.definition.description"));
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        GridData gridData_8 = new GridData(1808);
        gridData_8.widthHint = 440;
        container.setLayoutData((Object)gridData_8);
        container.setLayout((Layout)new GridLayout(2, false));
        this.lblColumnName = new Label(container, 0);
        this.lblColumnName.setForeground(ComponentsCommons.getColor((int)10));
        this.lblColumnName.setFont(ComponentsCommons.getFont((String)"Tahoma", (int)8, (int)1));
        GridData gridData_9 = new GridData(4, 0x1000000, false, false, 1, 1);
        gridData_9.widthHint = 108;
        this.lblColumnName.setLayoutData((Object)gridData_9);
        this.lblColumnName.setText(Activator.getLocalString("label.column.name"));
        this.txtColumnName = new Text(container, 2048);
        GridData gridData_10 = new GridData(4, 0x1000000, false, false, 1, 1);
        gridData_10.widthHint = 241;
        this.txtColumnName.setLayoutData((Object)gridData_10);
        this.lblFunction = new Label(container, 0);
        GridData gridData = new GridData(4, 0x1000000, false, false, 1, 1);
        gridData.heightHint = 15;
        gridData.widthHint = 81;
        this.lblFunction.setLayoutData((Object)gridData);
        this.lblFunction.setFont(ComponentsCommons.getFont((String)"Tahoma", (int)8, (int)1));
        this.lblFunction.setForeground(ComponentsCommons.getColor((int)10));
        this.lblFunction.setText(Activator.getLocalString("label.function.first.upper"));
        if (Beans.isDesignTime()) {
            this.comboViewer = new ComboViewer(container, 8);
        } else {
            this.comboViewer = (ComboViewer)FunctionsViewerFactory.instance((Composite)container, (int)2056, (String)Activator.getLanguage()).getViewer(ComboViewer.class);
            this.comboViewer.setSelection((ISelection)new StructuredSelection(this.comboViewer.getElementAt(0)));
            this.comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    CalculatedMeasureEditorDialog.this.functionParametersPanel.setVisible(false);
                    CalculatedMeasureEditorDialog.this.functionParametersPanel.dispose();
                    Function selection = (Function)((IStructuredSelection)CalculatedMeasureEditorDialog.this.comboViewer.getSelection()).getFirstElement();
                    CalculatedMeasureEditorDialog.this.txtFunctionDescription.setText(selection.getDescription().getValue(Activator.getLanguage()));
                    if (CalculatedMeasureEditorDialog.this.calculatedMeasureWrapper != null && selection.equals(CalculatedMeasureEditorDialog.this.calculatedMeasureWrapper.getMeasure().getFunction())) {
                        CalculatedMeasureEditorDialog.this.functionParametersPanel = new FunctionParametersPanel((Composite)CalculatedMeasureEditorDialog.this.parametersGroup, 0, CalculatedMeasureEditorDialog.this.calculatedMeasureWrapper.getExtraParameters());
                    } else {
                        CalculatedMeasureEditorDialog.this.functionParametersPanel = new FunctionParametersPanel((Composite)CalculatedMeasureEditorDialog.this.parametersGroup, 0, selection);
                    }
                    CalculatedMeasureEditorDialog.this.parametersGroup.layout(true);
                    if (CalculatedMeasureEditorDialog.this.mode == 1) {
                        CalculatedMeasureEditorDialog.this.txtColumnName.setText(CalculatedMeasureEditorDialog.this.disambiguateColumnName((Function)CalculatedMeasureEditorDialog.this.comboViewer.getElementAt(CalculatedMeasureEditorDialog.this.combo.getSelectionIndex())));
                    }
                }
            });
        }
        this.combo = this.comboViewer.getCombo();
        GridData gridData_7 = new GridData(4, 0x1000000, false, false, 1, 1);
        gridData_7.widthHint = 216;
        this.combo.setLayoutData((Object)gridData_7);
        new Label(container, 0);
        this.txtFunctionDescription = new Text(container, 2632);
        this.txtFunctionDescription.setEditable(false);
        GridData gd_txtFunctionDescription = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_txtFunctionDescription.heightHint = 140;
        this.txtFunctionDescription.setLayoutData((Object)gd_txtFunctionDescription);
        this.grpParameters = new Group(container, 0);
        this.grpParameters.setForeground(ComponentsCommons.getColor((int)10));
        this.grpParameters.setText(Activator.getLocalString("label.parameters.first.upper"));
        GridData gridData_6 = new GridData(4, 4, false, true, 2, 1);
        gridData_6.widthHint = 484;
        this.grpParameters.setLayoutData((Object)gridData_6);
        this.grpParameters.setLayout((Layout)new GridLayout(4, false));
        this.skipParameters = new FunctionSkipParameters((Composite)this.grpParameters, 0);
        this.skipParameters.setText(Activator.getLocalString("label.skipping.parameters"));
        GridData gridData_3 = new GridData(16384, 4, false, true, 2, 1);
        gridData_3.heightHint = 111;
        gridData_3.widthHint = 218;
        this.skipParameters.setLayoutData((Object)gridData_3);
        this.skipParameters.setLayout((Layout)new GridLayout(1, false));
        new Label((Composite)this.grpParameters, 0);
        this.parametersGroup = new Group((Composite)this.grpParameters, 0);
        this.parametersGroup.setText(Activator.getLocalString("label.function.parameters"));
        this.parametersGroup.setLayout((Layout)new FillLayout(512));
        GridData gd_parametersGroup = new GridData(4, 4, true, true, 1, 1);
        gd_parametersGroup.heightHint = 116;
        this.parametersGroup.setLayoutData((Object)gd_parametersGroup);
        Function selection = (Function)((IStructuredSelection)this.comboViewer.getSelection()).getFirstElement();
        this.txtFunctionDescription.setText(selection.getDescription().getValue(Activator.getLanguage()));
        this.functionParametersPanel = this.calculatedMeasureWrapper != null && this.calculatedMeasureWrapper.getExtraParameters() != null ? new FunctionParametersPanel((Composite)this.parametersGroup, 0, this.calculatedMeasureWrapper.getExtraParameters()) : new FunctionParametersPanel((Composite)this.parametersGroup, 0, selection);
        this.txtColumnName.setEnabled(this.mode == 1);
        if (this.mode == 1) {
            this.txtColumnName.setText(this.disambiguateColumnName((Function)this.comboViewer.getElementAt(this.combo.getSelectionIndex())));
        }
        if (this.mode == 2) {
            this.syncroPanel();
        }
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(530, 600);
    }

    protected void syncroPanel() {
        Map params;
        CalculatedMeasureDefinition definition = this.calculatedMeasureWrapper.getMeasure();
        this.txtColumnName.setText(definition.getName());
        this.comboViewer.setSelection((ISelection)new StructuredSelection((Object[])new Function[]{definition.getFunction()}));
        this.txtFunctionDescription.setText(((Function)new StructuredSelection((Object[])new Function[]{definition.getFunction()}).getFirstElement()).getDescription().getValue(Activator.getLanguage()));
        Set skipStatus = definition.getSkipStatus();
        if (skipStatus != null) {
            this.skipParameters.setValue(0, skipStatus.contains(FIESMeasureSymbol.DASH));
            this.skipParameters.setValue(1, skipStatus.contains(FIESMeasureSymbol.F));
            this.skipParameters.setValue(2, skipStatus.contains(FIESMeasureSymbol.DOT));
            this.skipParameters.setValue(3, skipStatus.contains(FIESMeasureSymbol.ZERO));
        }
        if ((params = definition.getParameters()) == null) {
            this.functionParametersPanel.setVisible(false);
        } else {
            this.functionParametersPanel.setVisible(true);
            this.functionParametersPanel.syncroPanel();
        }
    }

    protected boolean chkData() {
        if (this.mode == 1) {
            if (this.txtColumnName.getText() == null || this.txtColumnName.getText().equals("")) {
                MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 33);
                messageBox.setMessage(Activator.getLocalString("message.error.function.column.cannot.empty"));
                messageBox.open();
                this.txtColumnName.setFocus();
                return false;
            }
            if (this.txtColumnName.getText() != null && !this.txtColumnName.getText().equals("") && this.calculatedMeasureProperties.isUsedName(this.txtColumnName.getText())) {
                MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 33);
                messageBox.setMessage(Activator.getLocalString("message.error.function.column.already.used"));
                messageBox.open();
                this.txtColumnName.setFocus();
                return false;
            }
        }
        if (!this.functionParametersPanel.isAllValid()) {
            MessageBox messageBox = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 33);
            messageBox.setMessage(Activator.getLocalString("message.error.function.column.invalid.param"));
            messageBox.open();
            return false;
        }
        return true;
    }

    protected void applyData() {
        if (this.mode == 1) {
            this.calculatedMeasureWrapper = new CalculatedMeasureDefinitionWrapper(this.calculatedMeasureProperties, CalculatedMeasureDefinitionFactory.create((String)this.txtColumnName.getText()));
        }
        this.calculatedMeasureWrapper.getMeasure().setFunction((Function)((IStructuredSelection)this.comboViewer.getSelection()).getFirstElement());
        HashSet<FIESMeasureSymbol> skipStatus = new HashSet<FIESMeasureSymbol>();
        if (this.skipParameters.getValue(0)) {
            skipStatus.add(FIESMeasureSymbol.DASH);
        }
        if (this.skipParameters.getValue(1)) {
            skipStatus.add(FIESMeasureSymbol.F);
        }
        if (this.skipParameters.getValue(2)) {
            skipStatus.add(FIESMeasureSymbol.DOT);
        }
        if (this.skipParameters.getValue(3)) {
            skipStatus.add(FIESMeasureSymbol.ZERO);
        }
        this.calculatedMeasureWrapper.getMeasure().setSkipStatus(skipStatus);
        if (!this.functionParametersPanel.isDisposed()) {
            this.functionParametersPanel.applyData();
            HashMap<Parameter, String> parameterMap = new HashMap<Parameter, String>();
            ParameterWrapper[] parameterWrapperArray = this.functionParametersPanel.getParameterWrappers();
            int n = parameterWrapperArray.length;
            int n2 = 0;
            while (n2 < n) {
                ParameterWrapper wr = parameterWrapperArray[n2];
                parameterMap.put(wr.getParameter(), wr.getValue());
                ++n2;
            }
            this.calculatedMeasureWrapper.getMeasure().setParameters(parameterMap);
        }
        if (this.mode == 1) {
            this.calculatedMeasureProperties.addMeasureDefinition(this.calculatedMeasureWrapper);
        }
        this.calculatedMeasureProperties.setChanged();
        this.calculatedMeasureProperties.notifyObservers();
    }

    protected void setValidParams(boolean valid) {
        this.getButton(0).setEnabled(valid);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            if (this.chkData()) {
                this.applyData();
                this.calculatedMeasureProperties.getTimeSeriesProperties().getDatasetProperties().addAction(new Integer[]{33});
                this.calculatedMeasureProperties.notifyObservers();
                super.buttonPressed(buttonId);
            }
        } else if (buttonId == 1) {
            super.buttonPressed(buttonId);
        }
    }

    private String disambiguateColumnName(Function function) {
        String colName = CoreUtils.getCurrentLang((MultilingualString)function.getName(), (String)Activator.getLanguage());
        while (this.calculatedMeasureProperties.isUsedName(colName)) {
            colName = String.valueOf(colName) + "_1";
        }
        return colName;
    }
}

