/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.common.api;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.PooledConnection;

public class ResourceManager {
    public static final String ORACLE_JDBC_DRIVER = "oracle.jdbc.driver.OracleDriver";
    public static final String DERBY_JDBC_EMBEDDED_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    public static final String POSTGREE_JDBC_DRIVER = "org.postgresql.Driver";
    public static final String ORACLE_POOLED_CONNECTION = "oracle.jdbc.pool.OraclePooledConnection";
    public static final String POSTGREE_POOLED_CONNECTION = "oracle.jdbc.pool.OraclePooledConnection";
    public static final String DEFAULT_JDBC_DRIVER = "org.apache.derby.jdbc.EmbeddedDriver";
    public static final String DEFAULT_JDBC_USER = "fishstat";
    public static final String DEFAULT_JDBC_PASSWORD = null;
    public static final String DEFAULT_JDBC_DAO_JAR_URL = null;
    public static final String DEFAULT_JDBC_SCHEMA = "FISHSTAT";
    public static final String JDBC_URL_PROPERTY = "fishstat.jdbc.url";
    public static final String JDBC_DRIVER_PROPERTY = "fishstat.jdbc.driver";
    public static final String JDBC_USER_PROPERTY = "fishstat.jdbc.user";
    public static final String JDBC_PASSWORD_PROPERTY = "fishstat.jdbc.password";
    public static final String JDBC_DAO_JAR_URL_PROPERTY = "fishstat.jdbc.dao.jar.url";
    public static final String JDBC_SCHEMA_PROPERTY = "fishstat.jdbc.schema";
    private static Driver driver = null;
    private static PooledConnection connectionsPool = null;

    public static synchronized String getJdbcUrl() {
        return System.getProperty(JDBC_URL_PROPERTY);
    }

    public static synchronized void setJdbcUrl(String url) {
        System.setProperty(JDBC_URL_PROPERTY, url);
    }

    public static synchronized String getJdbcDriver() {
        return System.getProperty(JDBC_DRIVER_PROPERTY, "org.apache.derby.jdbc.EmbeddedDriver");
    }

    public static synchronized void setJdbcDriver(String driverClassName) {
        System.setProperty(JDBC_DRIVER_PROPERTY, driverClassName);
    }

    public static synchronized String getJdbcUser() {
        return System.getProperty(JDBC_USER_PROPERTY, DEFAULT_JDBC_USER);
    }

    public static synchronized void setJdbcUser(String user) {
        System.setProperty(JDBC_USER_PROPERTY, user);
    }

    public static synchronized String getJdbcPassword() {
        return System.getProperty(JDBC_PASSWORD_PROPERTY, DEFAULT_JDBC_PASSWORD);
    }

    public static synchronized void setJdbcPassword(String password) {
        System.setProperty(JDBC_PASSWORD_PROPERTY, password);
    }

    public static String getJdbcDaoJarUrl() {
        return System.getProperty(JDBC_DAO_JAR_URL_PROPERTY, DEFAULT_JDBC_DAO_JAR_URL);
    }

    public static void setJdbcDaoJarUrl(String jar) {
        System.setProperty(JDBC_DAO_JAR_URL_PROPERTY, jar);
    }

    public static String getJdbcSchema() {
        return System.getProperty(JDBC_SCHEMA_PROPERTY, DEFAULT_JDBC_SCHEMA);
    }

    public static void setJdbcSchema(String schema) {
        System.setProperty(JDBC_SCHEMA_PROPERTY, schema);
    }

    public static void closeDriver() {
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
        }
        catch (SQLException e) {
            System.out.println("Derby database shutdown executed OK.");
        }
    }

    public static synchronized Connection getExtraConnection() throws SQLException {
        Connection connection = null;
        if (driver == null) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                System.out.println("RM 22-05-2013 16.20: loading JDBC driver: " + ResourceManager.getJdbcDriver() + " using: " + loader);
                Class<?> jdbcDriverClass = loader.loadClass(ResourceManager.getJdbcDriver());
                driver = (Driver)jdbcDriverClass.newInstance();
                DriverManager.registerDriver(driver);
                if (!ResourceManager.getJdbcDriver().equals("org.apache.derby.jdbc.EmbeddedDriver") && !ResourceManager.getJdbcDriver().equals(POSTGREE_JDBC_DRIVER)) {
                    if (ResourceManager.getJdbcDriver().equals(ORACLE_JDBC_DRIVER)) {
                        Constructor<?> c = Class.forName("oracle.jdbc.pool.OraclePooledConnection").getConstructor(String.class, String.class, String.class);
                        connectionsPool = (PooledConnection)c.newInstance(ResourceManager.getJdbcUrl(), ResourceManager.getJdbcUser(), ResourceManager.getJdbcPassword());
                    } else {
                        System.out.println("No relevant action in getting new driver");
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Failed to initialise JDBC driver");
                e.printStackTrace();
            }
        }
        if (ResourceManager.getJdbcDriver().equals(ORACLE_JDBC_DRIVER)) {
            if (connection == null || !connection.isValid(0)) {
                connection = connectionsPool.getConnection();
            }
        } else if (connection == null || !connection.isValid(0)) {
            connection = DriverManager.getConnection(ResourceManager.getJdbcUrl(), ResourceManager.getJdbcUser(), ResourceManager.getJdbcPassword());
        }
        return connection;
    }

    public static void close(Connection conn) {
        try {
            if (!ResourceManager.getJdbcDriver().equals("org.apache.derby.jdbc.EmbeddedDriver") && conn != null) {
                conn.close();
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
    }

    public static void close(PreparedStatement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
    }

    public static void close(ResultSet rs) {
        try {
            if (rs != null) {
                rs.close();
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
    }
}

