/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.common.test;

import java.io.File;
import org.fao.fi.fishstat.data.common.Commons;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.common.firestorm.FireStormHelper;
import org.fao.fi.fishstat.data.common.utils.RuntimeMemory;
import org.junit.Assert;
import org.junit.Test;

public class CommonTest {
    @Test
    public void multilingualStringTest() throws Exception {
        MultilingualString multi_one = new MultilingualString();
        multi_one.setValue("en", "value");
        MultilingualString multi_two = new MultilingualString();
        multi_two.setValue("en", "value");
        Assert.assertEquals((Object)multi_one, (Object)multi_two);
        multi_two.setValue("fr", "another value");
        Assert.assertFalse((boolean)multi_one.equals(multi_two));
        multi_two.setValue("fr", null);
        Assert.assertEquals((Object)multi_one, (Object)multi_two);
    }

    @Test
    public void getJavaNameTest() throws Exception {
        Assert.assertEquals((Object)"ThisIsATest", (Object)Commons.getJavaName("THIS_IS_A_TEST"));
        Assert.assertEquals((Object)"Test", (Object)Commons.getJavaName("TEST"));
    }

    @Test
    public void runtimeMemoryTest() throws Exception {
        RuntimeMemory.printStats();
    }

    @Test
    public void firestormHomeTest() throws Exception {
        File dir = new File(FireStormHelper.instance().getHome());
        System.out.println("Firestorm home: " + dir);
        File test = new File(dir, "jars/firestorm.jar");
        if (test.exists()) {
            System.out.println("found in: " + dir.getAbsolutePath());
            File home = dir.getCanonicalFile();
            System.out.println("home: " + home);
        }
    }
}

