/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core;

import java.beans.Statement;
import java.io.File;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.fao.fi.fishstat.core.CoreCache;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.IActionRequestWrapper;
import org.fao.fi.fishstat.core.IFSActions;
import org.fao.fi.fishstat.core.exceptions.NotEnoughMemoryException;
import org.fao.fi.fishstat.core.session.Session;
import org.fao.fi.fishstat.core.session.SessionDescriptor;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;

public abstract class CoreRegistry
extends Observable
implements IFSActions {
    public static final int MAX_OPEN_SESSIONS = 10;
    public static float machineIndicator;
    protected SessionDescriptor sessionOnFocus;
    protected Hashtable<SessionDescriptor, Session> sessions;

    public CoreRegistry() {
        this.initRegistry();
    }

    public int getOpenSessionsSize() {
        return this.sessions.size();
    }

    public List<Session> getOpenSessions() {
        return new Vector<Session>(this.sessions.values());
    }

    public List<SessionDescriptor> getOpenSessionsDesriptors() {
        return new Vector<SessionDescriptor>(this.sessions.keySet());
    }

    public List<Session> getOthersSessions(Session session) {
        LinkedList<Session> res = new LinkedList<Session>();
        for (Session activitySession : this.sessions.values()) {
            if (activitySession == session) continue;
            res.add(activitySession);
        }
        return res;
    }

    public abstract Session newSession(Timeseries var1, boolean var2) throws NotEnoughMemoryException;

    public Session addSession(Session session, boolean focus) {
        this.sessions.put(session.getDescriptor(), session);
        if (focus || this.sessionOnFocus == null) {
            this.sessionOnFocus = session.getDescriptor();
        }
        this.setChanged();
        this.notifyObservers(new Statement(session, "new", null));
        return session;
    }

    public void closeSession(Session session) {
        boolean whereonfocus = this.sessionOnFocus == session.getDescriptor();
        this.sessions.remove(session.getDescriptor());
        if (whereonfocus) {
            this.sessionOnFocus = this.sessions.size() > 0 ? this.sessions.keys().nextElement() : null;
        }
        this.setChanged();
        this.notifyObservers(new Statement(session, "close", null));
        session.dispose();
        session = null;
    }

    public void closeAllSessions() {
        Session[] sessionsToRemove = this.sessions.values().toArray(new Session[0]);
        int i = 0;
        while (i < sessionsToRemove.length) {
            this.closeSession(sessionsToRemove[i]);
            ++i;
        }
    }

    public Session getSessionOnFocus() {
        if (this.sessionOnFocus != null) {
            return this.sessions.get(this.sessionOnFocus);
        }
        return null;
    }

    public boolean hasSessionOnFocus() {
        return this.sessionOnFocus != null;
    }

    public boolean existSession(SessionDescriptor descriptor) {
        return this.sessions.containsKey(descriptor);
    }

    public Session findSession(SessionDescriptor descriptor) {
        return this.sessions.get(descriptor);
    }

    public void setSessionOnFocus(SessionDescriptor d) {
        this.sessionOnFocus = d;
        this.setChanged();
        this.notifyObservers(new Statement(this.sessions.get(d), "focus", null));
    }

    private void initRegistry() {
        this.sessions = new Hashtable(10);
    }

    public void processActionRequest(IActionRequestWrapper actionRequest, boolean relatives, IProgressMonitor pm) {
        List<SessionDescriptor> toProcess = relatives ? this.findRelatives(this.sessionOnFocus) : Arrays.asList(this.sessionOnFocus);
        for (SessionDescriptor sessionDescriptor : toProcess) {
            this.sessions.get(sessionDescriptor).execActionRequest(actionRequest, pm);
        }
    }

    public List<SessionDescriptor> findRelatives(SessionDescriptor d) {
        LinkedList<SessionDescriptor> res = new LinkedList<SessionDescriptor>();
        for (SessionDescriptor sessionDescriptor : this.getOpenSessionsDesriptors()) {
            if (!sessionDescriptor.getDataset().equals(d.getDataset())) continue;
            res.add(sessionDescriptor);
        }
        return res;
    }

    public static File getAttachmentsPath() {
        File res = new File(String.valueOf(CoreCommons.getWorkspacesManager().getCurrentWorkspace().getLocationDir().getAbsolutePath()) + File.separatorChar + "att" + File.separatorChar);
        if (!res.exists() || !res.isDirectory()) {
            throw new Error("Internal error: invalid attachment folder in workspace");
        }
        return res;
    }

    public void removeActionRequest(int action, boolean relatives, IProgressMonitor pm) {
        List<SessionDescriptor> toProcess = relatives ? this.findRelatives(this.sessionOnFocus) : Arrays.asList(this.sessionOnFocus);
        for (SessionDescriptor sessionDescriptor : toProcess) {
            this.sessions.get(sessionDescriptor).removeActionRequest(action, pm);
        }
    }

    protected long calcMemoryAllocation(Timeseries ts) {
        int observ_size = CoreCache.getTimeseriesSize(ts) * ts.getObservationPeriods().size();
        double cell_weigth = 0.0;
        cell_weigth = observ_size < 500000 ? 3.18E-4 : (observ_size >= 500000 && observ_size < 1000000 ? 2.5E-4 : (observ_size >= 1000000 && observ_size < 2000000 ? 2.0E-4 : 1.63E-4));
        return (long)((double)observ_size * cell_weigth);
    }
}

