/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.model.concept.selection;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.fao.fi.fishstat.core.ActionDescriptor;
import org.fao.fi.fishstat.core.IActionRequestWrapper;
import org.fao.fi.fishstat.core.IFSActions;
import org.fao.fi.fishstat.core.model.concept.selection.ConceptSelection;
import org.fao.fi.fishstat.core.session.Session;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.Selection;

public class FilterWrapper
implements IActionRequestWrapper,
IFSActions {
    protected Session session;
    protected ActionDescriptor descriptor;
    protected ConceptSelection[] keys;
    protected HashMap<String, ConceptSelection> keyRegistry;
    protected List<Dimension> dimensions;

    public FilterWrapper(Session session) {
        this.session = session;
        this.descriptor = new ActionDescriptor(this);
        try {
            this.dimensions = session.getDataset().getDimensions();
            this.keys = new ConceptSelection[this.dimensions.size()];
            this.keyRegistry = new HashMap(this.dimensions.size());
            int i = 0;
            while (i < this.dimensions.size()) {
                Dimension dimension = this.dimensions.get(i);
                this.keys[i] = new ConceptSelection(dimension.getConcept(), new HashSet<ReferenceObject>(dimension.getConcept().getObjects()));
                this.keyRegistry.put(dimension.getConcept().getAcronym(), this.keys[i]);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    public int size() {
        return this.keys.length;
    }

    public ConceptSelection getConceptSelection(int i) {
        return this.keys[i];
    }

    public ConceptSelection getConceptSelection(String acronym) {
        return this.keyRegistry.get(acronym);
    }

    public Dimension getDimension(int i) {
        return this.dimensions.get(i);
    }

    public boolean isEmptySelection() {
        int i = 0;
        while (i < this.keys.length) {
            if (!this.keys[i].isNothingIncluded()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public ActionDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public int getAction() {
        return 2;
    }

    public Selection getActionRequest() {
        Selection result = Selection.instance();
        ConceptSelection[] conceptSelectionArray = this.keys;
        int n = this.keys.length;
        int n2 = 0;
        while (n2 < n) {
            ConceptSelection dsel = conceptSelectionArray[n2];
            if (dsel.isNothingIncluded()) {
                result.set(dsel.getConcept(), dsel.getAll());
            } else {
                result.set(dsel.getConcept(), dsel.getIncludes());
            }
            ++n2;
        }
        return result;
    }
}

