/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.model.persistence;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.model.attachment.AttachmentModel;
import org.fao.fi.fishstat.core.model.dataset.TimeseriesAttributeModel;
import org.fao.fi.fishstat.core.model.dataset.TimeseriesModel;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.timeseries.api.Attachment;
import org.fao.fi.fishstat.data.timeseries.api.AttachmentType;
import org.fao.fi.fishstat.data.timeseries.api.Attribute;
import org.fao.fi.fishstat.data.timeseries.api.AttributeFactory;
import org.fao.fi.fishstat.data.timeseries.api.DataSource;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.TimeResolution;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.TimeseriesServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.management.TimeseriesManagementServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.management.descriptors.AttachmentDescriptor;
import org.fao.fi.fishstat.data.timeseries.api.management.descriptors.DescriptorsFactory;
import org.fao.fi.fishstat.data.timeseries.api.management.descriptors.TimeseriesDescriptor;

public class TimeseriesPersistenceService {
    private IProgressMonitor monitor;

    protected TimeseriesPersistenceService() {
    }

    public IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public void removeMonitor() {
        this.monitor.done();
        this.monitor = null;
    }

    public void deleteDataset(Dataset dataset) throws Exception {
        for (Timeseries timeseries : dataset.getTimeseries()) {
            TimeseriesManagementServiceFactory.getService().removeTimeseries(timeseries);
        }
        TimeseriesManagementServiceFactory.getService().removeDataset(dataset);
        CoreCommons.getWorkspaceStatus().fireModifyEvent(Dataset.class);
    }

    public Timeseries persistTimeseries(String dataset_acronym, TimeseriesModel timeseriesModel) throws Exception {
        if (timeseriesModel.isNative()) {
            throw new Exception("Timeseries modification is not allowed");
        }
        return this.persistNewTimeseries(dataset_acronym, timeseriesModel);
    }

    private Timeseries persistNewTimeseries(String dataset_acronym, TimeseriesModel timeseriesModel) throws Exception {
        if (this.monitor != null) {
            this.monitor.beginTask("Saving Timeseries...", 10);
        }
        if (this.monitor != null) {
            this.monitor.worked(1);
        }
        Dataset dataset = TimeseriesServiceFactory.getService().getDataset(dataset_acronym);
        HashMap<Attribute, String> attributes = new HashMap<Attribute, String>();
        for (TimeseriesAttributeModel timeseriesAttributeModel : timeseriesModel.getAttributes()) {
            Attribute attr = AttributeFactory.get((String)timeseriesAttributeModel.getAcronym());
            attr.setName(timeseriesAttributeModel.getName().getInstance());
            attr.setDescription(timeseriesAttributeModel.getDescription().getInstance());
            attributes.put(attr, timeseriesAttributeModel.getValue());
        }
        TimeseriesDescriptor descriptor = DescriptorsFactory.createTimeseriesDescriptor((Dataset)dataset, (DataSource)timeseriesModel.getDatasource(), (String)timeseriesModel.getAcronym(), (MultilingualString)timeseriesModel.getName().getInstance(), (MultilingualString)timeseriesModel.getDescription().getInstance(), (TimeResolution)timeseriesModel.getTimeResolution(), (ObservationPeriod)timeseriesModel.getFirstObservationPeriod(), (ObservationPeriod)timeseriesModel.getLastObservationPeriod(), attributes, null);
        Timeseries result = TimeseriesManagementServiceFactory.getService().createTimeseries(descriptor);
        return result;
    }

    public void deleteTimeseries(Timeseries timeseries) throws Exception {
        TimeseriesManagementServiceFactory.getService().removeTimeseries(timeseries);
        CoreCommons.getWorkspaceStatus().fireModifyEvent(Timeseries.class);
    }

    public Attachment persistAttachment(AttachmentModel attachmentModel) throws Exception {
        if (attachmentModel.isNative()) {
            return this.alterAttachment(attachmentModel);
        }
        return this.persistNewAttachment(attachmentModel);
    }

    private Attachment persistNewAttachment(AttachmentModel attachmentModel) throws Exception {
        AttachmentDescriptor descriptor = DescriptorsFactory.createAttachmentDescriptor((String)attachmentModel.getAcronym(), (Dataset)attachmentModel.getDataset(), (MultilingualString)attachmentModel.getName().getInstance(), (MultilingualString)attachmentModel.getDescription().getInstance(), (AttachmentType)attachmentModel.getType(), (String)attachmentModel.getMimeType(), (MultilingualString)attachmentModel.getFileName().getInstance());
        Attachment res = TimeseriesManagementServiceFactory.getService().addAttachment(descriptor);
        CoreCommons.getWorkspaceStatus().fireModifyEvent(Attachment.class);
        return res;
    }

    private Attachment alterAttachment(AttachmentModel attachmentModel) throws Exception {
        Attachment attachmentToDelete = (Attachment)attachmentModel.getInstance();
        TimeseriesManagementServiceFactory.getService().removeAttachemnt(attachmentToDelete);
        Attachment res = this.persistNewAttachment(attachmentModel);
        CoreCommons.getWorkspaceStatus().fireModifyEvent(Attachment.class);
        return res;
    }

    public void deleteDatasetAttachment(Attachment attachment) throws Exception {
        MultilingualString fileName = attachment.getFileName();
        TimeseriesManagementServiceFactory.getService().removeAttachemnt(attachment);
        CoreCommons.getWorkspaceStatus().fireModifyEvent(Attachment.class);
        List<String> allFileNames = this.buildAttachmentFileList();
        for (String ln : MultilingualString.LANGUAGES) {
            String attachmentFile = fileName.getValue(ln);
            if (attachmentFile == null || allFileNames.contains(attachmentFile)) continue;
            this.removeAttachmentFile(attachmentFile);
        }
        CoreCommons.getWorkspaceStatus().fireModifyEvent(Attachment.class);
    }

    public void deleteAllAttachments() throws Exception {
        TimeseriesManagementServiceFactory.getService().removeAllAttachemnts();
        CoreCommons.getWorkspaceStatus().fireModifyEvent(Attachment.class);
    }

    private void removeAttachmentFile(String attachmentFile) throws Exception {
        File attachmentsDir = CoreCommons.getWorkspacesManager().getCurrentWorkspace().getAttachmentsDir();
        File fileToDelete = new File(attachmentsDir, attachmentFile);
        if (fileToDelete.exists()) {
            fileToDelete.delete();
            CoreCommons.getWorkspaceStatus().fireModifyEvent(Attachment.class);
        }
    }

    private List<String> buildAttachmentFileList() {
        LinkedList<String> res = new LinkedList<String>();
        Collection datasets = TimeseriesServiceFactory.getService().getDatasets();
        for (Dataset dataset : datasets) {
            Collection attachments = dataset.getAttachments().values();
            for (Attachment attachment : attachments) {
                for (String ln : MultilingualString.LANGUAGES) {
                    String fileName = attachment.getFileName().getValue(ln);
                    if (res.contains(fileName)) continue;
                    res.add(fileName);
                }
            }
        }
        return res;
    }
}

