/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.core.model.validators;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.fao.fi.fishstat.core.ValidationSourcedStatus;
import org.fao.fi.fishstat.core.model.validators.ValidAcronym;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.impl.DatasetFactory;

public class ValidTimeseries
implements IValidator {
    private Object source;

    public ValidTimeseries() {
    }

    public ValidTimeseries(Object source) {
        this.source = source;
    }

    public IStatus validate(Object value) {
        block7: {
            Dataset dataset = null;
            try {
                if (!(value instanceof String[]) || ((String[])value).length != 2) break block7;
                String[] s_arr = (String[])value;
                String dataset_acronym = s_arr[0];
                String timeseries_acronym = s_arr[1];
                IStatus valid_dataset_acronym = new ValidAcronym(this.source).validate(dataset_acronym);
                if (valid_dataset_acronym.equals(Status.OK_STATUS)) {
                    dataset = DatasetFactory.instance().getDataset(dataset_acronym);
                    if (dataset == null) {
                        return this.source == null ? ValidationStatus.error((String)"Undefined dataset") : ValidationSourcedStatus.error("Undefined dataset", this.source);
                    }
                } else {
                    return valid_dataset_acronym;
                }
                IStatus valid_timeseries_acronym = new ValidAcronym(this.source).validate(timeseries_acronym);
                if (valid_timeseries_acronym.equals(Status.OK_STATUS)) {
                    Timeseries timeseries = dataset.getTimeseries(timeseries_acronym);
                    if (timeseries == null) {
                        return this.source == null ? ValidationStatus.error((String)"Undefined timeseries") : ValidationSourcedStatus.error("Undefined timeseries", this.source);
                    }
                    break block7;
                }
                return valid_timeseries_acronym;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return Status.OK_STATUS;
    }
}

