/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.statushandlers.AbstractStatusHandler;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.CoreRegistry;
import org.fao.fi.fishstat.core.session.Session;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.ApplicationAdvisor;
import org.fao.fi.fishstat.gui.ApplicationWorkbenchWindowAdvisor;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;
import org.fao.fi.fishstat.gui.core.session.PersistenceFactory;
import org.fao.fi.fishstat.gui.preferences.IGuiPreferencesConstants;

public class ApplicationWorkbenchAdvisor
extends WorkbenchAdvisor
implements IGuiPreferencesConstants {
    private static ApplicationAdvisor applicationAdvisor;
    public static boolean shuttingDown;
    private long preStartupTime;
    private long pstStartupTime;

    static {
        shuttingDown = false;
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new ApplicationWorkbenchWindowAdvisor(configurer);
    }

    public String getInitialWindowPerspectiveId() {
        return "org.fao.fi.fishstat.gui.perspective.main";
    }

    public String getMainPreferencePageId() {
        return "org.fao.fi.fishstat.gui.preferences.general";
    }

    public synchronized AbstractStatusHandler getWorkbenchErrorHandler() {
        return super.getWorkbenchErrorHandler();
    }

    public static ApplicationAdvisor getApplicationAdvisor() {
        return applicationAdvisor;
    }

    public void postStartup() {
        super.postStartup();
        CoreCommons.getWorkspacesManager();
        this.pstStartupTime = System.currentTimeMillis();
        CoreRegistry.machineIndicator = this.pstStartupTime - this.preStartupTime;
        applicationAdvisor = new ApplicationAdvisor();
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ((IContextService)PlatformUI.getWorkbench().getService(IContextService.class)).activateContext("org.fao.fi.fishstat.gui.context");
            }
        });
        PreferenceManager pm = PlatformUI.getWorkbench().getPreferenceManager();
        List preferenceNodes = pm.getElements(0);
        for (Object object : preferenceNodes) {
            PreferenceNode preferenceNode;
            if (!(object instanceof PreferenceNode) || !(preferenceNode = (PreferenceNode)object).getId().startsWith("org.eclipse")) continue;
            pm.remove((IPreferenceNode)preferenceNode);
        }
        ApplicationWorkbenchAdvisor.getApplicationAdvisor().syncMenus();
    }

    public static void getPrecedentSession() {
        Activator.getDefault().getLog().log((IStatus)new Status(1, "org.fao.fi.fishstat.gui", "Starting to retreive precedent session"));
        try {
            final Session[] sessions = PersistenceFactory.retrieveWorkingSession();
            if (sessions == null) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.fao.fi.fishstat.gui", "sessions null"));
            }
            final String message = Activator.getLocalString("label.loading.precedent.session.dots");
            if (sessions.length > 0) {
                IRunnableWithProgress runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            int i = 0;
                            while (i < sessions.length) {
                                GuiCoreActivator.getDefault().getRegistry().addSession(sessions[i], true);
                                sessions[i].compute(message, monitor);
                                ++i;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                PlatformUI.getWorkbench().getProgressService().run(false, false, runnable);
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.fao.fi.fishstat.gui", "Error activating precedent session", (Throwable)e));
        }
    }

    public void preStartup() {
        this.preStartupTime = System.currentTimeMillis();
        super.preStartup();
    }

    public boolean preShutdown() {
        shuttingDown = true;
        ApplicationAdvisor.workspaceClose();
        return super.preShutdown();
    }

    public void postShutdown() {
        super.postShutdown();
    }
}

