/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.autoupdate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.fao.fi.fishstat.autoupdate.gen.AutoUpdate;
import org.fao.fi.fishstat.autoupdate.gen.AutoUpdateWks;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.VersionId;
import org.fao.fi.fishstat.gui.Activator;
import org.osgi.framework.FrameworkUtil;

public class AutoUpdateMain {
    private static final String PLUGIN_ID = "fishstat.gui.autoupdate";
    private boolean hasValidAutoUpdate = false;
    private String currentVersionURL = "http://www.fao.org/fishery/static/FishStatJ/current_version.xml";
    private VersionId currentVersion = new VersionId(FrameworkUtil.getBundle(this.getClass()).getVersion().toString());
    private AutoUpdate autoupdate = null;

    public AutoUpdateMain() {
        String versionXML = this.Get_URL(this.currentVersionURL);
        if (versionXML == null) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, "current_version.xml download failed"));
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"FishStatJ is working off-line", (String)"FishStatJ cannot connect to http://www.fao.org, and as a result\na check for application updates and download of data is not possible.\n\nOnly workspaces installed previously are available.\n\nTo fix this, please connect to the internet or update firewall settings.");
            return;
        }
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{AutoUpdate.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            this.autoupdate = (AutoUpdate)jaxbUnmarshaller.unmarshal((Reader)new StringReader(versionXML));
            if (this.autoupdate.getAutoUpdateWks().size() == 0) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, "AutoUpdateImpl: no workspaces defined"));
                return;
            }
            Activator.getDefault().getLog().log((IStatus)new Status(1, PLUGIN_ID, String.valueOf(this.currentVersion.toString()) + ", AutoUpdate(ver=" + this.autoupdate.getVersion() + ", date=" + this.autoupdate.getDate() + ", url=" + this.autoupdate.getUrl() + ")"));
            this.hasValidAutoUpdate = true;
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    public List<AutoUpdateWks> getAutoupdateWorkspaces() {
        if (!this.hasValidAutoUpdate) {
            return new ArrayList<AutoUpdateWks>();
        }
        return this.autoupdate.getAutoUpdateWks();
    }

    private String Get_URL(String httpURL) {
        HttpURLConnection httpConnn;
        StringBuffer sbuf;
        String inputLine;
        block4: {
            inputLine = null;
            sbuf = null;
            httpConnn = (HttpURLConnection)new URL(httpURL).openConnection();
            httpConnn.setRequestProperty("User-Agent", "FishStatJ v" + this.currentVersion.toString() + " " + System.getProperty("os.name"));
            httpConnn.setConnectTimeout(7000);
            httpConnn.setRequestMethod("GET");
            httpConnn.connect();
            int code = httpConnn.getResponseCode();
            if (code == 200) break block4;
            return null;
        }
        try {
            sbuf = new StringBuffer();
            BufferedReader in = new BufferedReader(new InputStreamReader(httpConnn.getInputStream(), "UTF-8"));
            while ((inputLine = in.readLine()) != null) {
                sbuf.append(inputLine);
                sbuf.append("\r\n");
            }
            in.close();
            httpConnn.disconnect();
        }
        catch (Exception exp) {
            return null;
        }
        return sbuf.toString();
    }

    public boolean isHasValidAutoUpdate() {
        return this.hasValidAutoUpdate;
    }

    public boolean isNewVersionAvailable() {
        if (!this.hasValidAutoUpdate) {
            return false;
        }
        VersionId updateVersion = new VersionId(this.autoupdate.getVersion());
        return updateVersion.compareTo(this.currentVersion) > 0 && this.hasValidAutoUpdate;
    }

    public void openWebSite() {
        if (!this.hasValidAutoUpdate) {
            return;
        }
        try {
            String osName = System.getProperty("os.name").toLowerCase();
            String updateURL = this.autoupdate.getUrl();
            if (updateURL == null) {
                return;
            }
            if (osName.indexOf("windows") != -1) {
                Runtime.getRuntime().exec("explorer.exe \"" + updateURL + "\"");
            } else if (osName.indexOf("mac") != -1) {
                Runtime.getRuntime().exec(new String[]{"open", "-a", "Safari", updateURL});
            } else {
                Runtime.getRuntime().exec(new String[]{"/usr/bin/open", updateURL});
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getVersion() {
        if (!this.hasValidAutoUpdate) {
            return null;
        }
        return this.autoupdate.getVersion();
    }

    public int openManual() {
        File workspaceRoot = CoreCommons.getWorkspacesManager().getRoot();
        File manualFolder = new File(String.valueOf(workspaceRoot.getAbsolutePath()) + File.separator + "manual");
        if (!manualFolder.exists() && !manualFolder.mkdir()) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, "Error creating manual directory (1)"));
            return 1;
        }
        String manualPath = null;
        String manualURL = null;
        if (this.hasValidAutoUpdate) {
            manualURL = this.autoupdate.getManual();
            manualPath = String.valueOf(manualFolder.getAbsolutePath()) + File.separator + manualURL.substring(manualURL.lastIndexOf(47) + 1, manualURL.length());
            if (!new File(manualPath).exists()) {
                this.downloadFile(manualURL, manualPath);
                if (!new File(manualPath).exists()) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, "Download error (2)"));
                    return 2;
                }
            }
        } else {
            File[] manuals = manualFolder.listFiles();
            if (manuals.length == 0) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, "No cached manuals (3)"));
                return 3;
            }
            manualPath = manuals[manuals.length - 1].getAbsolutePath();
            System.out.println("    manualPath=" + manualPath);
        }
        if (manualPath == null) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, "Invalid path (4)"));
            return 4;
        }
        try {
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.indexOf("windows") != -1) {
                Runtime.getRuntime().exec("explorer.exe \"" + new File(manualPath).toURI().toURL().toString() + "\"");
            } else if (osName.indexOf("mac") != -1) {
                Runtime.getRuntime().exec(new String[]{"open", "-a", "Finder", new File(manualPath).toURI().toURL().toString()});
            } else {
                Runtime.getRuntime().exec(new String[]{"/usr/bin/open", new File(manualPath).getAbsolutePath()});
            }
        }
        catch (Exception e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, "Opening PDF (5)" + e.getMessage(), (Throwable)e));
            e.printStackTrace();
            return 5;
        }
        return 0;
    }

    public void downloadFile(final String httpURL, final String outFileName) {
        try {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    AutoUpdateMain.this.http_GetFile(httpURL, outFileName, monitor);
                }
            };
            PlatformUI.getWorkbench().getProgressService().run(false, false, runnable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void http_GetFile(String httpURL, String outFileName, IProgressMonitor monitor) {
        Activator.getDefault().getLog().log((IStatus)new Status(1, PLUGIN_ID, "http_GetFile(" + httpURL + "," + outFileName + ")"));
        InputStream httpInStream = null;
        FileOutputStream fos = null;
        HttpURLConnection httpConnn = null;
        int FileLength = 0;
        try {
            try {
                httpConnn = (HttpURLConnection)new URL(httpURL).openConnection();
                httpConnn.setRequestProperty("User-Agent", "FishStatJ v" + this.currentVersion.toString() + " " + System.getProperty("os.name"));
                httpConnn.setRequestMethod("HEAD");
                httpConnn.getInputStream();
                FileLength = httpConnn.getContentLength();
            }
            catch (Exception e) {
                httpConnn.disconnect();
                Activator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, "Error opening connection: " + e.getMessage(), (Throwable)e));
                httpConnn.disconnect();
                return;
            }
        }
        finally {
            httpConnn.disconnect();
        }
        monitor.beginTask(Activator.getLocalString("label.manual.downloading"), FileLength);
        try {
            int bufLength;
            fos = new FileOutputStream(new File(outFileName));
            httpConnn = (HttpURLConnection)new URL(httpURL).openConnection();
            httpConnn.setRequestProperty("User-Agent", "FishStatJ v" + this.currentVersion.toString() + " " + System.getProperty("os.name"));
            httpConnn.setConnectTimeout(7000);
            httpConnn.setRequestMethod("GET");
            httpConnn.connect();
            int code = httpConnn.getResponseCode();
            if (code != 200) {
                try {
                    fos.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Activator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, "Error connection status=" + code + " (expected 200)"));
                return;
            }
            httpInStream = httpConnn.getInputStream();
            byte[] byteBuffer = new byte[10000];
            while ((bufLength = httpInStream.read(byteBuffer)) != -1) {
                fos.write(byteBuffer, 0, bufLength);
                monitor.worked(bufLength);
            }
            httpInStream.close();
            httpConnn.disconnect();
            monitor.done();
            fos.close();
            Activator.getDefault().getLog().log((IStatus)new Status(1, PLUGIN_ID, String.valueOf(outFileName) + " downdload OK"));
        }
        catch (Exception exp) {
            monitor.done();
            Activator.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, "Error while downlaoding " + exp.getMessage(), (Throwable)exp));
            return;
        }
        Activator.getDefault().getLog().log((IStatus)new Status(1, PLUGIN_ID, "downloaded manual " + httpURL));
    }
}

