/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.dataset.management;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wb.swt.ResourceManager;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.core.CoreRegistry;
import org.fao.fi.fishstat.core.exceptions.NotEnoughMemoryException;
import org.fao.fi.fishstat.core.session.Session;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.exceptions.TimeseriesServiceException;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;
import org.fao.fi.fishstat.gui.core.GuiCoreActivator;
import org.fao.fi.fishstat.gui.dataset.management.DatasetManagementComposite;
import org.fao.fi.fishstat.gui.preferences.IGuiPreferencesConstants;

public class DatasetManagementDialog
extends TitleAreaDialog
implements IGuiPreferencesConstants {
    DatasetManagementComposite panel;

    public DatasetManagementDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(66800);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitleImage(ResourceManager.getPluginImage("org.fao.fi.fishstat.gui", "icons/actions/sugar-cubes-icon.png"));
        parent.setBackground(ComponentsCommons.getColor((int)245, (int)245, (int)245));
        this.setTitle(Activator.getLocalString("dataset.management.dialog.title"));
        this.setMessage(Activator.getLocalString("dataset.management.dialog.subtitle"));
        Composite area = (Composite)super.createDialogArea(parent);
        area.setBackground(ComponentsCommons.getColor((int)245, (int)245, (int)245));
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        area.setLayout((Layout)gridLayout);
        new Label(area, 0);
        this.panel = new DatasetManagementComposite(area, 0);
        this.panel.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.panel.setHostTitleAreaDialog(this);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setBackground(ComponentsCommons.getColor((int)245, (int)245, (int)245));
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(1020, 750);
    }

    protected void okPressed() {
        this.getShell().setVisible(false);
        Object selection = ((TreeSelection)this.panel.getCmpLeft().getDatasetsTreeViewer().getSelection()).getFirstElement();
        try {
            this.processSelection(selection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void configureShell(Shell newShell) {
        newShell.setBackground(SWTResourceManager.getColor(1));
        newShell.setBackgroundMode(2);
        super.configureShell(newShell);
        newShell.setImage(ResourceManager.getPluginImage("org.fao.fi.fishstat.gui", "icons/actions/cube.png"));
        newShell.setText(Activator.getLocalString("dataset.management.dialog.bartitle"));
    }

    protected void processSelection(Object selection) throws Exception {
        if (selection instanceof Dataset) {
            try {
                Collection timeseries = ((Dataset)selection).getTimeseries();
                Iterator iterator = timeseries.iterator();
                while (iterator.hasNext()) {
                    this.openTimeSeriesSession((Timeseries)iterator.next());
                }
            }
            catch (TimeseriesServiceException e) {
                e.printStackTrace();
            }
        } else if (selection instanceof Timeseries) {
            this.openTimeSeriesSession((Timeseries)selection);
        }
    }

    private void openTimeSeriesSession(Timeseries ts) throws Exception {
        boolean isOpenTimeseries = false;
        CoreRegistry registry = GuiCoreActivator.getDefault().getRegistry();
        int i = 0;
        while (i < registry.getOpenSessionsSize()) {
            if (((Session)registry.getOpenSessions().get(i)).getTimeseries() == ts) {
                isOpenTimeseries = true;
            }
            ++i;
        }
        if (isOpenTimeseries) {
            MessageBox mb = new MessageBox(Display.getDefault().getActiveShell());
            mb.setText("Cannot open Timseries more than once");
            mb.setMessage("The timeseries " + ts.getDataset().getAcronym() + " is already open");
            mb.open();
            return;
        }
        try {
            final Session session = GuiCoreActivator.getDefault().getRegistry().newSession(ts, true);
            final String message = String.valueOf(Activator.getLocalString("label.timeseries.loading")) + ": " + ts.getDataset().getAcronym() + " - " + ts.getAcronym();
            PlatformUI.getWorkbench().getProgressService().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    session.loadFullTimeseries(message, monitor);
                }
            });
        }
        catch (NotEnoughMemoryException e) {
            MessageBox mb = new MessageBox(Display.getDefault().getActiveShell());
            mb.setMessage(Activator.getLocalString("label.not.enough.memory.exclamation"));
            mb.open();
        }
    }
}

