/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.dataset.management;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.swt.ResourceManager;
import org.fao.fi.fishstat.data.timeseries.api.Attachment;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.dataset.management.SingleAttachmentComposite;

public class SingleAttachmentDialog
extends TitleAreaDialog {
    private Attachment attachment;

    public SingleAttachmentDialog(Shell parentShell, Attachment attachment) {
        super(parentShell);
        this.attachment = attachment;
    }

    protected Control createDialogArea(Composite parent) {
        String att_acronym = this.attachment.getAcronym();
        this.setTitleImage(ResourceManager.getPluginImage("org.fao.fi.fishstat.gui", "icons/actions/map.png"));
        this.setTitle(this.attachment.getName().getValue(Activator.getLanguage()));
        this.setMessage(this.attachment.getDescription().getValue(Activator.getLanguage()));
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new FillLayout(256));
        container.setLayoutData((Object)new GridData(1808));
        new SingleAttachmentComposite(container, 0, this.attachment);
        if (att_acronym.endsWith("MAP") || att_acronym.endsWith("map")) {
            this.setTitleImage(ResourceManager.getPluginImage("org.fao.fi.fishstat.gui", "icons/actions/mapBig.png"));
        } else if (att_acronym.endsWith("NOTES") || att_acronym.endsWith("notes")) {
            this.setTitleImage(ResourceManager.getPluginImage("org.fao.fi.fishstat.gui", "icons/actions/notesBig.png"));
        } else {
            this.setTitleImage(ResourceManager.getPluginImage("org.fao.fi.fishstat.gui", "icons/actions/clipBig.png"));
        }
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Point getInitialSize() {
        return new Point(870, 680);
    }
}

