/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.views.multitable;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.RGB;
import org.fao.fi.fishstat.data.timeseries.api.Attribute;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.export.ExportDataItem;
import org.fao.fi.fishstat.export.ExportDecorators;
import org.fao.fi.fishstat.export.ExportFactory;
import org.fao.fi.fishstat.export.ExportMetadata;
import org.fao.fi.fishstat.export.StructuredDataItem;
import org.fao.fi.fishstat.export.StructuredDataProvider;
import org.fao.fi.fishstat.export.impl.ExportDataItemImpl;
import org.fao.fi.fishstat.export.impl.ExportDecoratorsImpl;
import org.fao.fi.fishstat.export.impl.StructuredDataItemImpl;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.core.session.GuiSession;
import org.fao.fi.fishstat.gui.views.multitable.DimensionTableViewer;
import org.fao.fi.fishstat.gui.views.multitable.MultiTableAbstractViewer;
import org.fao.fi.fishstat.gui.views.multitable.MultiTableView;

public class MultitableViewStructuredDataProvider<T>
implements StructuredDataProvider<T> {
    public static final int KEYS_GROUP = 1;
    public static final int MEAS_GROUP = 2;
    public static final int CALC_GROUP = 3;
    private MultiTableView multiTableView;
    private GuiSession session;
    private final Class<T> type;

    public MultitableViewStructuredDataProvider(Class<T> type, MultiTableView multiTableView) {
        this.type = type;
        this.multiTableView = multiTableView;
        this.session = this.multiTableView.getSession();
    }

    public int itemCount() {
        return this.multiTableView.getKeyTableViewer().getTable().getItemCount();
    }

    public int keysColumnsCount() {
        return this.multiTableView.getKeyTableViewer().getTable().getColumnCount() - 1;
    }

    public int columnCount() {
        return this.keysColumnsCount() + this.measColumnsCount() + this.calcColumnsCount();
    }

    public int measColumnsCount() {
        return this.multiTableView.getObsTableViewer().getTable().getColumnCount() - 1;
    }

    public int calcColumnsCount() {
        return this.multiTableView.hasClcTableViewer() ? this.multiTableView.getClcTableViewer().getTable().getColumnCount() - 1 : 0;
    }

    public ExportMetadata getMetadata() {
        HashMap<String, String> envatts = new HashMap<String, String>();
        for (Attribute attribute : this.session.getTimeseries().getAttributes().keySet()) {
            String key = attribute.getName().getValue(Activator.getLanguage());
            String value = (String)this.session.getTimeseries().getAttributes().get(attribute);
            envatts.put(key, value);
        }
        ExportMetadata metadata = ExportFactory.createReportMetadata((String)this.session.getTimeseries().getName().getValue("en"), (String)this.session.getTimeseries().getDescription().getValue("en"), (String)this.session.getTimeseries().getTimeResolution().toString(), (String)this.session.getTimeseries().getFirstObservationPeriod().getISO8601(), (String)this.session.getTimeseries().getLastObservationPeriod().getISO8601(), (String)String.valueOf(new Date()), (String)"FISHSTATJ", (String)"FAO", envatts);
        return metadata;
    }

    public ExportDataItem<T> getItem(int idx) {
        LinkedList keys_attributes = new LinkedList();
        LinkedList meas_attributes = new LinkedList();
        LinkedList calc_attributes = new LinkedList();
        ArrayList<String> measure_labels = new ArrayList<String>();
        ArrayList<String> measure_attribute_labels = new ArrayList<String>();
        List periods = this.session.getTimeseriesProperties().getPeriods();
        for (ObservationPeriod period : periods) {
            measure_labels.add(period.getISO8601());
            measure_attribute_labels.add("");
        }
        LinkedList<String> key_values = new LinkedList<String>();
        int c = 1;
        while (c <= this.keysColumnsCount()) {
            key_values.add(this.multiTableView.getKeyTableViewer().getTable().getItem(idx).getText(c));
            ++c;
        }
        StructuredDataItemImpl keyData = new StructuredDataItemImpl(key_values, keys_attributes);
        if (this.type.equals(Double.class)) {
            ObservationSeries series = (ObservationSeries)this.multiTableView.getObsTableViewer().getElementAt(idx);
            LinkedList<Double> meas_values = new LinkedList<Double>();
            int m = 1;
            while (m <= this.measColumnsCount()) {
                if (series != null && series.getMeasure(m - 1) != null) {
                    meas_values.add(series.getMeasure(m - 1).getValue());
                } else {
                    meas_values.add(0.0);
                }
                ++m;
            }
            StructuredDataItemImpl valData = new StructuredDataItemImpl(meas_values, meas_attributes);
            LinkedList<Double> calc_values = new LinkedList<Double>();
            int c2 = 1;
            while (c2 <= this.calcColumnsCount()) {
                if (series != null && series.getCalculatedMeasure(c2 - 1) != null) {
                    calc_values.add(series.getCalculatedMeasure(c2 - 1).getValue());
                } else {
                    calc_values.add(0.0);
                }
                ++c2;
            }
            StructuredDataItemImpl clcData = new StructuredDataItemImpl(calc_values, calc_attributes);
            return new ExportDataItemImpl((StructuredDataItem)keyData, (StructuredDataItem)valData, (StructuredDataItem)clcData);
        }
        LinkedList<String> measure_values = new LinkedList<String>();
        int c3 = 1;
        while (c3 <= this.measColumnsCount()) {
            measure_values.add(this.multiTableView.getObsTableViewer().getTable().getItem(idx).getText(c3));
            ++c3;
        }
        StructuredDataItemImpl valData = new StructuredDataItemImpl(measure_values, meas_attributes);
        LinkedList<String> calc_values = new LinkedList<String>();
        int c4 = 1;
        while (c4 <= this.calcColumnsCount()) {
            calc_values.add(this.multiTableView.getClcTableViewer().getTable().getItem(idx).getText(c4));
            ++c4;
        }
        StructuredDataItemImpl clcData = new StructuredDataItemImpl(calc_values, calc_attributes);
        return new ExportDataItemImpl((StructuredDataItem)keyData, (StructuredDataItem)valData, (StructuredDataItem)clcData);
    }

    public ExportDecorators getDecorators(int idx) {
        ExportDecoratorsImpl res = new ExportDecoratorsImpl(this.keysColumnsCount(), this.measColumnsCount(), this.calcColumnsCount());
        int k = 1;
        while (k <= this.keysColumnsCount()) {
            res.setDecorationValues(1, k - 1, StringConverter.asString((RGB)this.multiTableView.getKeyTableViewer().getTable().getItem(idx).getBackground(k).getRGB()), StringConverter.asString((RGB)this.multiTableView.getKeyTableViewer().getTable().getItem(idx).getForeground(k).getRGB()));
            ++k;
        }
        int m = 1;
        while (m <= this.measColumnsCount()) {
            res.setDecorationValues(2, m - 1, StringConverter.asString((RGB)this.multiTableView.getObsTableViewer().getTable().getItem(idx).getBackground(m).getRGB()), StringConverter.asString((RGB)this.multiTableView.getObsTableViewer().getTable().getItem(idx).getForeground(m).getRGB()));
            ++m;
        }
        int c = 1;
        while (c <= this.calcColumnsCount()) {
            res.setDecorationValues(3, c - 1, StringConverter.asString((RGB)this.multiTableView.getClcTableViewer().getTable().getItem(idx).getBackground(c).getRGB()), StringConverter.asString((RGB)this.multiTableView.getClcTableViewer().getTable().getItem(idx).getForeground(c).getRGB()));
            ++c;
        }
        return res;
    }

    public List<String> getLabels(int group) {
        DimensionTableViewer viewer;
        LinkedList<String> res = new LinkedList<String>();
        MultiTableAbstractViewer multiTableAbstractViewer = group == 1 ? this.multiTableView.getKeyTableViewer() : (viewer = group == 2 ? this.multiTableView.getObsTableViewer() : this.multiTableView.getClcTableViewer());
        if (viewer != null) {
            int c = 1;
            while (c < viewer.getColumnsCount()) {
                res.add(viewer.getTable().getColumn(c).getText());
                ++c;
            }
        }
        return res;
    }

    public List<String> getAttributes(int group) {
        LinkedList<String> res = new LinkedList<String>();
        return res;
    }
}

