/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.views.multitable;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.fao.fi.fishstat.core.CoreCache;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.timeseries.api.Measure;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.gui.core.properties.MultiSortElemProperties;
import org.fao.fi.fishstat.gui.core.properties.MultiSortProperties;
import org.fao.fi.fishstat.gui.core.properties.TimeSeriesProperties;
import org.fao.fi.fishstat.gui.views.multitable.AttributeCache;

public class UnifiedComparator
extends ViewerComparator {
    private MultiSortProperties sortProperties;
    private AttributeCache[] cache = null;

    public UnifiedComparator(TimeSeriesProperties p) {
        this.sortProperties = p.getSorter();
        this.cache = new AttributeCache[this.sortProperties.size()];
        int i = 0;
        while (i < this.cache.length) {
            if (this.sortProperties.getSorter(i).getType() == 'D') {
                this.cache[i] = new AttributeCache(this.sortProperties.getSorter(i));
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int compare(Viewer viewer, Object e1, Object e2) {
        if (!(e1 instanceof ObservationSeries)) return 0;
        if (!(e2 instanceof ObservationSeries)) return 0;
        try {
            int i = 0;
            while (true) {
                if (i >= this.sortProperties.size()) {
                    return 0;
                }
                MultiSortElemProperties sorter = this.sortProperties.getSorter(i);
                if (sorter.getType() == 'D') {
                    ReferenceObject key2;
                    ReferenceObject key1 = ((ObservationSeries)e1).getKey(sorter.getDimensionIdx());
                    if (!key1.equals(key2 = ((ObservationSeries)e2).getKey(sorter.getDimensionIdx()))) {
                        String r2;
                        if (CoreCache.isPredefined((ReferenceObject)key1)) {
                            return 1;
                        }
                        if (CoreCache.isPredefined((ReferenceObject)key2)) {
                            return -1;
                        }
                        String r1 = this.cache[i].getString(key1);
                        if (!r1.equals(r2 = this.cache[i].getString(key2))) {
                            int n;
                            if (sorter.isAscending()) {
                                n = r1.compareTo(r2);
                                return n;
                            }
                            n = r2.compareTo(r1);
                            return n;
                        }
                    }
                } else {
                    Measure m2;
                    Measure m1 = ((ObservationSeries)e1).getMeasure(sorter.getObservationPeriod());
                    if (!m1.equals(m2 = ((ObservationSeries)e2).getMeasure(sorter.getObservationPeriod()))) {
                        int n;
                        if (sorter.isAscending()) {
                            n = 1;
                            return n * m1.compareTo((Object)m2);
                        }
                        n = -1;
                        return n * m1.compareTo((Object)m2);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void sort(Viewer viewer, Object[] elements) {
        if (elements == null || elements.length == 0) {
            return;
        }
        super.sort(viewer, elements);
    }

    public void clearCache() {
        AttributeCache[] attributeCacheArray = this.cache;
        int n = this.cache.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeCache singlecache = attributeCacheArray[n2];
            if (singlecache != null) {
                singlecache.reset();
            }
            ++n2;
        }
    }
}

