/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.workspaces;

import java.util.HashMap;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.wb.swt.SWTResourceManager;
import org.fao.fi.fishstat.autoupdate.gen.AutoUpdateWks;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.model.workspace.WorkspaceModel;
import org.fao.fi.fishstat.core.workspaces.WorkspacesInstaller;
import org.fao.fi.fishstat.core.workspaces.WorkspacesManager;
import org.fao.fi.fishstat.gui.Activator;
import org.fao.fi.fishstat.gui.ApplicationAdvisor;
import org.fao.fi.fishstat.gui.components.composites.WorkspaceMetadataPanel;
import org.fao.fi.fishstat.gui.components.widgets.WorkspacesTableViewer;
import org.fao.fi.fishstat.gui.workspaces.wizard.InstallNewWorkspaceWizard;

public class WorkspacesBrowserDialog
extends TitleAreaDialog {
    private Table workSpacesTable;
    private WorkspaceMetadataPanel workspaceMetadataPanel;
    private TableViewer workSpacesTableViewer;
    private WorkspacesManager workspacesManager;
    private WorkspaceModel ws_to_delete;
    private Button btnOpenWorkspace;
    private Button btnImportWorkspace;
    private Button btnDeleteWorkspace;
    private Button btnDownloadWorkspace;

    public WorkspacesBrowserDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Activator.getLocalString("workspaces.management.dialog.title"));
        this.setMessage(Activator.getLocalString("workspaces.management.dialog.subtitle"));
        this.workspacesManager = CoreCommons.getWorkspacesManager();
        parent.setBackground(SWTResourceManager.getColor(1));
        parent.setBackgroundMode(2);
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setBackgroundMode(2);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        this.workSpacesTableViewer = new WorkspacesTableViewer(this.workspacesManager, ApplicationAdvisor.getAutoUpdate().getAutoupdateWorkspaces(), container, 65536, Activator.getLanguage());
        this.workSpacesTable = this.workSpacesTableViewer.getTable();
        this.workSpacesTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspacesBrowserDialog.this.syncButtons((IStructuredSelection)WorkspacesBrowserDialog.this.workSpacesTableViewer.getSelection());
            }
        });
        this.workSpacesTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.size() == 1) {
                    if (selection.getFirstElement() instanceof WorkspaceModel) {
                        WorkspaceModel metadata = (WorkspaceModel)selection.getFirstElement();
                        System.out.println("doubleClick " + metadata.getAcronym());
                        WorkspacesBrowserDialog.this.openSelectedWorkspace(metadata);
                    }
                    if (selection.getFirstElement() instanceof AutoUpdateWks) {
                        WorkspacesBrowserDialog.this.downloadWorkspace(selection);
                    }
                }
            }
        });
        this.workSpacesTable.setForeground(SWTResourceManager.getColor(25, 25, 112));
        this.workSpacesTable.setHeaderVisible(true);
        this.workSpacesTable.setBackground(SWTResourceManager.getColor(248, 251, 255));
        GridData gd_table = new GridData(16384, 4, true, false, 1, 1);
        gd_table.heightHint = 154;
        this.workSpacesTable.setLayoutData((Object)gd_table);
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new RowLayout(512));
        GridData gd_composite = new GridData(131072, 4, false, false, 1, 1);
        gd_composite.widthHint = 105;
        composite.setLayoutData((Object)gd_composite);
        this.btnOpenWorkspace = new Button(composite, 0);
        this.btnOpenWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection;
                if (!WorkspacesBrowserDialog.this.workSpacesTableViewer.getSelection().isEmpty() && (selection = (IStructuredSelection)WorkspacesBrowserDialog.this.workSpacesTableViewer.getSelection()).size() == 1) {
                    WorkspacesBrowserDialog.this.openSelectedWorkspace((WorkspaceModel)selection.getFirstElement());
                }
            }
        });
        this.btnOpenWorkspace.setText("Open...");
        this.btnOpenWorkspace.setLayoutData((Object)new RowData(90, -1));
        this.btnDeleteWorkspace = new Button(composite, 0);
        this.btnDeleteWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection;
                if (!WorkspacesBrowserDialog.this.workSpacesTableViewer.getSelection().isEmpty() && (selection = (IStructuredSelection)WorkspacesBrowserDialog.this.workSpacesTableViewer.getSelection()).size() == 1) {
                    WorkspaceModel ws_todelete = (WorkspaceModel)selection.getFirstElement();
                    try {
                        MessageDialog dlgUpdateFWS = new MessageDialog(Display.getCurrent().getActiveShell(), "Workspace Deletion", null, String.valueOf(Activator.getLocalString("workspaces.boundled.remove.confirmrequest.message.text.1")) + ws_todelete.getName(Activator.getLanguage()) + " v" + ws_todelete.getVersion().toString() + Activator.getLocalString("workspaces.boundled.remove.confirmrequest.message.text.2"), 3, new String[]{"Delete", "Cancel"}, 0);
                        if (dlgUpdateFWS.open() == 0) {
                            try {
                                WorkspacesBrowserDialog.this.setWs_to_delete(ws_todelete);
                                BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().getDisplay(), (Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        WorkspacesInstaller installer = new WorkspacesInstaller(CoreCommons.getWorkspacesManager());
                                        try {
                                            installer.removeWorkspace(WorkspacesBrowserDialog.this.getWs_to_delete());
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    }
                                });
                                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)"Workspace Deletion", (String)(String.valueOf(Activator.getLocalString("workspaces.boundled.removed.confirmation.message.text.1")) + ws_todelete.getName(Activator.getLanguage()) + Activator.getLocalString("workspaces.boundled.removed.confirmation.message.text.2")));
                                WorkspacesBrowserDialog.this.syncButtons(null);
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                            }
                        }
                    }
                    catch (Exception e2) {
                        e2.printStackTrace();
                    }
                }
            }
        });
        this.btnDeleteWorkspace.setText("Delete");
        this.btnDeleteWorkspace.setLayoutData((Object)new RowData(90, -1));
        this.btnDownloadWorkspace = new Button(composite, 0);
        this.btnDownloadWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspacesBrowserDialog.this.downloadWorkspace((IStructuredSelection)WorkspacesBrowserDialog.this.workSpacesTableViewer.getSelection());
            }
        });
        this.btnDownloadWorkspace.setText("Download");
        this.btnDownloadWorkspace.setLayoutData((Object)new RowData(90, -1));
        this.btnImportWorkspace = new Button(composite, 0);
        this.btnImportWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkspacesBrowserDialog.this.importWorkspace();
            }
        });
        this.btnImportWorkspace.setText("Import...");
        this.btnImportWorkspace.setLayoutData((Object)new RowData(90, -1));
        this.workspaceMetadataPanel = new WorkspaceMetadataPanel(container, 0, Activator.getLanguage());
        GridData gd_workspaceMetadataPanel = new GridData(4, 4, false, false, 2, 1);
        gd_workspaceMetadataPanel.heightHint = 173;
        this.workspaceMetadataPanel.setLayoutData((Object)gd_workspaceMetadataPanel);
        if (this.workspacesManager.getNumberOfWorkspaces() >= 1 || !ApplicationAdvisor.getAutoUpdate().getAutoupdateWorkspaces().isEmpty()) {
            int defaultselection = this.getDefaultSelection();
            this.workSpacesTable.select(defaultselection);
            this.workspaceMetadataPanel.setMetadata(this.workSpacesTableViewer.getElementAt(defaultselection));
            this.workspaceMetadataPanel.setVisible(true);
            this.syncButtons((IStructuredSelection)this.workSpacesTableViewer.getSelection());
        } else {
            this.workspaceMetadataPanel.setVisible(false);
            this.syncButtons(null);
        }
        this.workSpacesTable.forceFocus();
        return area;
    }

    private int getDefaultSelection() {
        int i = 0;
        while (i < 10) {
            Object element = this.workSpacesTableViewer.getElementAt(i);
            if (element == null) {
                return 0;
            }
            if (element instanceof WorkspaceModel && ((WorkspaceModel)element).getAcronym().startsWith("FAO_FI_GLOBAL")) {
                return i;
            }
            if (element instanceof AutoUpdateWks && ((AutoUpdateWks)element).getAcronym().startsWith("FAO_FI_GLOBAL")) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    protected void configureShell(Shell newShell) {
        newShell.setBackground(SWTResourceManager.getColor(1));
        newShell.setBackgroundMode(2);
        super.configureShell(newShell);
        newShell.setText(Activator.getLocalString("workspaces.management.dialog.bartitle"));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, JFaceResources.getString((String)IDialogConstants.CLOSE_LABEL), true);
    }

    protected Point getInitialSize() {
        return new Point(500, 500);
    }

    public void openSelectedWorkspace(WorkspaceModel metadata) {
        this.setReturnCode(0);
        this.close();
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("org.fao.fi.fishstat.gui.dataset.switch.workspace.parameter.id", metadata.getLocationDir().getAbsolutePath());
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            Command cmd = commandService.getCommand("org.fao.fi.fishstat.gui.dynamic.switch.workspace");
            ParameterizedCommand parameterizedCommand = ParameterizedCommand.generateCommand((Command)cmd, parameters);
            handlerService.executeCommand(parameterizedCommand, null);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void importWorkspace() {
        this.setReturnCode(0);
        this.close();
        ICommandService cmdService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        try {
            cmdService.getCommand("org.fao.fi.fishstat.gui.tools.import.workspace").getHandler().execute(new ExecutionEvent());
        }
        catch (ExecutionException e1) {
            e1.printStackTrace();
        }
    }

    public void downloadWorkspace(IStructuredSelection selection) {
        if (selection.size() == 1 && selection.getFirstElement() instanceof AutoUpdateWks) {
            this.setReturnCode(0);
            this.close();
            InstallNewWorkspaceWizard wizard = new InstallNewWorkspaceWizard((AutoUpdateWks)selection.getFirstElement());
            WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
            dialog.open();
        }
    }

    public WorkspaceModel getWs_to_delete() {
        return this.ws_to_delete;
    }

    public void setWs_to_delete(WorkspaceModel ws_to_delete) {
        this.ws_to_delete = ws_to_delete;
    }

    public void syncButtons(IStructuredSelection selection) {
        if (selection == null) {
            this.btnOpenWorkspace.setEnabled(false);
            this.btnDeleteWorkspace.setEnabled(false);
            this.btnImportWorkspace.setEnabled(true);
            this.btnDownloadWorkspace.setEnabled(false);
            this.workspaceMetadataPanel.setMetadata(null);
            this.workspaceMetadataPanel.setVisible(false);
            return;
        }
        if (selection.size() == 1) {
            if (selection.getFirstElement() instanceof WorkspaceModel) {
                this.btnDownloadWorkspace.setEnabled(false);
                this.btnOpenWorkspace.setEnabled(true);
                this.btnImportWorkspace.setEnabled(true);
                this.btnDeleteWorkspace.setEnabled(true);
            }
            if (selection.getFirstElement() instanceof AutoUpdateWks) {
                this.btnOpenWorkspace.setEnabled(false);
                this.btnDeleteWorkspace.setEnabled(false);
                this.btnImportWorkspace.setEnabled(true);
                this.btnDownloadWorkspace.setEnabled(true);
            }
            this.workspaceMetadataPanel.setMetadata(selection.getFirstElement());
            this.workspaceMetadataPanel.setVisible(true);
        } else {
            this.workspaceMetadataPanel.setVisible(false);
        }
    }
}

