/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.gui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.fao.fi.fishstat.gui.components.ComponentsActivator;
import org.fao.fi.fishstat.gui.components.ComponentsCommons;

public class SplashProgress
implements IProgressMonitor {
    private final Image image = ComponentsActivator.getImage("icons/hourglass.png");
    private Shell splash;
    private ProgressBar bar;
    private String message;
    private int totalWork;
    private int counter = 0;
    private boolean cancelled;
    private boolean indeterminate;
    private boolean autoOff;
    private Display display;
    private String name;
    private Label lblSubMessage;

    public SplashProgress(Display display, String title, String message, int maximum, boolean autoOff) {
        this.display = display;
        this.name = title;
        this.message = message;
        this.totalWork = maximum;
        this.indeterminate = false;
        this.autoOff = autoOff;
        this.createSplash();
    }

    public SplashProgress(Display display, String title, String message, boolean indeterminate) {
        this.display = display;
        this.name = title;
        this.message = message;
        this.indeterminate = indeterminate;
        this.autoOff = false;
        this.createSplash();
    }

    private void createSplash() {
        this.splash = new Shell(this.display, 81920);
        this.bar = new ProgressBar((Composite)this.splash, this.indeterminate ? 65538 : 65536);
        this.bar.setMaximum(this.totalWork);
        Monitor primary = this.display.getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        int x = bounds.x + (bounds.width - 600) / 2;
        int y = bounds.y + (bounds.height - 180) / 2;
        this.splash.setText(this.name);
        this.splash.setBounds(x, y, 600, 170);
        this.splash.setLayout((Layout)new FormLayout());
        Label lblTitle = new Label((Composite)this.splash, 0x1000000);
        lblTitle.setFont(ComponentsCommons.getFont("Tahoma", 8, 1));
        lblTitle.setForeground(ComponentsCommons.getColor(31));
        lblTitle.setBackground(ComponentsCommons.getColor(33));
        lblTitle.setText(this.name);
        FormData formData_4 = new FormData();
        formData_4.left = new FormAttachment(0, 10);
        formData_4.width = 580;
        formData_4.height = 18;
        formData_4.top = new FormAttachment(0, 15);
        lblTitle.setLayoutData((Object)formData_4);
        Canvas canvas = new Canvas((Composite)this.splash, 0);
        FormData formData_2 = new FormData();
        formData_2.left = new FormAttachment(0, 10);
        formData_2.right = new FormAttachment(100, -484);
        formData_2.top = new FormAttachment(0, 25);
        canvas.setLayoutData((Object)formData_2);
        canvas.setForeground(ComponentsCommons.getColor(1));
        canvas.setBackground(ComponentsCommons.getColor(1));
        canvas.setBackgroundImage(this.image);
        canvas.setLayout((Layout)new GridLayout(1, false));
        Label lblMessage = new Label((Composite)this.splash, 0);
        lblMessage.setForeground(ComponentsCommons.getColor(10));
        lblMessage.setFont(ComponentsCommons.getFont("Tahoma", 8, 1));
        FormData formData = new FormData();
        formData.bottom = new FormAttachment((Control)this.bar, -52);
        formData.top = new FormAttachment((Control)lblTitle, 17);
        formData.right = new FormAttachment(100, -28);
        formData.left = new FormAttachment((Control)canvas, 6);
        lblMessage.setLayoutData((Object)formData);
        lblMessage.setText(this.message);
        this.lblSubMessage = new Label((Composite)this.splash, 0);
        this.lblSubMessage.setFont(ComponentsCommons.getFont("Tahoma", 8, 0));
        this.lblSubMessage.setForeground(ComponentsCommons.getColor(10));
        FormData formDataSubMessage = new FormData();
        formDataSubMessage.top = new FormAttachment((Control)lblMessage, 10);
        formDataSubMessage.right = new FormAttachment(100, -28);
        formDataSubMessage.left = new FormAttachment((Control)canvas, 10);
        this.lblSubMessage.setLayoutData((Object)formDataSubMessage);
        FormData formData_1 = new FormData();
        formData_1.right = new FormAttachment((Control)lblMessage, 0, 131072);
        formData_1.left = new FormAttachment(0, 10);
        formData_1.bottom = new FormAttachment((Control)canvas, 39, 1024);
        formData_1.top = new FormAttachment((Control)canvas, 15);
        this.bar.setLayoutData((Object)formData_1);
        formData_2.bottom = new FormAttachment((Control)this.bar, -6);
        FormData formData_3 = new FormData();
        formData_3.left = new FormAttachment(0, 10);
        formData_3.right = new FormAttachment(100, -10);
        formData_3.bottom = new FormAttachment(100, -10);
        this.bar.setLayoutData((Object)formData_3);
    }

    public void beginTask(String name, int totalWork) {
        this.name = name;
        this.totalWork = totalWork;
        this.setMaxValue(totalWork);
        this.start();
    }

    public void internalWorked(double work) {
        this.bar.setState((int)work);
    }

    public boolean isCanceled() {
        return this.cancelled;
    }

    public void setCanceled(boolean value) {
        this.cancelled = value;
    }

    public void setTaskName(String name) {
        this.name = name;
    }

    public void subTask(final String name) {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                SplashProgress.this.lblSubMessage.setText(name);
                SplashProgress.this.lblSubMessage.redraw();
            }
        });
    }

    public void worked(final int work) {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                SplashProgress splashProgress = SplashProgress.this;
                splashProgress.counter = splashProgress.counter + work;
                SplashProgress.this.setStatus(SplashProgress.this.counter);
                SplashProgress.this.bar.redraw();
                SplashProgress.this.bar.forceFocus();
            }
        });
    }

    public ProgressBar getBar() {
        return this.bar;
    }

    public void start() {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (SplashProgress.this.splash != null && !SplashProgress.this.splash.isDisposed()) {
                    SplashProgress.this.splash.open();
                }
            }
        });
    }

    public void done() {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (SplashProgress.this.splash != null && !SplashProgress.this.splash.isDisposed()) {
                    SplashProgress.this.splash.dispose();
                }
            }
        });
    }

    public boolean isRunning() {
        return this.counter > 0 && this.counter <= this.totalWork;
    }

    public void setMaxValue(final int maximum) {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (SplashProgress.this.bar != null && !SplashProgress.this.bar.isDisposed()) {
                    SplashProgress.this.bar.setMaximum(maximum);
                }
            }
        });
    }

    public void setStatus(int status) {
        this.counter = status;
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (SplashProgress.this.splash != null && !SplashProgress.this.splash.isDisposed()) {
                    if (SplashProgress.this.bar != null && !SplashProgress.this.bar.isDisposed()) {
                        SplashProgress.this.bar.setSelection(SplashProgress.this.counter);
                    }
                    if (SplashProgress.this.autoOff && SplashProgress.this.counter >= SplashProgress.this.bar.getMaximum()) {
                        SplashProgress.this.done();
                    }
                }
            }
        });
    }

    public void increaseCounter() {
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                SplashProgress splashProgress = SplashProgress.this;
                splashProgress.counter = splashProgress.counter + 1;
                SplashProgress.this.setStatus(SplashProgress.this.counter);
            }
        });
    }

    public void increaseMaximum(final int amount) {
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                SplashProgress.this.bar.setMaximum(SplashProgress.this.bar.getMaximum() + amount);
            }
        });
    }

    public int getMaximum() {
        return this.totalWork;
    }
}

