/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.widgets;

import java.util.Arrays;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class WidgetsUtils {
    public static void invertSelection(Control control) {
        if (control instanceof Table || control instanceof List) {
            int item_count = control instanceof Table ? ((Table)control).getItemCount() : ((List)control).getItemCount();
            int[] cur_selection = control instanceof Table ? ((Table)control).getSelectionIndices() : ((List)control).getSelectionIndices();
            int[] new_selection = new int[item_count - cur_selection.length];
            int counter = 0;
            int i = 0;
            while (i < item_count) {
                if (Arrays.binarySearch(cur_selection, i) < 0) {
                    new_selection[counter] = i;
                    ++counter;
                }
                ++i;
            }
            if (control instanceof Table) {
                ((Table)control).setSelection(new_selection);
            } else {
                ((List)control).setSelection(new_selection);
            }
        }
    }

    public static int getTableRowCell(Table table, MouseEvent event) {
        Rectangle clientArea = table.getClientArea();
        Point pt = new Point(event.x, event.y);
        int index = table.getTopIndex();
        while (index < table.getItemCount()) {
            boolean visible = false;
            TableItem item = table.getItem(index);
            int i = 0;
            while (i < table.getColumnCount()) {
                Rectangle rect = item.getBounds(i);
                if (rect.contains(pt)) {
                    return index;
                }
                if (!visible && rect.intersects(clientArea)) {
                    visible = true;
                }
                ++i;
            }
            if (!visible) {
                return -1;
            }
            ++index;
        }
        return -1;
    }

    public static int getListRowCell(List list, MouseEvent event) {
        String os = Platform.getOS();
        int itemIdx = -1;
        if (os.equals("win32")) {
            itemIdx = list.getTopIndex() + event.y / list.getItemHeight();
        } else if (os.equals("macosx")) {
            itemIdx = event.y / (list.getItemHeight() + list.getBorderWidth() + 1);
        } else if (os.equals("linux")) {
            itemIdx = list.getTopIndex() + event.y / (list.getItemHeight() + list.getBorderWidth() + 1) + 1;
        }
        return itemIdx < list.getItemCount() ? itemIdx : -1;
    }
}

