/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.widgets.combos;

import java.util.LinkedList;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.CustomGroupFactory;
import org.fao.fi.fishstat.data.reference.api.Relationship;

public class ConceptParentsComboViewer
extends ComboViewer {
    private String lang;
    private boolean itselfIncluded = false;
    private boolean customGroupsIncluded = false;

    public ConceptParentsComboViewer(Composite composite, int style, String lang, boolean itself) {
        super(composite, 0x10000000 | style);
        this.lang = lang;
        this.itselfIncluded = itself;
        this.setContentProvider((IContentProvider)new ConceptParentsContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new ConceptParentsLabelProvider());
        this.setComparator(new ConceptParentsSorter());
    }

    public boolean isItselfIncluded() {
        return this.itselfIncluded;
    }

    public boolean isCustomGroupsIncluded() {
        return this.customGroupsIncluded;
    }

    public void setCustomGroupsIncluded(boolean customGroupsIncluded) {
        this.customGroupsIncluded = customGroupsIncluded;
    }

    public Relationship getSelectedRelation() {
        StructuredSelection sel = (StructuredSelection)this.getSelection();
        return (Relationship)sel.getFirstElement();
    }

    private class ConceptParentsContentProvider
    implements IStructuredContentProvider {
        private ConceptParentsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return new Object[0];
            }
            if (inputElement instanceof Concept) {
                Concept concept = (Concept)inputElement;
                try {
                    LinkedList rels = new LinkedList(concept.getParentConcepts());
                    if (!ConceptParentsComboViewer.this.customGroupsIncluded) {
                        rels.remove(CustomGroupFactory.getConcept());
                    }
                    int ressize = rels.size() + (ConceptParentsComboViewer.this.itselfIncluded ? 1 : 0);
                    Object[] res = new Object[ressize];
                    int i = 0;
                    while (i < rels.size()) {
                        res[i] = rels.get(i);
                        ++i;
                    }
                    if (ConceptParentsComboViewer.this.itselfIncluded) {
                        res[i] = concept;
                    }
                    return res;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ConceptParentsLabelProvider
    extends LabelProvider
    implements ILabelProvider {
        private ConceptParentsLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof Concept) {
                return CoreUtils.getCurrentLangName((Object)element, (String)ConceptParentsComboViewer.this.lang);
            }
            return "#ERROR#";
        }
    }

    private class ConceptParentsSorter
    extends ViewerComparator {
        private ConceptParentsSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof Concept && e2 instanceof Concept) {
                if (((Concept)e1).getAcronym().equals("CUSTOM_GROUP")) {
                    return 1;
                }
                if (((Concept)e2).getAcronym().equals("CUSTOM_GROUP")) {
                    return -1;
                }
                if (((Concept)e1).getSortorder() == null || ((Concept)e2).getSortorder() == null) {
                    return CoreUtils.getCurrentLangName((Object)((Concept)e1), (String)ConceptParentsComboViewer.this.lang).compareTo(CoreUtils.getCurrentLangName((Object)((Concept)e2), (String)ConceptParentsComboViewer.this.lang));
                }
                return ((Concept)e1).getSortorder().compareTo(((Concept)e2).getSortorder());
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

