/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.components.widgets.combos;

import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.fao.fi.fishstat.core.CoreUtils;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.TimeseriesServiceFactory;

public class DatasetsComboViewer
extends ComboViewer {
    private String lang;

    public DatasetsComboViewer(Composite composite, int style, String lang) {
        super(composite, 0x10000000 | style);
        this.lang = lang;
        this.setContentProvider((IContentProvider)new DatasetsContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new DatasetsLabelProvider());
        this.setComparator(new DatasetsSorter());
    }

    public Dataset getSelectedDataset() {
        StructuredSelection sel = (StructuredSelection)this.getSelection();
        return (Dataset)sel.getFirstElement();
    }

    private class DatasetsContentProvider
    implements IStructuredContentProvider {
        private DatasetsContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return new Object[0];
            }
            return TimeseriesServiceFactory.getService().getDatasets().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class DatasetsLabelProvider
    extends LabelProvider
    implements ILabelProvider {
        private DatasetsLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof Dataset) {
                return CoreUtils.getCurrentLangName((Object)element, (String)DatasetsComboViewer.this.lang);
            }
            return "#ERROR#";
        }
    }

    private class DatasetsSorter
    extends ViewerComparator {
        private DatasetsSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return CoreUtils.getCurrentLangName((Object)((Dataset)e1), (String)DatasetsComboViewer.this.lang).compareTo(CoreUtils.getCurrentLangName((Object)((Dataset)e2), (String)DatasetsComboViewer.this.lang));
        }
    }
}

