/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.reference.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;

public class MultiReferenceObject {
    private final ReferenceObject[] keys;
    private Map<Concept, ReferenceObject> map;
    private List<ReferenceObject> list;
    private final int hashCode;

    public MultiReferenceObject(MultiReferenceObject keys) {
        this(keys.elements());
    }

    public MultiReferenceObject(Collection<ReferenceObject> keys) {
        this(keys.toArray(new ReferenceObject[keys.size()]));
    }

    public MultiReferenceObject(ReferenceObject ... params) {
        if (params == null) {
            throw new IllegalArgumentException("The array of ReferenceObject can not be null");
        }
        int total = 0;
        this.keys = new ReferenceObject[params.length];
        int i = 0;
        while (i < params.length) {
            if (params[i] == null) {
                throw new IllegalArgumentException("The ReferenceObject can not be null");
            }
            this.keys[i] = params[i];
            total ^= this.keys[i].hashCode();
            ++i;
        }
        this.hashCode = total;
    }

    public ReferenceObject[] elements() {
        return this.keys;
    }

    public ReferenceObject elementAt(int index) {
        return this.keys[index];
    }

    public int size() {
        return this.keys.length;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof MultiReferenceObject) {
            MultiReferenceObject otherMulti = (MultiReferenceObject)other;
            return Arrays.equals(this.keys, otherMulti.keys);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return Arrays.asList(this.keys).toString();
    }

    public List<ReferenceObject> asList() {
        if (this.list == null) {
            this.list = Arrays.asList(this.keys);
        }
        return this.list;
    }

    public Map<Concept, ReferenceObject> asMap() {
        if (this.map == null) {
            this.map = new LinkedHashMap<Concept, ReferenceObject>(this.keys.length);
            int i = 0;
            while (i < this.keys.length) {
                this.map.put(this.keys[i].getConcept(), this.keys[i]);
                ++i;
            }
        }
        return this.map;
    }

    public int indexOf(ReferenceObject key) {
        return this.asList().indexOf(key);
    }

    public ListIterator<ReferenceObject> listIterator() {
        return this.asList().listIterator();
    }

    public ListIterator<ReferenceObject> listIterator(int i) {
        return this.asList().listIterator(i);
    }
}

