/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.reference.api.impl;

import java.lang.reflect.Constructor;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.fao.fi.fishstat.data.common.Commons;
import org.fao.fi.fishstat.data.common.api.Identifier;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.common.api.Version;
import org.fao.fi.fishstat.data.common.api.daosupport.GenericDAO;
import org.fao.fi.fishstat.data.common.api.impl.IdentifierHelper;
import org.fao.fi.fishstat.data.common.api.impl.VersionHelper;
import org.fao.fi.fishstat.data.common.register.StructuralChangeEvent;
import org.fao.fi.fishstat.data.common.register.StructuralChangeEventListener;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.fao.fi.fishstat.data.reference.api.exceptions.ReferenceServiceException;
import org.fao.fi.fishstat.data.reference.api.impl.ReferenceServiceHelper;

public class RelationshipImpl
implements Relationship,
StructuralChangeEventListener {
    public static final String RELATIONSHIP_WHERE_CLAUSE = "PARENT_ID = ? AND CHILD_ID = ?";
    private Object relationshipDto;
    private Concept parent_concept;
    private Concept child_concept;
    private Identifier identifier;
    private GenericDAO relationshipDao;

    public RelationshipImpl(Object relationship_dto) throws ReferenceServiceException {
        try {
            if (relationship_dto == null) {
                throw new IllegalArgumentException("Expecting not null relationship DTO");
            }
            this.relationshipDto = relationship_dto;
            this.identifier = IdentifierHelper.instance((String)Commons.getDTOIdentifier((Object)this.relationshipDto));
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to instantiate the relationship: " + e.getMessage(), e);
        }
    }

    private GenericDAO getRelationshipDAO() {
        try {
            if (this.relationshipDao == null) {
                this.relationshipDao = ReferenceServiceHelper.getRelationshipDAO((String)Commons.getDTOAttributeByAcronym((Object)this.relationshipDto, (String)"ACRONYM"));
            }
            return this.relationshipDao;
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to get relationship DAO: " + e.getMessage(), e);
        }
    }

    @Override
    public String getAcronym() throws ReferenceServiceException {
        try {
            return (String)Commons.getDTOAttributeByAcronym((Object)this.relationshipDto, (String)"ACRONYM");
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to get the description", e);
        }
    }

    @Override
    public Concept getChildConcept() throws ReferenceServiceException {
        try {
            if (this.child_concept == null) {
                this.child_concept = ReferenceServiceFactory.getService().getConcept(IdentifierHelper.instance((String)((String)Commons.getDTOAttributeByAcronym((Object)this.relationshipDto, (String)"CHILD_ID"))));
            }
            return this.child_concept;
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to get the child concept", e);
        }
    }

    @Override
    public Identifier getId() {
        return this.identifier;
    }

    @Override
    public Concept getParentConcept() throws ReferenceServiceException {
        try {
            if (this.parent_concept == null) {
                this.parent_concept = ReferenceServiceFactory.getService().getConcept(IdentifierHelper.instance((String)((String)Commons.getDTOAttributeByAcronym((Object)this.relationshipDto, (String)"PARENT_ID"))));
            }
            return this.parent_concept;
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to get the parent concept", e);
        }
    }

    private void update() throws ReferenceServiceException {
        try {
            ReferenceServiceHelper.getRmdRelationshipDao().update(Commons.getDTOPk((Object)this.relationshipDto), this.relationshipDto);
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to update relationship: " + e.getMessage(), e);
        }
    }

    @Override
    public MultilingualString getDescription() {
        try {
            return Commons.getMultilingualDTOAttribute((Object)this.relationshipDto, (String)"DESCRIPTION");
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to get the description", e);
        }
    }

    @Override
    public MultilingualString getName() {
        try {
            return Commons.getMultilingualDTOAttribute((Object)this.relationshipDto, (String)"NAME");
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to get the name", e);
        }
    }

    @Override
    public void setDescription(MultilingualString description) throws ReferenceServiceException {
        try {
            Commons.setMultilingualDTOAttribute((Object)this.relationshipDto, (String)"DESCRIPTION", (MultilingualString)description);
            this.update();
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to set the description", e);
        }
    }

    @Override
    public void setName(MultilingualString name) throws ReferenceServiceException {
        try {
            Commons.setMultilingualDTOAttribute((Object)this.relationshipDto, (String)"NAME", (MultilingualString)name);
            this.update();
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to set the name", e);
        }
    }

    @Override
    public Set<ReferenceObject> getChildren(ReferenceObject parent) throws ReferenceServiceException {
        if (parent == null) {
            throw new IllegalArgumentException("Parent object can not be null");
        }
        if (!this.getParentConcept().equals(parent.getConcept())) {
            throw new IllegalArgumentException("Expected object of type: " + this.getParentConcept().getAcronym() + ", got: " + parent.getConcept());
        }
        try {
            List relationship_dtos = this.getRelationshipDAO().findByAttribute("PARENT_ID", String.class, (Object)parent.getId().toString());
            LinkedHashSet<ReferenceObject> children = new LinkedHashSet<ReferenceObject>();
            if (relationship_dtos != null && relationship_dtos.size() > 0) {
                for (Object dto : relationship_dtos) {
                    ReferenceObject child = this.getChildConcept().getObject(IdentifierHelper.instance((String)((String)Commons.getDTOAttributeByAcronym(dto, (String)"CHILD_ID"))));
                    if (child == null) continue;
                    children.add(child);
                }
            }
            return children;
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to retrieve children objects: " + e.getMessage(), e);
        }
    }

    @Override
    public Set<ReferenceObject> getParents(ReferenceObject child) throws ReferenceServiceException {
        if (child == null) {
            throw new IllegalArgumentException("Child object can not be null");
        }
        if (!this.getChildConcept().equals(child.getConcept())) {
            throw new IllegalArgumentException("Expected object of type: " + this.getChildConcept().getAcronym() + ", got: " + child.getConcept());
        }
        try {
            List relationship_dtos = this.getRelationshipDAO().findByAttribute("CHILD_ID", String.class, (Object)child.getId().toString());
            LinkedHashSet<ReferenceObject> parents = new LinkedHashSet<ReferenceObject>();
            if (relationship_dtos != null && relationship_dtos.size() > 0) {
                for (Object dto : relationship_dtos) {
                    ReferenceObject parent = this.getParentConcept().getObject(IdentifierHelper.instance((String)((String)Commons.getDTOAttributeByAcronym(dto, (String)"PARENT_ID"))));
                    if (parent == null) continue;
                    parents.add(parent);
                }
            }
            return parents;
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to retrieve parent objects: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getAcronym()).append("[").append(this.getVersion()).append("]");
        return builder.toString();
    }

    @Override
    public void add(ReferenceObject parent, ReferenceObject child) throws ReferenceServiceException {
        this.add(parent, child, true);
    }

    private void add(ReferenceObject parent, ReferenceObject child, boolean check) throws ReferenceServiceException {
        if (!this.allows(parent, child)) {
            throw new IllegalArgumentException("The relationship instance is not allowed");
        }
        if (!check || !this.contains(parent, child)) {
            try {
                Class<?> c = ReferenceServiceHelper.getRelationshipDTOClass(this.getAcronym());
                Constructor<?> constructor = c.getConstructor(new Class[0]);
                Object dto = constructor.newInstance(new Object[0]);
                Commons.setDTOAttribute(dto, (String)"PARENT_ID", (Object)parent.getId().stringValue(), String.class);
                Commons.setDTOAttribute(dto, (String)"CHILD_ID", (Object)child.getId().stringValue(), String.class);
                String new_id = this.getRelationshipDAO().generateId();
                Commons.setDTOIdentifier(dto, (String)new_id);
                this.getRelationshipDAO().insert(dto);
            }
            catch (Exception e) {
                throw new ReferenceServiceException("Unable to add relationship instance", e);
            }
        }
    }

    @Override
    public void remove(ReferenceObject parent, ReferenceObject child) throws ReferenceServiceException {
        if (!this.allows(parent, child)) {
            throw new IllegalArgumentException("The relationship instance is not allowed");
        }
        try {
            Object relationship_dto;
            List relationship_dtos = this.getRelationshipDAO().findByDynamicWhere(RELATIONSHIP_WHERE_CLAUSE, (Object[])new String[]{parent.getId().stringValue(), child.getId().stringValue()});
            if (relationship_dtos != null && relationship_dtos.size() > 0 && (relationship_dto = relationship_dtos.get(0)) != null) {
                this.getRelationshipDAO().delete(Commons.getDTOPk(relationship_dto));
            }
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to remove relationship instance", e);
        }
    }

    @Override
    public void addChildren(ReferenceObject parent, Set<ReferenceObject> children) throws ReferenceServiceException {
        this.addChildren(parent, children, true);
    }

    private void addChildren(ReferenceObject parent, Set<ReferenceObject> children, boolean check) throws ReferenceServiceException {
        if (children != null) {
            try {
                Class<?> c = ReferenceServiceHelper.getRelationshipDTOClass(this.getAcronym());
                Constructor<?> constructor = c.getConstructor(new Class[0]);
                Object dto = constructor.newInstance(new Object[0]);
                Commons.setDTOAttribute(dto, (String)"PARENT_ID", (Object)parent.getId().stringValue(), String.class);
                int new_id = this.getRelationshipDAO().generateIntId();
                for (ReferenceObject child : children) {
                    if (!this.allows(parent, child)) {
                        throw new IllegalArgumentException("The relationship instance is not allowed");
                    }
                    if (check && this.contains(parent, child)) continue;
                    try {
                        Commons.setDTOAttribute(dto, (String)"CHILD_ID", (Object)child.getId().stringValue(), String.class);
                        Commons.setDTOIdentifier(dto, (String)IdentifierHelper.valueOf((int)new_id++));
                        this.getRelationshipDAO().insert(dto);
                    }
                    catch (Exception e) {
                        throw new ReferenceServiceException("Unable to add relationship instance", e);
                    }
                }
            }
            catch (Exception e) {
                throw new ReferenceServiceException("Unable to add relationship instance", e);
            }
        }
    }

    @Override
    public boolean contains(ReferenceObject parent, ReferenceObject child) throws ReferenceServiceException {
        if (!this.allows(parent, child)) {
            throw new IllegalArgumentException("The relationship instance is not allowed");
        }
        try {
            List relationship_dtos = this.getRelationshipDAO().findByDynamicWhere(RELATIONSHIP_WHERE_CLAUSE, (Object[])new String[]{parent.getId().stringValue(), child.getId().stringValue()});
            return relationship_dtos != null && relationship_dtos.size() > 0;
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to remove relationship instance", e);
        }
    }

    @Override
    public void setChildren(ReferenceObject parent, Set<ReferenceObject> children) throws ReferenceServiceException {
        this.removeChildren(parent);
        this.addChildren(parent, children, false);
    }

    @Override
    public void setParents(ReferenceObject child, Set<ReferenceObject> parents) throws ReferenceServiceException {
        this.removeParents(child);
        this.addParents(child, parents, false);
    }

    @Override
    public void addParents(ReferenceObject child, Set<ReferenceObject> parents) throws ReferenceServiceException {
        this.addParents(child, parents, true);
    }

    private void addParents(ReferenceObject child, Set<ReferenceObject> parents, boolean check) throws ReferenceServiceException {
        if (parents != null) {
            try {
                Class<?> c = ReferenceServiceHelper.getRelationshipDTOClass(this.getAcronym());
                Constructor<?> constructor = c.getConstructor(new Class[0]);
                Object dto = constructor.newInstance(new Object[0]);
                Commons.setDTOAttribute(dto, (String)"CHILD_ID", (Object)child.getId().stringValue(), String.class);
                int new_id = this.getRelationshipDAO().generateIntId();
                for (ReferenceObject parent : parents) {
                    if (!this.allows(parent, child)) {
                        throw new IllegalArgumentException("The relationship instance is not allowed");
                    }
                    if (check && this.contains(parent, child)) continue;
                    try {
                        Commons.setDTOAttribute(dto, (String)"PARENT_ID", (Object)parent.getId().stringValue(), String.class);
                        Commons.setDTOIdentifier(dto, (String)IdentifierHelper.valueOf((int)new_id++));
                        this.getRelationshipDAO().insert(dto);
                    }
                    catch (Exception e) {
                        throw new ReferenceServiceException("Unable to add relationship instance", e);
                    }
                }
            }
            catch (Exception e) {
                throw new ReferenceServiceException("Unable to add relationship instance", e);
            }
        }
    }

    @Override
    public void removeChildren(ReferenceObject parent) throws ReferenceServiceException {
        if (parent == null) {
            throw new IllegalArgumentException("Parent object can not be null");
        }
        if (!this.getParentConcept().equals(parent.getConcept())) {
            throw new IllegalArgumentException("Expected object of type: " + this.getParentConcept().getAcronym() + ", got: " + parent.getConcept());
        }
        try {
            List relationship_dtos = this.getRelationshipDAO().findByAttribute("PARENT_ID", String.class, (Object)parent.getId().stringValue());
            if (relationship_dtos != null) {
                for (Object relationship_dto : relationship_dtos) {
                    this.getRelationshipDAO().delete(Commons.getDTOPk(relationship_dto));
                }
            }
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to remove children for: " + parent, e);
        }
    }

    @Override
    public void removeParents(ReferenceObject child) throws ReferenceServiceException {
        if (child == null) {
            throw new IllegalArgumentException("Child object can not be null");
        }
        if (!this.getChildConcept().equals(child.getConcept())) {
            throw new IllegalArgumentException("Expected object of type: " + this.getChildConcept().getAcronym() + ", got: " + child.getConcept());
        }
        try {
            List relationship_dtos = this.getRelationshipDAO().findByAttribute("CHILD_ID", String.class, (Object)child.getId().stringValue());
            if (relationship_dtos != null) {
                for (Object relationship_dto : relationship_dtos) {
                    this.getRelationshipDAO().delete(Commons.getDTOPk(relationship_dto));
                }
            }
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to remove parents for: " + child, e);
        }
    }

    @Override
    public boolean allows(ReferenceObject parent, ReferenceObject child) throws ReferenceServiceException {
        if (parent == null || child == null) {
            return false;
        }
        if (!parent.getConcept().equals(this.getParentConcept())) {
            return false;
        }
        return child.getConcept().equals(this.getChildConcept());
    }

    @Override
    public Set<ReferenceObject> getChildren() throws ReferenceServiceException {
        try {
            List relationship_dtos = this.getRelationshipDAO().findAll();
            LinkedHashSet<ReferenceObject> children = new LinkedHashSet<ReferenceObject>();
            if (relationship_dtos != null && relationship_dtos.size() > 0) {
                for (Object dto : relationship_dtos) {
                    ReferenceObject child = this.getChildConcept().getObject(IdentifierHelper.instance((String)((String)Commons.getDTOAttributeByAcronym(dto, (String)"CHILD_ID"))));
                    children.add(child);
                }
            }
            return children;
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to retrieve children objects: " + e.getMessage(), e);
        }
    }

    @Override
    public Set<ReferenceObject> getParents() throws ReferenceServiceException {
        try {
            List relationship_dtos = this.getRelationshipDAO().findAll();
            LinkedHashSet<ReferenceObject> parents = new LinkedHashSet<ReferenceObject>();
            if (relationship_dtos != null && relationship_dtos.size() > 0) {
                for (Object dto : relationship_dtos) {
                    ReferenceObject parent = this.getParentConcept().getObject(IdentifierHelper.instance((String)((String)Commons.getDTOAttributeByAcronym(dto, (String)"PARENT_ID"))));
                    parents.add(parent);
                }
            }
            return parents;
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to retrieve parent objects: " + e.getMessage(), e);
        }
    }

    public void onStructuralChangeEvent(StructuralChangeEvent change) throws IllegalStateException {
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Relationship)) {
            return false;
        }
        Relationship other = (Relationship)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }

    @Override
    public void removeAll() throws ReferenceServiceException {
        try {
            List relationship_dtos = this.getRelationshipDAO().findAll();
            if (relationship_dtos != null && relationship_dtos.size() > 0) {
                for (Object relationship_dto : relationship_dtos) {
                    this.getRelationshipDAO().delete(Commons.getDTOPk(relationship_dto));
                }
            }
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to remove relationship instances", e);
        }
    }

    public Version getVersion() throws ReferenceServiceException {
        try {
            return VersionHelper.getVersion((Object)this.relationshipDto);
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to get version", e);
        }
    }

    public void setVersion(Version version) throws ReferenceServiceException {
        try {
            VersionHelper.setVersion((Object)this.relationshipDto, (Version)version);
            this.update();
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to set version", e);
        }
    }

    @Override
    public Integer getSortorder() {
        try {
            return (Integer)Commons.getDTOAttributeByAcronym((Object)this.relationshipDto, (String)"SORT_ORDER");
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void setSortorder(Integer sortOrder) throws ReferenceServiceException {
        try {
            Commons.setDTOAttribute((Object)this.relationshipDto, (String)"SORT_ORDER", (Object)sortOrder, Integer.class);
            this.update();
        }
        catch (Exception e) {
            throw new ReferenceServiceException("Unable to set the sort_order", e);
        }
    }
}

