/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.core.model.selection;

import java.util.HashMap;
import org.fao.fi.fishstat.core.ActionDescriptor;
import org.fao.fi.fishstat.core.model.concept.selection.ConceptSelection;
import org.fao.fi.fishstat.core.model.concept.selection.FilterWrapper;
import org.fao.fi.fishstat.core.session.Session;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.Selection;
import org.fao.fi.fishstat.gui.core.properties.DimensionProperties;
import org.fao.fi.fishstat.gui.core.session.GuiSession;

public class GuiFilterWrapper
extends FilterWrapper {
    public GuiFilterWrapper(GuiSession session) {
        super((Session)session);
        this.session = session;
        this.descriptor = new ActionDescriptor((Object)this);
        try {
            this.dimensions = session.getDataset().getDimensions();
            this.keys = new ConceptSelection[this.dimensions.size()];
            this.keyRegistry = new HashMap(this.dimensions.size());
            int i = 0;
            while (i < this.dimensions.size()) {
                Dimension dimension = (Dimension)this.dimensions.get(i);
                DimensionProperties p = session.getDatasetProperties().getDimensionsProperties(dimension);
                this.keys[i] = new ConceptSelection(dimension.getConcept(), p.getAllReferenceData());
                this.keyRegistry.put(dimension.getConcept().getAcronym(), this.keys[i]);
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Selection getActionRequest() {
        Selection result = Selection.instance();
        ConceptSelection[] conceptSelectionArray = this.keys;
        int n = this.keys.length;
        int n2 = 0;
        while (n2 < n) {
            ConceptSelection dsel = conceptSelectionArray[n2];
            if (dsel.isNothingIncluded()) {
                if (((GuiSession)this.session).getDatasetProperties().getDimensionsProperties(dsel.getConcept()).getSelectionMode() != 0) {
                    result.set(dsel.getConcept(), dsel.getAll());
                }
            } else {
                result.set(dsel.getConcept(), dsel.getIncludes());
            }
            ++n2;
        }
        return result;
    }
}

