/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.gui.core.properties;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Observable;
import java.util.Vector;
import org.eclipse.jface.preference.PreferenceStore;
import org.fao.fi.fishstat.core.CoreCommons;
import org.fao.fi.fishstat.core.FSActions;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.Dimension;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.exceptions.TimeseriesServiceException;
import org.fao.fi.fishstat.gui.core.properties.ConceptProperties;
import org.fao.fi.fishstat.gui.core.properties.DimensionProperties;
import org.fao.fi.fishstat.gui.core.properties.MultiSortProperties;
import org.fao.fi.fishstat.gui.core.properties.TimeSeriesProperties;

public class DatasetProperties
extends Observable {
    private Dataset dataset;
    private PreferenceStore preferenceStore;
    private LinkedHashMap<Concept, DimensionProperties> dimensionsProperties = null;
    private LinkedHashMap<String, TimeSeriesProperties> timeSeriesProperties = null;
    private Vector<ConceptProperties> baseDesriptors = null;
    private FSActions actions = new FSActions();

    public DatasetProperties(Dataset d) {
        this.dataset = d;
        this.preferenceStore = new PreferenceStore(String.valueOf(CoreCommons.getWorkspacesManager().getCurrentWorkspace().getPropertiesDir().getAbsolutePath()) + File.separatorChar + this.dataset.getAcronym() + ".properties");
        try {
            this.checkPersistence();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.actions = new FSActions();
        this.initDimensions();
        this.initTimeseries();
        this.loadProperties(this.preferenceStore);
        this.rebuildBaseDescriptors();
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void addAction(Integer ... new_actions) {
        Integer[] integerArray = new_actions;
        int n = new_actions.length;
        int n2 = 0;
        while (n2 < n) {
            Integer action = integerArray[n2];
            this.actions.add(action);
            ++n2;
        }
        this.setChanged();
    }

    private void checkPersistence() throws IOException {
        try {
            this.preferenceStore.load();
        }
        catch (IOException e) {
            if (e instanceof FileNotFoundException) {
                this.preferenceStore.save();
            }
            throw e;
        }
    }

    private void initDimensions() {
        try {
            if (this.dimensionsProperties == null) {
                this.dimensionsProperties = new LinkedHashMap(this.dataset.getDimensions().size());
            } else {
                this.dimensionsProperties.clear();
            }
            int i = 0;
            while (i < this.dataset.getDimensions().size()) {
                Dimension dimension = (Dimension)this.dataset.getDimensions().get(i);
                this.dimensionsProperties.put(dimension.getConcept(), new DimensionProperties(this, dimension, i));
                ++i;
            }
        }
        catch (TimeseriesServiceException e) {
            e.printStackTrace();
        }
    }

    private void initTimeseries() {
        if (this.timeSeriesProperties == null) {
            this.timeSeriesProperties = new LinkedHashMap(this.dataset.getTimeseries().size());
        } else {
            this.timeSeriesProperties.clear();
        }
        for (Timeseries timeseries : this.dataset.getTimeseries()) {
            this.timeSeriesProperties.put(timeseries.getAcronym(), new TimeSeriesProperties(timeseries, this));
        }
    }

    public Collection<DimensionProperties> getDimensionsProperties() {
        return this.dimensionsProperties.values();
    }

    public DimensionProperties getDimensionsProperties(Dimension dimension) {
        return this.dimensionsProperties.get(dimension.getConcept());
    }

    public DimensionProperties getDimensionsProperties(Concept concept) {
        return this.dimensionsProperties.get(concept);
    }

    public TimeSeriesProperties getTimeSeriesProperties(String acronym) {
        return this.timeSeriesProperties.get(acronym);
    }

    public Collection<TimeSeriesProperties> getTimeSeriesProperties() {
        return this.timeSeriesProperties.values();
    }

    public int getDimensionsSize() {
        return this.dataset.getDimensions().size();
    }

    public PreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    public void loadProperties(PreferenceStore store) {
        for (DimensionProperties dimensionProperties : this.dimensionsProperties.values()) {
            dimensionProperties.loadProperties(store);
        }
        for (TimeSeriesProperties timeSeriesProperties : this.timeSeriesProperties.values()) {
            timeSeriesProperties.loadProperties(store);
        }
        this.notifyObservers();
    }

    public void reloadProperties() {
        this.initDimensions();
        this.initTimeseries();
        this.loadProperties(this.preferenceStore);
        this.rebuildBaseDescriptors();
        this.notifyObservers();
    }

    public void storeProperties() {
        for (DimensionProperties property : this.dimensionsProperties.values()) {
            property.storeProperties();
        }
        for (TimeSeriesProperties props : this.timeSeriesProperties.values()) {
            props.storeProperties();
        }
        this.commitProperties();
        this.actions.add(Integer.valueOf(42));
        this.rebuildBaseDescriptors();
        this.setChanged();
        this.notifyObservers();
    }

    public void commitProperties() {
        try {
            this.preferenceStore.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected synchronized void setChanged() {
        super.setChanged();
    }

    public int getDescriptorsSize() {
        return this.baseDesriptors.size();
    }

    private void rebuildBaseDescriptors() {
        int size = 0;
        for (DimensionProperties dp : this.dimensionsProperties.values()) {
            size += dp.getDescriptorsSize();
        }
        this.baseDesriptors = new Vector(size);
        for (DimensionProperties dp : this.dimensionsProperties.values()) {
            this.baseDesriptors.addAll(dp.getDescriptors());
        }
    }

    public ConceptProperties getDescriptor(int idx) {
        return this.baseDesriptors.get(idx);
    }

    @Override
    public void notifyObservers() {
        this.notifyObservers(this.actions);
        this.actions.clear();
    }

    public void replicateSortProperties(MultiSortProperties multiSortProperties) {
        for (TimeSeriesProperties tsProperties : this.timeSeriesProperties.values()) {
            if (tsProperties == multiSortProperties.getTimeSeriesProperties()) continue;
            tsProperties.setSorter(multiSortProperties.replicateProperties(tsProperties));
        }
    }

    public Dimension getDimensionBelonging(Concept concept) {
        for (Dimension dimension : this.dataset.getDimensions()) {
            if (!dimension.getConcept().equals(concept) && !dimension.getConcept().getParentConcepts().contains(concept)) continue;
            return dimension;
        }
        return null;
    }
}

