/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.document;

import java.util.Locale;
import org.eclipse.wst.xml.core.internal.commentelement.impl.CommentElementRegistry;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDataType;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.document.CMNodeUtil;
import org.eclipse.wst.xml.core.internal.document.CommentImpl;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeImpl;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.document.SourceValidator;
import org.eclipse.wst.xml.core.internal.document.TagAdapter;
import org.eclipse.wst.xml.core.internal.document.TextImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.ISourceGenerator;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class XMLGeneratorImpl
implements ISourceGenerator {
    private static final String CDATA_CLOSE = "]]>";
    private static final String CDATA_OPEN = "<![CDATA[";
    private static final String COMMENT_CLOSE = "-->";
    private static final String COMMENT_OPEN = "<!--";
    private static final String DOCTYPE_OPEN = "<!DOCTYPE";
    private static final String EMPTY_CLOSE = " />";
    private static final String END_OPEN = "</";
    private static XMLGeneratorImpl instance = null;
    private static final String PI_CLOSE = "?>";
    private static final String PI_OPEN = "<?";
    private static final String PUBLIC_ID = "PUBLIC";
    private static final String SSI_PREFIX = "ssi";
    private static final String SSI_TOKEN = "#";
    private static final String SYSTEM_ID = "SYSTEM";
    private static final String TAG_CLOSE = ">";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static synchronized ISourceGenerator getInstance() {
        if (instance == null) {
            instance = new XMLGeneratorImpl();
        }
        return instance;
    }

    private static void setTagName(Element element, String tagName) {
        if (element == null || tagName == null) {
            return;
        }
        ((ElementImpl)element).setTagName(tagName);
    }

    private XMLGeneratorImpl() {
    }

    public String generateAttrName(Attr attr) {
        if (attr == null) {
            return null;
        }
        String attrName = attr.getName();
        if (attrName == null) {
            return null;
        }
        if (attrName.startsWith("<%") && !attrName.endsWith("%>")) {
            return String.valueOf(attrName) + "%>";
        }
        if (((IDOMAttr)attr).isGlobalAttr() && CMNodeUtil.getAttributeDeclaration(attr) != null) {
            switch (this.getAttrNameCase(attr)) {
                case 1: {
                    attrName = attrName.toUpperCase(Locale.ENGLISH);
                    break;
                }
                case 2: {
                    attrName = attrName.toLowerCase(Locale.ENGLISH);
                    break;
                }
            }
        }
        return attrName;
    }

    public String generateAttrValue(Attr attr) {
        return this.generateAttrValue(attr, '\u0000');
    }

    public String generateAttrValue(Attr attr, char quote) {
        if (attr == null) {
            return null;
        }
        String name = attr.getName();
        SourceValidator validator = new SourceValidator(attr);
        String value = validator.convertSource(((IDOMNode)((Object)attr)).getValueSource());
        if (value == null || value.length() == 0) {
            if (name != null && name.startsWith("<%")) {
                return null;
            }
            if (this.isBooleanAttr(attr)) {
                if (((AttrImpl)attr).isXMLAttr()) {
                    value = attr.getName();
                } else {
                    return null;
                }
            }
        }
        return this.generateAttrValue(value, quote);
    }

    public String generateAttrValue(String value, char quote) {
        if (quote == '\"') {
            if (value != null && value.indexOf(34) >= 0) {
                quote = (char)39;
            }
        } else if (quote == '\'') {
            if (value != null && value.indexOf(39) >= 0) {
                quote = (char)34;
            }
        } else {
            quote = value != null && value.indexOf(34) < 0 ? (char)34 : (char)39;
        }
        int length = value == null ? 0 : value.length();
        StringBuffer buffer = new StringBuffer(length + 2);
        buffer.append(quote);
        if (value != null) {
            buffer.append(value);
        }
        buffer.append(quote);
        return buffer.toString();
    }

    public String generateCDATASection(CDATASection cdata) {
        if (cdata == null) {
            return null;
        }
        String data = cdata.getData();
        int length = data != null ? data.length() : 0;
        StringBuffer buffer = new StringBuffer(length + 16);
        buffer.append(CDATA_OPEN);
        if (data != null) {
            buffer.append(data);
        }
        buffer.append(CDATA_CLOSE);
        return buffer.toString();
    }

    public String generateChild(Node parentNode) {
        if (parentNode == null) {
            return null;
        }
        if (!parentNode.hasChildNodes()) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        Node child = parentNode.getFirstChild();
        while (child != null) {
            String childSource = this.generateSource(child);
            if (childSource != null) {
                buffer.append(childSource);
            }
            child = child.getNextSibling();
        }
        return buffer.toString();
    }

    public String generateCloseTag(Node node) {
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case 1: {
                ElementImpl element = (ElementImpl)node;
                if (element.isCommentTag()) {
                    if (element.isJSPTag()) {
                        return "--%>";
                    }
                    return COMMENT_CLOSE;
                }
                if (element.isJSPTag()) {
                    return "%>";
                }
                if (element.isEmptyTag()) {
                    return EMPTY_CLOSE;
                }
                return TAG_CLOSE;
            }
            case 8: {
                CommentImpl comment = (CommentImpl)node;
                if (comment.isJSPTag()) {
                    return "--%>";
                }
                return COMMENT_CLOSE;
            }
            case 10: {
                return TAG_CLOSE;
            }
            case 7: {
                return PI_CLOSE;
            }
            case 4: {
                return CDATA_CLOSE;
            }
        }
        return null;
    }

    public String generateComment(Comment comment) {
        if (comment == null) {
            return null;
        }
        String data = comment.getData();
        int length = data != null ? data.length() : 0;
        StringBuffer buffer = new StringBuffer(length + 8);
        CommentImpl impl = (CommentImpl)comment;
        if (!impl.isJSPTag()) {
            buffer.append(COMMENT_OPEN);
        } else {
            buffer.append("<%--");
        }
        if (data != null) {
            buffer.append(data);
        }
        if (!impl.isJSPTag()) {
            buffer.append(COMMENT_CLOSE);
        } else {
            buffer.append("--%>");
        }
        return buffer.toString();
    }

    public String generateDoctype(DocumentType docType) {
        if (docType == null) {
            return null;
        }
        String name = docType.getName();
        int length = name != null ? name.length() : 0;
        StringBuffer buffer = new StringBuffer(length + 16);
        buffer.append(DOCTYPE_OPEN);
        buffer.append(' ');
        if (name != null) {
            buffer.append(name);
        }
        DocumentTypeImpl dt = (DocumentTypeImpl)docType;
        String publicID = dt.getPublicId();
        String systemID = dt.getSystemId();
        if (publicID != null) {
            buffer.append(' ');
            buffer.append(PUBLIC_ID);
            buffer.append(' ');
            buffer.append('\"');
            buffer.append(publicID);
            buffer.append('\"');
            if (systemID != null) {
                buffer.append(' ');
                buffer.append('\"');
                buffer.append(systemID);
                buffer.append('\"');
            }
        } else if (systemID != null) {
            buffer.append(' ');
            buffer.append(SYSTEM_ID);
            buffer.append(' ');
            buffer.append('\"');
            buffer.append(systemID);
            buffer.append('\"');
        }
        buffer.append('>');
        return buffer.toString();
    }

    public String generateElement(Element element) {
        String endTag;
        String child;
        if (element == null) {
            return null;
        }
        ElementImpl impl = (ElementImpl)element;
        if (impl.preferEmptyTag()) {
            impl.setEmptyTag(true);
        }
        StringBuffer buffer = new StringBuffer();
        String startTag = this.generateStartTag(element);
        if (startTag != null) {
            buffer.append(startTag);
        }
        if ((child = this.generateChild(element)) != null) {
            buffer.append(child);
        }
        if ((endTag = this.generateEndTag(element)) != null) {
            buffer.append(endTag);
        }
        return buffer.toString();
    }

    public String generateEndTag(Element element) {
        String endTag;
        TagAdapter adapter;
        if (element == null) {
            return null;
        }
        ElementImpl impl = (ElementImpl)element;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.core.internal.document.TagAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (TagAdapter)impl.getExistingAdapter(clazz)) != null && (endTag = adapter.getEndTag(impl)) != null) {
            return endTag;
        }
        if (impl.isEmptyTag()) {
            return null;
        }
        if (!impl.isContainer()) {
            return null;
        }
        if (impl.isJSPTag()) {
            return "%>";
        }
        String tagName = this.generateTagName(element);
        int length = tagName != null ? tagName.length() : 0;
        StringBuffer buffer = new StringBuffer(length + 4);
        buffer.append(END_OPEN);
        if (tagName != null) {
            buffer.append(tagName);
        }
        buffer.append('>');
        return buffer.toString();
    }

    public String generateEntityRef(EntityReference entityRef) {
        if (entityRef == null) {
            return null;
        }
        String name = entityRef.getNodeName();
        int length = name != null ? name.length() : 0;
        StringBuffer buffer = new StringBuffer(length + 4);
        buffer.append('&');
        if (name != null) {
            buffer.append(name);
        }
        buffer.append(';');
        return buffer.toString();
    }

    public String generatePI(ProcessingInstruction pi) {
        int length;
        if (pi == null) {
            return null;
        }
        String target = pi.getTarget();
        String data = pi.getData();
        int n = length = target != null ? target.length() : 0;
        if (data != null) {
            length += data.length();
        }
        StringBuffer buffer = new StringBuffer(length + 8);
        buffer.append(PI_OPEN);
        if (target != null) {
            buffer.append(target);
        }
        buffer.append(' ');
        if (data != null) {
            buffer.append(data);
        }
        buffer.append(PI_CLOSE);
        return buffer.toString();
    }

    public String generateSource(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                return this.generateElement((Element)node);
            }
            case 3: {
                return this.generateText((Text)node);
            }
            case 8: {
                return this.generateComment((Comment)node);
            }
            case 10: {
                return this.generateDoctype((DocumentType)node);
            }
            case 7: {
                return this.generatePI((ProcessingInstruction)node);
            }
            case 4: {
                return this.generateCDATASection((CDATASection)node);
            }
            case 5: {
                return this.generateEntityRef((EntityReference)node);
            }
        }
        return this.generateChild(node);
    }

    public String generateStartTag(Element element) {
        String tagName;
        String startTag;
        TagAdapter adapter;
        Class<?> clazz;
        if (element == null) {
            return null;
        }
        ElementImpl impl = (ElementImpl)element;
        if (impl.isJSPTag()) {
            IDOMDocument document = (IDOMDocument)element.getOwnerDocument();
            if (document != null && document.isJSPType()) {
                if (document.isJSPDocument() && !impl.hasChildNodes()) {
                    impl.setJSPTag(false);
                }
            } else {
                impl.setJSPTag(false);
            }
        }
        if (impl.isCommentTag()) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.wst.xml.core.internal.document.TagAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (impl.getExistingAdapter(clazz2) == null) {
                CommentElementRegistry registry = CommentElementRegistry.getInstance();
                registry.setupCommentElement(impl);
            }
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.core.internal.document.TagAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (TagAdapter)impl.getExistingAdapter(clazz)) != null && (startTag = adapter.getStartTag(impl)) != null) {
            return startTag;
        }
        StringBuffer buffer = new StringBuffer();
        if (impl.isCommentTag()) {
            if (impl.isJSPTag()) {
                buffer.append("<%--");
            } else {
                buffer.append(COMMENT_OPEN);
            }
            tagName = this.generateTagName(element);
            if (tagName != null) {
                buffer.append(tagName);
            }
        } else if (impl.isJSPTag()) {
            buffer.append("<%");
            tagName = this.generateTagName(element);
            if (tagName != null) {
                buffer.append(tagName);
            }
            if (impl.isContainer()) {
                return buffer.toString();
            }
        } else {
            buffer.append('<');
            tagName = this.generateTagName(element);
            if (tagName != null) {
                buffer.append(tagName);
            }
        }
        NamedNodeMap attributes = element.getAttributes();
        int length = attributes.getLength();
        int i = 0;
        while (i < length) {
            AttrImpl attr = (AttrImpl)attributes.item(i);
            if (attr != null) {
                String attrValue;
                buffer.append(' ');
                String attrName = this.generateAttrName(attr);
                if (attrName != null) {
                    buffer.append(attrName);
                }
                if ((attrValue = this.generateAttrValue(attr)) != null) {
                    buffer.append('=');
                    buffer.append(attrValue);
                }
            }
            ++i;
        }
        String closeTag = this.generateCloseTag(element);
        if (closeTag != null) {
            buffer.append(closeTag);
        }
        return buffer.toString();
    }

    public String generateTagName(Element element) {
        if (element == null) {
            return null;
        }
        IDOMElement xe = (IDOMElement)element;
        String tagName = element.getTagName();
        if (tagName == null) {
            return null;
        }
        if (xe.isJSPTag()) {
            if (tagName.equals("jsp:expression")) {
                return "=";
            }
            if (tagName.equals("jsp:declaration")) {
                return "!";
            }
            if (tagName.equals("jsp:directive")) {
                return "@";
            }
            if (tagName.startsWith("jsp:directive")) {
                int offset = "jsp:directive".length() + 1;
                return "@" + tagName.substring(offset);
            }
            return xe.isCommentTag() ? tagName : null;
        }
        if (tagName.startsWith("<%")) {
            if (!tagName.endsWith("%>")) {
                return String.valueOf(tagName) + "%>";
            }
        } else if (xe.isCommentTag()) {
            String prefix = element.getPrefix();
            if (prefix.equals(SSI_PREFIX)) {
                return SSI_TOKEN + element.getLocalName();
            }
        } else if (!xe.isJSPTag() && xe.isGlobalTag() && CMNodeUtil.getElementDeclaration(xe) != null) {
            String newName = tagName;
            switch (this.getTagNameCase(xe)) {
                case 1: {
                    newName = tagName.toUpperCase(Locale.ENGLISH);
                    break;
                }
                case 2: {
                    newName = tagName.toLowerCase(Locale.ENGLISH);
                }
            }
            if (newName != tagName) {
                tagName = newName;
                XMLGeneratorImpl.setTagName(element, tagName);
            }
        }
        return tagName;
    }

    public String generateText(Text text) {
        if (text == null) {
            return null;
        }
        TextImpl impl = (TextImpl)text;
        String source = impl.getTextSource();
        if (source != null) {
            return source;
        }
        return this.generateTextData(text, impl.getData());
    }

    public String generateTextData(Text text, String data) {
        if (data == null) {
            return null;
        }
        if (text == null) {
            return null;
        }
        TextImpl impl = (TextImpl)text;
        if (impl.isJSPContent() || impl.isCDATAContent()) {
            return new SourceValidator(impl).convertSource(data);
        }
        String source = data;
        StringBuffer buffer = null;
        int offset = 0;
        int length = data.length();
        int i = 0;
        while (i < length) {
            String name = this.getCharName(data.charAt(i));
            if (name != null) {
                if (buffer == null) {
                    buffer = new StringBuffer(length + 8);
                }
                if (i > offset) {
                    buffer.append(data.substring(offset, i));
                }
                buffer.append('&');
                buffer.append(name);
                buffer.append(';');
                offset = i + 1;
            }
            ++i;
        }
        if (buffer != null) {
            if (length > offset) {
                buffer.append(data.substring(offset));
            }
            source = buffer.toString();
        }
        if (source == null || source.length() == 0) {
            return null;
        }
        return source;
    }

    private int getAttrNameCase(Attr attr) {
        DocumentTypeAdapter adapter;
        DocumentImpl document = (DocumentImpl)attr.getOwnerDocument();
        if (document == null) {
            return 0;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (DocumentTypeAdapter)document.getAdapterFor(clazz)) == null) {
            return 0;
        }
        return adapter.getAttrNameCase();
    }

    private String getCharName(char c) {
        switch (c) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '&': {
                return "amp";
            }
            case '\"': {
                return "quot";
            }
        }
        return null;
    }

    private int getTagNameCase(Element element) {
        DocumentTypeAdapter adapter;
        DocumentImpl document = (DocumentImpl)element.getOwnerDocument();
        if (document == null) {
            return 0;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (DocumentTypeAdapter)document.getAdapterFor(clazz)) == null) {
            return 0;
        }
        return adapter.getTagNameCase();
    }

    private boolean isBooleanAttr(Attr attr) {
        if (attr == null) {
            return false;
        }
        CMAttributeDeclaration decl = CMNodeUtil.getAttributeDeclaration(attr);
        if (decl == null) {
            return false;
        }
        CMDataType type = decl.getAttrType();
        if (type == null) {
            return false;
        }
        String[] values = type.getEnumeratedValues();
        if (values == null) {
            return false;
        }
        return values.length == 1 && values[0].equals(decl.getAttrName());
    }
}

