/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fao.fi.fishstat.data.timeseries.api.MeasureStatus;

public class FIESMeasureSymbol
extends MeasureStatus {
    private static final String ZERO_VALUE = "0";
    private static final String DOT_VALUE = ".";
    private static final String TRIPLE_DOT_VALUE = "...";
    private static final String DASH_VALUE = "-";
    private static final String F_VALUE = "F";
    private static final String R_VALUE = "R";
    private static final String NOT_SPECIFIED_VALUE = "";
    private static final List<String> VALUES = Arrays.asList("0", ".", "...", "-", "F", "R", "");
    public static final FIESMeasureSymbol ZERO = new FIESMeasureSymbol("0");
    public static final FIESMeasureSymbol DOT = new FIESMeasureSymbol(".");
    public static final FIESMeasureSymbol TRIPLE_DOT = new FIESMeasureSymbol("...");
    public static final FIESMeasureSymbol DASH = new FIESMeasureSymbol("-");
    public static final FIESMeasureSymbol F = new FIESMeasureSymbol("F");
    public static final FIESMeasureSymbol R = new FIESMeasureSymbol("R");
    public static final FIESMeasureSymbol NOT_SPECIFIED = new FIESMeasureSymbol("");
    private static final Map<String, FIESMeasureSymbol> STATUS = new HashMap<String, FIESMeasureSymbol>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(FIESMeasureSymbol.ZERO_VALUE, ZERO);
            this.put(FIESMeasureSymbol.DOT_VALUE, DOT);
            this.put(FIESMeasureSymbol.TRIPLE_DOT_VALUE, TRIPLE_DOT);
            this.put(FIESMeasureSymbol.DASH_VALUE, DASH);
            this.put(FIESMeasureSymbol.F_VALUE, F);
            this.put(FIESMeasureSymbol.R_VALUE, R);
            this.put(FIESMeasureSymbol.NOT_SPECIFIED_VALUE, NOT_SPECIFIED);
        }
    };

    protected FIESMeasureSymbol(String value) {
        super(value);
    }

    public static FIESMeasureSymbol valueOf(String value) {
        if (!VALUES.contains(value)) {
            throw new IllegalArgumentException(String.valueOf(value) + " is not a valid FAO-FIES measure status");
        }
        return STATUS.get(value);
    }
}

