/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api.calculated.functions;

import java.lang.reflect.Constructor;
import java.util.HashSet;
import java.util.Set;
import org.fao.fi.fishstat.data.common.Commons;
import org.fao.fi.fishstat.data.reference.api.Concept;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.calculated.functions.Function;
import org.fao.fi.fishstat.data.timeseries.api.exceptions.TimeseriesServiceException;

public class FunctionFactory {
    private static final String FST_FUNCTION = "FST_FUNCTION";
    private static final String DEFAULT_FUNCTION_PACKAGE = "org.fao.fi.fishstat.data.timeseries.api.calculated.functions.impl.";

    private static Concept getFunctionConcept() {
        return ReferenceServiceFactory.getService().getConcept(FST_FUNCTION);
    }

    public static Set<Function> getAvailableFunctions() throws TimeseriesServiceException {
        HashSet<Function> functions = new HashSet<Function>();
        for (ReferenceObject function : FunctionFactory.getFunctionConcept().getObjects()) {
            functions.add(FunctionFactory.getFunction(function));
        }
        return functions;
    }

    private static Function getFunction(ReferenceObject function) throws TimeseriesServiceException {
        if (function == null) {
            throw new IllegalArgumentException("Function can not be null");
        }
        if (function.getConcept() == null) {
            throw new IllegalArgumentException("Function concept can not be null");
        }
        if (!function.getConcept().equals(FunctionFactory.getFunctionConcept())) {
            throw new IllegalArgumentException("Not a function object");
        }
        try {
            String acronym = (String)function.getAttribute("ACRONYM");
            String class_name = DEFAULT_FUNCTION_PACKAGE + Commons.getJavaName((String)acronym);
            Class<?> clazz = Class.forName(class_name);
            Constructor<?> constructor = clazz.getConstructor(ReferenceObject.class);
            Function result = (Function)constructor.newInstance(function);
            return result;
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get the requested function: " + function, e);
        }
    }

    public static Function getFunction(String acronym) throws TimeseriesServiceException {
        ReferenceObject function;
        try {
            function = FunctionFactory.getFunctionConcept().getObject("ACRONYM", (Object)acronym);
        }
        catch (Exception e) {
            throw new TimeseriesServiceException("Unable to get the requested function: " + acronym, e);
        }
        if (function == null) {
            throw new TimeseriesServiceException("Unable to find the requested function: " + acronym);
        }
        return FunctionFactory.getFunction(function);
    }
}

