/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api.calculated.functions.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.fao.fi.fishstat.data.common.api.MultilingualString;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.reference.api.Relationship;
import org.fao.fi.fishstat.data.timeseries.api.calculated.functions.Function;
import org.fao.fi.fishstat.data.timeseries.api.calculated.parameters.Parameter;
import org.fao.fi.fishstat.data.timeseries.api.calculated.parameters.impl.ParameterImpl;

public abstract class FunctionBase
implements Function {
    private static final String FST_FUNCTION_PARAMETER = "FST_FUNCTION_PARAMETER";
    private static final Map<Function, Map<String, Parameter>> parameters = Collections.synchronizedMap(new HashMap());
    private ReferenceObject function;

    public FunctionBase() {
        this.function = null;
    }

    public FunctionBase(ReferenceObject function) {
        this.function = function;
    }

    private Map<String, Parameter> getParametersMap() {
        if (parameters.get(this) == null) {
            Relationship relationship = ReferenceServiceFactory.getService().getRelationship(FST_FUNCTION_PARAMETER);
            Set params = relationship.getChildren(this.function);
            HashMap<String, ParameterImpl> function_parameters = new HashMap<String, ParameterImpl>();
            for (ReferenceObject param : params) {
                function_parameters.put((String)param.getAttribute("ACRONYM"), new ParameterImpl(param, this));
            }
            parameters.put(this, function_parameters);
        }
        return parameters.get(this);
    }

    @Override
    public String getAcronym() {
        return this.function == null ? null : (String)this.function.getAttribute("ACRONYM");
    }

    @Override
    public MultilingualString getName() {
        return this.function == null ? null : (MultilingualString)this.function.getAttribute("NAME");
    }

    @Override
    public MultilingualString getDescription() {
        return this.function == null ? null : (MultilingualString)this.function.getAttribute("DESCRIPTION");
    }

    @Override
    public Parameter getParameter(String acronym) {
        if (acronym == null) {
            throw new IllegalArgumentException("Parameter acronym can not be null");
        }
        return this.getParametersMap().get(acronym);
    }

    @Override
    public Collection<Parameter> getParameters() {
        return this.getParametersMap().values();
    }

    public String[] getParameterEnumeratedValues(Parameter parameter) {
        return null;
    }

    public boolean isValidParameterValue(Parameter parameter, String value) {
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.function == null ? 0 : this.function.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Function)) {
            return false;
        }
        Function other = (Function)obj;
        return !(this.getAcronym() == null ? other.getAcronym() != null : !this.getAcronym().equals(other.getAcronym()));
    }

    public String toString() {
        return String.valueOf(this.function);
    }
}

