/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api.calculated.test;

import java.util.List;
import org.fao.fi.fishstat.data.common.utils.JUnitTestHelper;
import org.fao.fi.fishstat.data.common.utils.Timer;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.Dataset;
import org.fao.fi.fishstat.data.timeseries.api.ObservationPeriod;
import org.fao.fi.fishstat.data.timeseries.api.ObservationSeries;
import org.fao.fi.fishstat.data.timeseries.api.Timeseries;
import org.fao.fi.fishstat.data.timeseries.api.TimeseriesServiceFactory;
import org.fao.fi.fishstat.data.timeseries.api.TopCriteria;
import org.fao.fi.fishstat.data.timeseries.api.calculated.CalculatedMeasureDefinition;
import org.fao.fi.fishstat.data.timeseries.api.calculated.CalculatedMeasureDefinitionFactory;
import org.fao.fi.fishstat.data.timeseries.api.calculated.functions.FunctionFactory;
import org.junit.BeforeClass;
import org.junit.Test;

public class TimeseriesCalculatedObservationsWithTopOthersTestCase {
    private static Dataset dataset;
    private static Timeseries timeseries;

    @BeforeClass
    public static void setUp() throws Exception {
        JUnitTestHelper.setTestActiveWorkspace();
        dataset = TimeseriesServiceFactory.getService().getDataset("AQUACULTURE");
        timeseries = dataset.getTimeseries("QUANTITY");
    }

    @Test
    public void testCalculateTopOthersNumber() throws Exception {
        ReferenceObject measure = ReferenceServiceFactory.getService().getConcept("MEASURE").getObject("CODE", (Object)"Q_t_1");
        TopCriteria criteria = new TopCriteria(measure, TopCriteria.CriteriaType.TOP_RECORDS_NUMBER, 3.0);
        System.out.println("calculating top others (number)...");
        Timer.start();
        timeseries.aggregate(criteria, new ObservationPeriod("Y2000"));
        Timer.stop();
        List<ObservationSeries> result = timeseries.getObservations();
        System.out.println("found: " + result.size() + " in " + Timer.timeElapsed() + "msec\n");
        for (ObservationSeries series : result) {
            System.out.println(series);
        }
    }

    @Test
    public void testAddTwoCalculatedArithmeticMean() throws Exception {
        CalculatedMeasureDefinition definition = CalculatedMeasureDefinitionFactory.create("Max");
        definition.setFunction(FunctionFactory.getFunction("MAX"));
        definition.setPeriods(timeseries.getObservationPeriods());
        timeseries.addCalculatedMeasureDefinition(definition);
        definition = CalculatedMeasureDefinitionFactory.create("Other max");
        definition.setFunction(FunctionFactory.getFunction("MAX"));
        definition.setPeriods(timeseries.getObservationPeriods());
        timeseries.addCalculatedMeasureDefinition(definition);
        definition = CalculatedMeasureDefinitionFactory.create("Mean");
        definition.setFunction(FunctionFactory.getFunction("ARITHMETIC_MEAN"));
        definition.setPeriods(timeseries.getObservationPeriods());
        timeseries.addCalculatedMeasureDefinition(definition);
        System.out.println("With calculated measures:");
        for (ObservationSeries series : timeseries.getObservations()) {
            System.out.println(series);
        }
    }
}

