/*
 * Decompiled with CFR 0.152.
 */
package org.fao.fi.fishstat.data.timeseries.api.impl;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.fao.fi.fishstat.data.reference.api.MultiReferenceObject;
import org.fao.fi.fishstat.data.reference.api.ReferenceObject;

public class CartesianProduct
extends AbstractList<MultiReferenceObject> {
    protected MultiReferenceObject[] dims;
    protected int[] indexMultipliers;
    protected int size;

    public CartesianProduct(List<MultiReferenceObject> dimList) {
        this.dims = dimList.toArray(new MultiReferenceObject[dimList.size()]);
        this.indexMultipliers = new int[this.dims.length];
        int multiplier = 1;
        int i = this.dims.length - 1;
        while (i >= 0) {
            this.indexMultipliers[i] = multiplier;
            multiplier *= this.dims[i].size();
            --i;
        }
        this.size = multiplier;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<MultiReferenceObject> iterator() {
        return new ProductListIterator();
    }

    @Override
    public ListIterator<MultiReferenceObject> listIterator() {
        return new ProductListIterator();
    }

    @Override
    public ListIterator<MultiReferenceObject> listIterator(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return new ProductListIterator(index);
    }

    @Override
    public MultiReferenceObject get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        ReferenceObject[] tuple = new ReferenceObject[this.dims.length];
        int i = 0;
        while (i < this.dims.length) {
            int thisDimIndex = index / this.indexMultipliers[i];
            tuple[i] = this.dims[i].elementAt(thisDimIndex);
            index %= this.indexMultipliers[i];
            ++i;
        }
        return new MultiReferenceObject(tuple);
    }

    public int indexOf(MultiReferenceObject o) {
        if (o.size() == this.dims.length) {
            int index = 0;
            int i = 0;
            while (i < this.dims.length) {
                int thisDimIndex = this.dims[i].indexOf(o.elementAt(i));
                if (thisDimIndex == -1) {
                    return -1;
                }
                index += thisDimIndex * this.indexMultipliers[i];
                ++i;
            }
            return index;
        }
        return -1;
    }

    private class ProductListIterator
    implements ListIterator<MultiReferenceObject> {
        int nextIndex = 0;
        ListIterator<ReferenceObject>[] listIters;
        ReferenceObject[] latestTuple;

        ProductListIterator() {
            this.listIters = new ListIterator[CartesianProduct.this.dims.length];
            this.latestTuple = new ReferenceObject[CartesianProduct.this.dims.length];
            int i = 0;
            while (i < CartesianProduct.this.dims.length) {
                this.listIters[i] = CartesianProduct.this.dims[i].listIterator();
                if (i < CartesianProduct.this.dims.length - 1 && this.listIters[i].hasNext()) {
                    this.latestTuple[i] = this.listIters[i].next();
                }
                ++i;
            }
        }

        ProductListIterator(int index) {
            this.listIters = new ListIterator[CartesianProduct.this.dims.length];
            this.latestTuple = new ReferenceObject[CartesianProduct.this.dims.length];
            this.nextIndex = index;
            if (this.nextIndex == CartesianProduct.this.size) {
                int i = 0;
                while (i < CartesianProduct.this.dims.length) {
                    this.listIters[i] = CartesianProduct.this.dims[i].listIterator(CartesianProduct.this.dims[i].size());
                    if (i < CartesianProduct.this.dims.length - 1 && this.listIters[i].hasPrevious()) {
                        this.latestTuple[i] = this.listIters[i].previous();
                        this.listIters[i].next();
                    }
                    ++i;
                }
            } else {
                int i = 0;
                while (i < CartesianProduct.this.dims.length) {
                    int thisDimIndex = index / CartesianProduct.this.indexMultipliers[i];
                    this.listIters[i] = CartesianProduct.this.dims[i].listIterator(thisDimIndex);
                    if (i < CartesianProduct.this.dims.length - 1 && this.listIters[i].hasNext()) {
                        this.latestTuple[i] = this.listIters[i].next();
                    }
                    index %= CartesianProduct.this.indexMultipliers[i];
                    ++i;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < CartesianProduct.this.size;
        }

        @Override
        public MultiReferenceObject next() {
            if (this.nextIndex >= CartesianProduct.this.size) {
                throw new NoSuchElementException();
            }
            boolean done = CartesianProduct.this.dims.length == 0;
            int i = CartesianProduct.this.dims.length - 1;
            while (!done) {
                if (this.listIters[i].hasNext()) {
                    done = true;
                } else {
                    this.listIters[i] = CartesianProduct.this.dims[i].listIterator();
                }
                this.latestTuple[i] = this.listIters[i].next();
                --i;
            }
            ++this.nextIndex;
            return new MultiReferenceObject(this.latestTuple);
        }

        @Override
        public boolean hasPrevious() {
            return this.nextIndex > 0;
        }

        @Override
        public MultiReferenceObject previous() {
            if (this.nextIndex == 0) {
                throw new NoSuchElementException();
            }
            boolean done = CartesianProduct.this.dims.length == 0;
            int i = CartesianProduct.this.dims.length - 1;
            while (!done) {
                if (i < CartesianProduct.this.dims.length - 1) {
                    this.listIters[i].previous();
                }
                if (this.listIters[i].hasPrevious()) {
                    done = true;
                } else {
                    this.listIters[i] = CartesianProduct.this.dims[i].listIterator(CartesianProduct.this.dims[i].size());
                }
                this.latestTuple[i] = this.listIters[i].previous();
                if (i < CartesianProduct.this.dims.length - 1) {
                    this.listIters[i].next();
                }
                --i;
            }
            --this.nextIndex;
            return new MultiReferenceObject(this.latestTuple);
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void add(MultiReferenceObject e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(MultiReferenceObject e) {
            throw new UnsupportedOperationException();
        }
    }
}

